{************************************************************************
*									*
*  News_Check: routines to check the NEWS system for unread news.	*
*									*
*.......................................................................*
*									*
*  Written in VAX Pascal for VAX/VMS machines.				*
*									*
*  Author:  Jonathan Ridler,						*
*	    University Computing Services,				*
*	    University of Melbourne.					*
*									*
*  Created: March, 1988.						*
*									*
************************************************************************}

[INHERIT ('SYS$LIBRARY:STARLET')]

MODULE News_Checker (OUTPUT) ;


[GLOBAL] PROCEDURE News_Check (Newsgroup : VARYING [News_Len] OF CHAR) ;

{ Accept a newsgroup name and indicate if there is any unread news. }

   CONST

   PAS$K_EOF	   = -1 ;
   PAS$K_SUCCESS   = 0 ;
   PAS$K_FILNOTFOU = 3 ;

   Subjlen = 50 ;		{ Max Length of newsgroup name in NEWSDEFINE.H }

   TYPE

   Ubyte = [BYTE] 0..255 ;
   Uword = [BYTE(2)] 0..65535 ;

   Grp_Rec =  RECORD
		Grp_Nam : [Key(0)] PACKED ARRAY [1..Subjlen] OF CHAR ;
		Grp_Num : [Key(1)] Uword ;
		Grp_Topnum , Grp_Count : Uword ;
		Grp_Credate , Grp_Entdate : INTEGER ;
		Grp_Life , Grp_Itmlife : Uword ;
		Grp_Unused : CHAR ;
		Grp_Reg : Ubyte ;
		Grp_Unread : Uword ;
		Misc_Filler : PACKED ARRAY [0..36] OF CHAR ;
	      END ;

   VAR

   Rst : UNSIGNED ;

   First_Unread , Inx : INTEGER ;

   Comp : PACKED ARRAY [1..Subjlen] OF CHAR ;

   Group : VARYING [Subjlen] OF CHAR ;
   Info : VARYING [512] OF CHAR ;

   G : Grp_Rec ;

   Group_File : FILE OF Grp_Rec ;

   Register_File : TEXT ;

  BEGIN
  IF Newsgroup = ''  THEN
     WRITELN ('News_Scan: No newsgroup specified.')
   ELSE
     BEGIN
     Comp := ZERO ;
     FOR Inx := 1 TO News_Len  DO
	 BEGIN
	 IF (Newsgroup[Inx] >= 'A') AND (Newsgroup[Inx] <= 'Z')  THEN
	    Newsgroup[Inx] := CHR (ORD(Newsgroup[Inx]) + 32) ;
	 Comp[Inx] := Newsgroup[Inx] ;
	 END ;

     OPEN (Group_File,FILE_NAME:='NEWS_ROOT:NEWSGROUPS.V50',HISTORY:=Old,
		      SHARING:=READWRITE,ACCESS_METHOD:=KEYED,Error:=CONTINUE) ;
     Rst := STATUS (Group_File) ;
     IF Rst <> PAS$K_SUCCESS  THEN
	IF Rst = PAS$K_FILNOTFOU  THEN
	   WRITELN ('News_Scan: News System file not found.')
	 ELSE
	   WRITELN ('News_Scan: Error ',HEX(Rst),' opening News System file.')
      ELSE
	BEGIN
	RESETK (Group_File,0,Error:=CONTINUE) ;
	Rst := STATUS (Group_File) ;
	IF Rst <> PAS$K_SUCCESS  THEN
	   WRITELN ('News_Scan: Error ',HEX(Rst),' resetting News System file.')
	 ELSE
	   BEGIN
	   FINDK (Group_File,0,Comp,Error:=CONTINUE) ;
	   Rst := STATUS (Group_File) ;
	   IF Rst <> PAS$K_SUCCESS  THEN
	      WRITELN ('News_Scan: Error ',HEX(Rst),
		       ' finding News System file.')
	    ELSE
	   IF UFB (Group_File)  THEN
	      WRITELN ('News_Scan: Unknown newsgroup: ',Newsgroup)
	    ELSE
	      BEGIN
	      G := ZERO ;
	      READ (Group_File,G) ;

	      OPEN (Register_File,FILE_NAME:='SYS$LOGIN:NEWS_GROUPS.REGISTER',
		    HISTORY:=Old,Record_Length:=512,Error:=CONTINUE) ;
	      Rst := STATUS (Register_File) ;
	      IF Rst <> PAS$K_SUCCESS  THEN
	         IF Rst = PAS$K_FILNOTFOU  THEN
		    BEGIN
		    IF G.Grp_Count > 0  THEN
		       WRITELN ('You have unread news items in newsgroup ',
				 Newsgroup) ;
		    END
	          ELSE
		    WRITELN('News_Scan: Error ',HEX(Rst),
			    ' opening Register file.')
	       ELSE
	         BEGIN
	         RESET (Register_File,Error:=CONTINUE) ;
		 Rst := STATUS (Register_File) ;
		 IF Rst <> PAS$K_SUCCESS  THEN
		    WRITELN ('News_Scan: Error ',HEX(Rst),
			     ' resetting Register file.')
		  ELSE
		 IF EOF (Register_File) THEN
		    WRITELN ('News_Scan: Invalid Register file.')
		  ELSE
		    BEGIN		{ Context info only in rec #1 }
	            READLN (Register_File,Error:=CONTINUE) ;
		    Rst := STATUS (Register_File) ;
		    IF Rst <> PAS$K_SUCCESS  THEN
		       IF Rst = PAS$K_EOF  THEN
			  WRITELN ('News_Scan: Invalid Register file.')
			ELSE
			  WRITELN ('News_Scan: Error ',HEX(Rst),
				   ' reading Register file.')
		     ELSE
		       BEGIN
	               Info  := '' ;
	               Group := '' ;
	               WHILE (Group <> Newsgroup) AND NOT EOF (Register_File) DO
		         BEGIN
		         READLN (Register_File,Info,Error:=CONTINUE) ;
			 Rst := STATUS (Register_File) ;
			 IF (Rst <> PAS$K_SUCCESS) AND (Rst <> PAS$K_EOF)  THEN
			    BEGIN
			    WRITELN ('News_Scan: Error ',HEX(Rst),
				     ' reading News Register file.') ;
			    Group := Newsgroup ;	{ Drop out of loop }
			    Info := '' ;		{ Invalidate below }
			    G.Grp_Count := 0 ;		{ Avoid false message }
			    END
			  ELSE
			    BEGIN
		            Inx := FIND_MEMBER (Info,[':']) ;
		            IF Inx > 1  THEN
		               Group := SUBSTR (Info,1,Inx-1)
		             ELSE
			       Group := '' ;
			    END ;
		         END ;

	               CLOSE (Register_File,Error:=CONTINUE) ;
	               IF (Group = Newsgroup) AND (Info.LENGTH > 0)  THEN
		          BEGIN
		          Inx := FIND_MEMBER(Info,['<']) ;
		          IF Inx = 0  THEN
			     WRITELN ('News_Scan: Invalid Register file entry.')
			   ELSE
			     BEGIN
			     READV (SUBSTR (Info,Inx+1,Info.LENGTH-Inx),
				    First_Unread,Error:=CONTINUE) ;
			     IF STATUSV <> PAS$K_SUCCESS  THEN
			        WRITELN ('News_Scan: Invalid Register ',
					 'file entry.')
			      ELSE
			     IF (First_Unread < G.Grp_Topnum) AND
			        (G.Grp_Count > 0)  THEN
			          WRITELN ('You have unread news items in ',
				           'newsgroup ',Newsgroup) ;
			     END ;
		          END
	                ELSE
	               IF G.Grp_Count > 0  THEN
		          WRITELN ('You have unread news items in newsgroup ',
			           Newsgroup);
		       END ;
		    END ;
	         END ;
	      END ;
	   END ;

	CLOSE (Group_File,Error:=CONTINUE) ;
	END ;
     END ;
  END ;		{ of News_Check }


[GLOBAL] PROCEDURE Newscheck ;

{ Check any number of newsgroups for unread news items.  Designed to be called
  at login by the local FORTRAN login image. }

  BEGIN		{ Newscheck }
  News_Check ('ucs.news') ;
  END ;		{ of Newscheck }

END.
