#module NEWSCREATE "V5.6"

/*
**++
**  FACILITY:
**
**      NEWSCREATE.C
**
**  ABSTRACT:
**
**      Create new newsgropups (manager function)
**
**  AUTHOR:
**
**      Geoff Huston
**
**  COPYRIGHT:
**
**      Copyright  1988
**
**  MODIFICATION HISTORY:
**
**      V5.5     7-Oct-1988     GIH
**          Add conditional (and untested) WIN/TCP support
**          Correct bugs with /inquire support
**      V5.6    11-Nov-1988     GIH
**          Add support for RESTRICT and WRITE qualifiers
**--
**/

#include "newsinclude.h"
#include "newsdefine.h"
#include "newsextern.h"

/*
 * do_cregrp
 *
 * Create a new (empty) newsgroup
 */

do_cregrp()
{
    char s[512],
         hold[132],
         itemhold[132],
         mod[132],
         delstr[132],
         oldsub[SUBJLEN],
         mod_add[132],
         mod_prompt[132],
         filehold[132],
         srv[132],
         protocol[132],
         *modlist = 0,
         sincestr[132],
         restrict[132];
    int g,
        i,
        old_lev,
        hold_pres = 0,
        itemhold_pres = 0,
        mod_pres = 0,
        filehold_pres = 0,
        server_pres = 0,
        keep_pres = 0,
        protocol_pres = 0,
        protocol_val = 0,
        inquire = 0,
        cur_time,
        glob_iexp_val,
        glob_iexp_time,
        server_call = 0,
        since_time,
        restrict_pres = 0,
        write_pres = 0;
    unsigned short hold_len,
                   itemhold_len,
                   hold_val,
                   itemhold_val,
                   cre_grp[500],
                   mod_len,
                   filehold_len,
                   filehold_val,
                   srv_len,
                   protocol_len,
                   since_len,
                   restrict_len;
    $DESCRIPTOR(hold_dsc,hold);
    $DESCRIPTOR(itemhold_dsc,itemhold);
    $DESCRIPTOR(mod_dsc,mod);
    $DESCRIPTOR(filehold_dsc,filehold);
    $DESCRIPTOR(srv_dsc,srv);
    $DESCRIPTOR(protocol_dsc,protocol);
    $DESCRIPTOR(since_dsc,sincestr);
    $DESCRIPTOR(restrict_dsc,restrict);

    if (no_priv()) return(err_line("\tError: Create - No Priv\n"),0);

    clear_gl();
    auto_cre_grp = 1;
    old_lev = news_context;
    parse_newsgroups(s,"",0);
    if (inquire = cli$present(c$dsc("INQUIRE")) & 1) {
        if (!*s) strcpy(s,"*");
        since_time = 0;
        if (cli$present(c$dsc("SINCE"),&since_dsc,&since_len) & 1) {
            sincestr[since_len] = '\0';
            since_time = cvt_date_val(sincestr);
            }
        }
    else {
        if (!*s) return(0);
        do_new_group(s,1,cre_grp);
        if (!*cre_grp) {
            err_line("\tInfo: Create - No newsgroup created\n");
            return(0);
            }
        }
    if ((status = cli$present(c$dsc("RESTRICT"))) & 1) {
        while (cli$get_value(c$dsc("RESTRICT"),&restrict_dsc,&restrict_len) & 1) {
            if (toupper(*restrict == 'M')) {
                restrict_pres = 1;
                break;
                }
            }
        }
    else if (status == CLI$_NEGATED) {
        while (cli$get_value(c$dsc("RESTRICT"),&restrict_dsc,&restrict_len) & 1) {
            if (toupper(*restrict == 'M')) {
                restrict_pres = -1;
                break;
                }
            }
        }
    if ((status = cli$present(c$dsc("WRITE"))) & 1) write_pres = 1;
    else if (status == CLI$_NEGATED) write_pres = -1;
    if (cli$present(c$dsc("HOLD")) & 1) {
        hold_pres = 1;
        cli$get_value(c$dsc("HOLD"),&hold_dsc,&hold_len);
        hold[hold_len] = '\0';
        if (!strcmp(hold,"*")) hold_val = ~0 ;
        else if (sscanf(hold,"%hd",&hold_val) != 1) {
            err_line("\tError: Create - /HOLD=val not an integer\n");
            hold_pres = 0;
            }
        }
    if (cli$present(c$dsc("ITEMHOLD")) & 1) {
        itemhold_pres = 1;
        cli$get_value(c$dsc("ITEMHOLD"),&itemhold_dsc,&itemhold_len);
        itemhold[itemhold_len] = '\0';
        if (!strcmp(itemhold,"*")) itemhold_val = ~0 ;
        else if (sscanf(itemhold,"%hd",&itemhold_val) != 1) {
            err_line("\tError: Create - /ITEMHOLD=val not an integer\n");
            itemhold_pres = 0;
            }
        }
    if (cli$present(c$dsc("FILEHOLD")) & 1) {
        filehold_pres = 1;
        if (!(cli$get_value(c$dsc("FILEHOLD"),&filehold_dsc,&filehold_len) & 1)) filehold_val = ga[0]->grp_loccoplife;
        else {
            filehold[filehold_len] = '\0';
            if (sscanf(filehold,"%hd",&filehold_val) != 1) {
                err_line("\tError: Create - /FILEHOLD=val not an integer\n");
                filehold_pres = 0;
                }
            }
        }
    if (cli$present(c$dsc("PROTOCOL")) & 1) {
        protocol_pres = 1;
        if (!(cli$get_value(c$dsc("PROTOCOL"),&protocol_dsc,&protocol_len) & 1)) protocol_val = 0;
        else {
            protocol[protocol_len] = '\0';
            protocol[protocol_len] = '\0';
            if (!protocol_len) protocol_val = 0;
            else if (!strncmp(protocol,"CMUTCP",protocol_len))
                protocol_val= 1;
            else if (!strncmp(protocol,"WINTCP",protocol_len))
                protocol_val= 2;
            else if (!strncmp(protocol,"TCP",protocol_len))
#ifdef TWG
                protocol_val= 2;
#else
                protocol_val= 1;
#endif
            else protocol_val = 0;
            }
        }
    else protocol_val = ga[0]->grp_srvproto;

    if ((status = cli$present(c$dsc("MODERATOR"))) & 1) mod_pres = 1;
    else if (status == CLI$_NEGATED) mod_pres = -1;
    if ((status = cli$present(c$dsc("SERVER"))) & 1) {
        server_pres = 1;
        srv_len = 0;
        if (cli$get_value(c$dsc("SERVER"),&srv_dsc,&srv_len) & 1) srv[srv_len] = '\0';
        if (!srv_len) get_input_dflt(&srv_dsc,c$dsc("SERVER Node: "),&srv_len,( *(ga[0]->grp_server) ? c$dsc(ga[0]->grp_server) : 0),0);
        if (!srv_len) server_pres = -1;
        if (srv_len > 6) srv_len = 6;
        srv[srv_len] = '\0';
        }
    else {
        if (status == CLI$_NEGATED) server_pres = -1;
        strncpy(srv,ga[0]->grp_server,8);
        srv[8] = '\0';
        }
    if ((status = cli$present(c$dsc("KEEPREQUEST"))) & 1) keep_pres = 1;
    else if (status == CLI$_NEGATED) keep_pres = -1;

    if (inquire) {
        char *response,
             *srvgrps,
             *cp1,*cp2,*cp3,*cp4,
             newsg[132],
             mod[132];
        int first,
            last;

        server_pres = 1;
        mod_pres = 0;
        if (!srv_len) {
            get_input_dflt(&srv_dsc,c$dsc("SERVER Node: "),&srv_len,( *(ga[0]->grp_server) ? c$dsc(ga[0]->grp_server) : 0),0);
            if (!srv_len) return(0);
            if (srv_len > 6) srv_len = 6;
            srv[srv_len] = '\0';
            if (!protocol_pres) {
                get_input_dflt(&protocol_dsc,c$dsc("Protocol: "),&protocol_len,(protocol_val ? c$dsc("DECNET") : c$dsc("TCP")),0);
                protocol[protocol_len] = '\0';
                if (strcmp(protocol,"TCP")) protocol_val = 0;
                else protocol_val = 1;
                }
            }
        protocol_pres = 1;
        response = server_get_newsgroups(srv,protocol_val,since_time);
        if (!response) {
            sprintf(err_oline,"\tCreate - No served newsgroups response fron %s::\n",srv);
            err_line(err_oline);
            return(0);
            }
        srvgrps = malloc(strlen(response));
        *srvgrps = '\0';
        modlist = malloc(strlen(response));
        *modlist = '\0';
        cp1 = response;
        while (cp1) {
            if (cp2 = strchr(cp1,'\n')) *cp2++ = '\0';
            if (sscanf(cp1,"%s %d %d %s",newsg,&first,&last,mod) == 4) {
                cp3 = s;
                while (cp3) {
                    if (cp4 = strchr(cp3,',')) *cp4 = '\0';
                    if (wild_match(newsg,cp3)) {
                        if (cp4) *cp4 = ',';
                        break;
                        }
                    if (cp4) *cp4++ = ',';
                    cp3 = cp4;
                    }
                if (cp3) {
                    util_cvrt(newsg,newsg);
                    if (!ga_exact_name(newsg)) {
                        strcat(srvgrps,newsg);
                        strcat(srvgrps,",");
                        if (tolower(*mod) == 'n') {
                            strcat(modlist,newsg);
                            strcat(modlist,",");
                            }
                        }
                    }
                }
            cp1 = cp2;
            }
        if (*srvgrps) srvgrps[strlen(srvgrps) - 1] = '\0';
        if (*modlist) modlist[strlen(modlist) - 1] = '\0';
        if (!*srvgrps) {
            free(response);
            free(srvgrps);
            free(modlist);
            err_line("Create - No newsgroups to create\n");
            return(0);
            }
        cp1 = srvgrps;
        first = 0;
        while (cp1) {
            if (cp2 = strchr(cp1,',')) *cp2++ = '\0';
            do_new_group(cp1,1,&cre_grp[first]);
            while (cre_grp[first]) first++;
            cp1 = cp2;
            }
        free(response);
        free(srvgrps);
        if (!*cre_grp) {
            free(modlist);
            err_line("Create - No newsgroups to create\n");
            return(0);
            }
        }

    time(&cur_time);
    glob_iexp_val = (ga[0]->grp_itmlife ? ga[0]->grp_itmlife : EXP_TIME);
    glob_iexp_time = cur_time - (glob_iexp_val * 84600);

    for (i = 0; g = cre_grp[i]; ++i) {
        int grp_iexp_time;

        if (!(g = ga_locate(g))) continue;
        if (hold_pres || itemhold_pres || mod_pres || filehold_pres || server_pres || keep_pres || protocol_pres) {
            if (hold_pres) ga[g]->grp_life = hold_val;
            if (itemhold_pres) ga[g]->grp_itmlife = itemhold_val;
            if (filehold_pres) ga[g]->grp_loccoplife = filehold_val;
            if (protocol_pres) ga[g]->grp_srvproto = protocol_val;
            if (keep_pres > 0) ga[g]->grp_holdcop = 1;
            else if (keep_pres < 0) ga[g]->grp_holdcop = 0;
            if (restrict_pres > 0) {
                do_set_restrict(g);
                ga[g]->grp_local |= NEWS_RESTRICT_SET;
                }
            else if (restrict_pres < 0) {
                do_set_norestrict(g);
                ga[g]->grp_local &= ~NEWS_RESTRICT_SET;
                }
            if (write_pres > 0) {
                ga[g]->grp_local &= ~NEWS_NOWRITE_SET;
                }
            else if (write_pres < 0) {
                ga[g]->grp_local |= NEWS_NOWRITE_SET;
                }
            if (server_pres) {
                if (server_pres < 0) {
                    if (*(ga[g]->grp_server)) noserver_add(ga[g]->grp_num);
                    *(ga[g]->grp_server) = '\0';
                    }
                else strncpy(ga[g]->grp_server,srv,8);
                }
            if (mod_pres) {
                if ((mod_pres < 0) && ga[g]->grp_moderator) ga[g]->grp_moderator = 0;
                else {
                    strcpy(mod_add,moderator_address(ga[g]->grp_name));
                    mod_len = 0;
                    if (cli$get_value(c$dsc("MODERATOR"),&mod_dsc,&mod_len) & 1) {
                        mod[mod_len] = '\0';
                        strcpy(mod_add,mod);
                        }
                    sprintf(mod_prompt,"Moderator for %s: ",ga[g]->grp_name);
                    get_input_dflt(&mod_dsc,c$dsc(mod_prompt),&mod_len,c$dsc(mod_add),0);
                    if ((!mod_len) && ga[g]->grp_moderator) ga[g]->grp_moderator = 0;
                    else {
                        mod[mod_len] = '\0';
                        s_to_lower(mod);
                        strcpy(mod_add,moderator_address(ga[g]->grp_name));
                        if (strcmp(mod,mod_add)) add_moderator(ga[g]->grp_name,mod);
                        ga[g]->grp_moderator = 1;
                        }
                    }
                }
            if (cli$present(c$dsc("LOCAL")) & 1) ga[g]->grp_local |= 1;
            else ga[g]->grp_local &= ~1;
            update_newsgrp(g);
            }
        if (*(ga[g]->grp_server)) {
            if (ga[g]->grp_itmlife) grp_iexp_time = cur_time - (ga[g]->grp_itmlife * 84600);
            else grp_iexp_time = glob_iexp_time;
            ++server_call;
            add_check_id(ga[g]->grp_name,0,ga[g]->grp_num,ga[g]->grp_server,grp_iexp_time,ga[g]->grp_srvproto);
            }
        hold_val = ga[g]->grp_life;
        *itemhold = '\0';
        if (ga[g]->grp_itmlife == 65535) strcpy(itemhold,"Perm");
        else if (ga[g]->grp_itmlife) sprintf(itemhold,"%u",ga[g]->grp_itmlife);
        *hold = '\0';
        if (ga[g]->grp_life == 65535) strcpy(hold,"Perm");
        else if (ga[g]->grp_life) sprintf(hold,"%u",ga[g]->grp_life);
        if ((!((*hold) && (*itemhold))) && (g)) {
            if (!*itemhold) {
                if (ga[0]->grp_itmlife == 65535) strcpy(itemhold,"[Perm]");
                else if (ga[0]->grp_itmlife) sprintf(itemhold,"[%u]",ga[0]->grp_itmlife);
                }
            if (!*hold) {
                if (ga[0]->grp_life == 65535) strcpy(hold,"[Perm]");
                else if (ga[0]->grp_life) sprintf(hold,"[%u]",ga[0]->grp_life);
                hold_val = ga[0]->grp_life;
                }
            }
        if (!*itemhold) sprintf(itemhold,"[%u]",EXP_TIME);
        if (!*hold) {
            sprintf(hold,"[%u]",GRP_TIME);
            hold_val = GRP_TIME ;
            }
        if (ga[g]->grp_count) sprintf(delstr,"#: %u",ga[g]->grp_count);
        else if (hold_val != 65535) sprintf(delstr,"Del: %s",gendate(ga[g]->grp_entdate + (hold_val * 86400)));
        else *delstr = '\0';
        sprintf(err_oline,"\t%s (Itm:%s, Grp:%s) %s",(screen_active) ? s : ga[g]->grp_name,itemhold,hold,delstr);
        if (ga[g]->grp_moderator) {
            strcat(err_oline," Mod:");
            strcat(err_oline,moderator_address(ga[g]->grp_name));
            }
        if (ga[g]->grp_local & 1) strcat(err_oline," L");
        if (*(ga[g]->grp_server)) {
            strcat(err_oline," SRV:");
            strcat(err_oline,ga[g]->grp_server);
            if (ga[g]->grp_srvproto == 1) strcat(err_oline,"[TCP]");
            }
        strcat(err_oline,"\n");
        err_line(err_oline);
        }
    if (modlist) {
        if (*modlist) {
            char *cp1, *cp2;
            int g;

            cp1 = modlist;
            while (cp1) {
                if (cp2 = strchr(cp1,",")) *cp2++ = '\0';
                if (g = ga_exact_name(cp1)) {
                    ga[g]->grp_moderator = 1;
                    update_newsgrp(g);
                    }
                cp1 = cp2;
                }
            }
        free(modlist);
        }
    if (server_call) {
        server_check(1,1);
        clear_gl();
        }
    noserver_skim();
    return(0);
}
