/*
**++
**  FACILITY:
**
**      NEWSDEFINE
**
**  ABSTRACT:
**
**      Common NEWS constant definitions.
**
**  AUTHOR:
**
**      Geoff Huston
**
**  COPYRIGHT:
**
**      Copyright  1988
**
**  MODIFICATION HISTORY:
**
**      V5.5     7-Oct-1988     GIH
**          Change name of History file, User profile file.
**
**      V5.6    11-Nov-1988     GIH
**          Add flags to grp_local field to support restricted access.
**
**--
**/

#include "newssite.h"

                        /* in line status check */
#define _c$cks(s)       (((status = (s)) & 1) ? 1 : lib$signal(status))

#define max(a,b)        (((a) > (b)) ? (a) : (b))
#define min(a,b)        (((a) > (b)) ? (b) : (a))

                        /* help call */
#define HLP$V_PROMPT    0

#define DIR_ALL         0
#define DIR_DATE        1
#define DIR_NEW         2
#define DIR_REGISTER    3

#define NEWS_LOCAL          1
#define NEWS_WRITE_ACCESS   2
#define NEWS_MOD_ACCESS     4
#define NEWS_MOD_USER       8
#define NEWS_NOWRITE_SET    16
#define NEWS_RESTRICT_SET   32
#define NEWS_ACCESS_CHECKED 64

#define ADDRESS_FILE    "NEWS_MANAGER:NEWS_ADDRESS.CNF"
#define HELP_FILE       "NEWS_ROOT:NEWS.HLB"
#define Group_file      "NEWS_ROOT:NEWSGROUPS.V50"

#define Item_file       "NEWS_ROOT:NEWSITEMS.V50"

#define HIST_FILE       "NEWS_ROOT:HISTORY.V60"
#define HIST_VAL        45

#define User_file       "SYS$LOGIN:NEWSRC"
#define Itm_files       "NEWS_DEVICE:[000000...]*.ITM;*"
#define Itm_template    "NEWS_DEVICE:[%s]%d.ITM"
#define Itmg_template   "NEWS_DEVICE:[%s]*.ITM;*"
#define Grp_template    "NEWS_DEVICE:[%s]"
#define Dir_template    "NEWS_DEVICE:[000000.%s^DIR"
#define Access_template "NEWS_DEVICE:[%s]ACCESS.NEWS"
#define News_ini        "NEWS_INI"

#define DISP_BUF_SIZE   500
#define SUBJLEN         50
#define IDLEN           60

/* ITEM FILE LAYOUT
    There is 1 item file for the whole system. The file contains the item
    number, date of entry into the news file, size of the item (bytes) and item
    title.

    Each item file name is of the form: NEWS_DEVICE:[groupname.list]<numb>.ITM
*/

typedef struct {
    unsigned short  itm_num;
    unsigned short  itm_grp;        /* field 1,2 = key 0*/ /* 4*/
    char itm_id[IDLEN];             /* field 3,2 = key 1 */
    unsigned int itm_date;
    unsigned int itm_size;
    unsigned short itm_new;
    char itm_title[SUBJLEN];
    unsigned short itm_life;
    char itm_unread;
    unsigned int itm_locdate;           /* if non zero then date local file copy was created - if 0 then file is on remote sys */
    } ITM, *ITM_MEM_PTR;

/* NEWSGROUP FILE LAYOUT
    There is 1 indexed file for newsgroups. The file contains the group name,
    the group number, the top used slot in the file, the count of current items
    in the group, the date of the creation of the group and the date of
    the last item created in the group.
*/

typedef struct {
    char grp_name[SUBJLEN];         /* field 1 = key 0 */
    unsigned short grp_num;         /* field 2 = key 1 */
    unsigned short grp_topnum;
    unsigned short grp_count;
    unsigned int grp_credate;
    unsigned int grp_entdate;
    unsigned short grp_life;
    unsigned short grp_itmlife;
    char grp_srvproto;

    unsigned char grp_reg;
    unsigned short grp_unread;

    ITM_MEM_PTR grp_ia;
    unsigned short grp_iasize;

    int grp_iavd;
    int grp_iavdsize;
    int grp_iapaste;
    unsigned short grp_c_itm;
    int grp_display_indx;

    char grp_moderator;
    char grp_local;

    char grp_server[8];             /* if non-null then decnet name of server for this newsgroup */
    char grp_holdcop;               /* if user requests file from server, is it retained on the local system ? */
    unsigned short grp_loccoplife;  /* life of local file copies */
    } GRP, *GRP_MEM_PTR;

struct itms {
        char itmid[IDLEN];
        int itmdate,
            itmsize;
        char itmtitle[SUBJLEN];
        struct itms *itmsnext;
        };

struct grps {
        char grpname[SUBJLEN];
        char grpnode[8];
        int  nproto;
        unsigned short itmgrp;
        int grptime;
        struct itms *ids,
                    *idr;
        struct grps *grpsnext;
        };

typedef struct its {
    int ngrp;
    int fitm, litm;
    } NOTE_RANGE;
