#module NEWSFORWARD "V5.6"

/*
**++
**  FACILITY:
**
**      NEWSFORWARD
**
**  ABSTRACT:
**
**      This module interfaces to VMS MAIL. The functionality is to either
**      post a response directly back to the sender of an item (REPLY) or
**      to forward a news item to another user via mail.
**
**      The module supports mail address of either internet or mail-11 format.
**
**  AUTHOR:
**
**      Geoff Huston
**
**  COPYRIGHT:
**
**      Copyright  1988
**
**  MODIFICATION HISTORY:
**
**      V5.5     6-Oct-1988     GIH
**          Include full subject line as the subject title of the mail item.
**      V5.6    11-Nov-1988     GIH
**          Alter ^Z behaviour to only abort current operation, not NEWS itself.
**
**--
**/

#include "newsinclude.h"
#include "newsdefine.h"
#include "newsextern.h"

/*
 *  do_mail
 *
 *  Either send a reply to the poster, or forward the news message.
 *  All via VMS mail.
 */

do_mail(forward,incl_header)
    int forward,
        incl_header;
{
    int header,
        reply_to = 0;
    char xfrbuf[512],
         address[512],
         id[256],
         from[256],
         idate[256],
         subj[256],
         ngroup[132],
         subjline[132],
         fpad[3];
    char *cp,
         *cp1,
         *sa;
    FILE *fpr,
         *fpw;
    short ngroup_len;
    $DESCRIPTOR(ngroup_dsc,ngroup);
    struct stat sbuffer;

    if ((!curr_g) || (curr_i <= 0)) {
        err_line("Error: Mailer - No item located to mail");
        return(0);
        }

    if (!(fpr = do_open_item(curr_g,curr_i,"r",fp_open))) {
        err_line("Error: Mailer - cannot read item");
        return(0);
        }

    if (!(fpw = fopen(Mail_file,"w","rat=cr","rfm=var"))) {
        fclose(fpr);
        if (*fp_open > 1) while (!delete(fp_open));
        *fp_open = '\0';
        err_line("Error: Mailer - cannot open tmp output file");
        return(0);
        }

    fprintf(fpw,"X-VMS-News: %s %s:%d\n",usr_nodename,ga[curr_g]->grp_name,ga[curr_g]->grp_ia[curr_i].itm_num);
    if (!forward) fprintf(fpw,"\n");

    *id = '\0';
    *from = '\0';
    *subj = '\0';
    *idate = '\0';
    if (forward) *fpad = '\0';
    else strcpy(fpad,"> ");

    header = 1;
    while (fgets(xfrbuf,510,fpr)) {
        if ((*xfrbuf == '\n') && (header)) {
            if (incl_header) fprintf(fpw,"%s%s",fpad,xfrbuf);
            else {
                fprintf(fpw,"%sFrom: %s\n%sSubject:%s\n%s%s",fpad,from,fpad,subj,fpad,idate);
                fprintf(fpw,"%s%s",fpad,"Message-ID:");
                if (*id) fprintf(fpw,"%s\n\n",id);
                else fprintf(fpw,"<%s %s:%d>\n\n", usr_nodename,ga[curr_g]->grp_name,ga[curr_g]->grp_ia[curr_i].itm_num);
                }
            header = 0;
            continue;
            }
        else if (header) {
            if (!strncmp(xfrbuf,"From:",5)) {
                strcpy(from,&xfrbuf[6]);
                if (cp = strchr(from,'\n')) *cp = '\0';
                if ((!forward) && (!reply_to)) {
                    cp = &xfrbuf[5];
                    if (sa = strchr(cp,'<')) {
                        strcpy(address,++sa);
                        if (sa = strchr(address,'>')) *sa = '\0';
                        if (sa = strchr(address,'\n')) *sa = '\0';
                        }
                    else {
                        while (isspace(*cp)) cp++;
                        strcpy(address,cp);
                        cp1 = address;
                        while (!isspace(*cp)) *cp1++ = *cp++;
                        *cp1 = '\0';
                        if (sa = strchr(address,'(')) *sa = '\0';
                        }
                    }
                }
            else if ((!forward) && (!strncmp(xfrbuf,"Reply-To:",9))) {
                reply_to = 1;
                cp = &xfrbuf[9];
                if (sa = strchr(cp,'<')) {
                    strcpy(address,++sa);
                    if (sa = strchr(address,'>')) *sa = '\0';
                    if (sa = strchr(address,'\n')) *sa = '\0';
                    }
                else {
                    while (isspace(*cp)) cp++;
                    strcpy(address,cp);
                    cp1 = address;
                    while (!isspace(*cp)) *cp1++ = *cp++;
                    *cp1 = '\0';
                    if (sa = strchr(address,'(')) *sa = '\0';
                    }
                }
            else if (!strncmp(xfrbuf,"Message-ID:",11)) {
                strcpy(id,&xfrbuf[12]);
                if (cp = strchr(id,'\n')) *cp = '\0';
                }
            else if (!strncmp(xfrbuf,"Subject:",8)) {
                strcpy(subj,&xfrbuf[9]);
                if (cp = strchr(subj,'\n')) *cp = '\0';
                }
            else if (!strncmp(xfrbuf,"Date:",5)) {
                strcpy(idate,xfrbuf);
                }
            }
        if ((!header) || ((incl_header) && (header))) {
            if ((*xfrbuf == '>') && *fpad) fprintf(fpw,">%s",xfrbuf);
            else fprintf(fpw,"%s%s",fpad,xfrbuf);
            }
        }
    fclose(fpr);
    if (*fp_open > 1) while (!delete(fp_open));
    *fp_open = '\0';
    if ((fpr = fopen("MAIL_SIGNATURE","r")) || (fpr = fopen("SYS$LOGIN:MAIL.SIGNATURE","r"))) {
        fputs("-- \n",fpw);
        if (forward) fputs("Forwarded-By:\n",fpw);
        while (fgets(xfrbuf,512,fpr)) fputs(xfrbuf,fpw);
        fclose(fpr);
        }
    fclose(fpw);

    strcpy(xfrbuf,"MAIL/NOEDIT ");
    strcat(xfrbuf,Mail_file);
    if (cli$get_value(c$dsc("SUBJECT"),&ngroup_dsc,&ngroup_len) == CLI$_ABSENT) {
        if (!*subj) strcpy(subjline,ga[curr_g]->grp_ia[curr_i].itm_title);
        else strcpy(subjline,subj);
        get_input_dflt(&ngroup_dsc,c$dsc("MAIL/SUBJECT="),&ngroup_len,c$dsc(subjline),0);
        }
    if (ngroup_len) {
        char nsubj[256];

        ngroup[ngroup_len] = '\0';
        strcpy(nsubj,ngroup);
        cp = nsubj;
        cp1 = ngroup;
        while (*cp) {
            if ((*cp1++ = *cp++) == '"') *cp1++ = '"';
            }
        *cp1 = '\0';
        sprintf(&xfrbuf[strlen(xfrbuf)],"/SUBJECT=\"%s\"",ngroup);
        }
    if (cli$present(c$dsc("SELF")) == CLI$_PRESENT) sprintf(&xfrbuf[strlen(xfrbuf)],"/SELF");
    else sprintf(&xfrbuf[strlen(xfrbuf)],"/NOSELF");
    sprintf(&xfrbuf[strlen(xfrbuf)]," ");
    if (cli$get_value(c$dsc("TO"),&ngroup_dsc,&ngroup_len) & 1) {
        do {
            ngroup[ngroup_len] = '\0';
            sprintf(&xfrbuf[strlen(xfrbuf)],"%s,",add_transform(ngroup));
            } while (cli$get_value(c$dsc("TO"),&ngroup_dsc,&ngroup_len) & 1);
        }
    else {
        char *comma_pointer,
             *address_field;

        if (!forward) get_input_dflt(&ngroup_dsc,c$dsc("To: "),&ngroup_len,c$dsc(address),0);
        else get_input(&ngroup_dsc,c$dsc("To: "),&ngroup_len);
        ngroup[ngroup_len] = '\0';
        address_field = ngroup;
        do {
            if (comma_pointer = strchr(address_field,',')) *comma_pointer++ = '\0';
            sprintf(&xfrbuf[strlen(xfrbuf)],"%s,",add_transform(address_field));
            address_field = comma_pointer;
            } while (address_field);
        }

    xfrbuf[strlen(xfrbuf) - 1] = '\0';

    if ((!forward) || (cli$present(c$dsc("EDIT")) & 1)) {
        if ((status = call_edit(Mail_file)) == 2) return(0);
        if (!status) status = get_input(&command,c$dsc("Mail item? [y]:"),&response_length);
        else response_length = 0;
        if (status == RMS$_EOF) longjmp(env,2);
        if (!((status & 1) && ((!response_length) || ((response_length) && (toupper(*response) == 'Y'))))) {
            while (!(delete(Mail_file)));
            return(0);
            }
        }

    if (stat(Mail_file,&sbuffer)) {
        err_line("Error: Mail - extracted file not found");
        return(0);
        }
    if (!sbuffer.st_size) {
        err_line("Error: Mail - extracted file is empty");
        while (!(delete(Mail_file)));
        return(0);
        }

    err_line("Mail - Spawning MAIL task .. please wait");
    if (screen_active) {
        display_brdcst(2);
        no_broad_trap();
        smg$end_pasteboard_update(&pid);
        }
    _c$cks(lib$spawn(c$dsc(xfrbuf),0,0,0,0,0,0,0,0,0,0,0));

    if (screen_active) {
        smg$begin_pasteboard_update(&pid);
        broad_trap();
        }
    while (!(delete(Mail_file)));
    return(0);
}

/*
 *  do_forward
 *
 *  Forward a mail item via VMS MAIL
 */

do_forward()
{
    do_mail(1,(cli$present(c$dsc("HEADERS")) & 1));
    return(0);
}

/*
 *  do_reply
 *
 *  Post a mail reply to the news originator
 */

do_reply()
{
    do_mail(0,(cli$present(c$dsc("HEADERS")) == CLI$_PRESENT));
    return(0);
}

do_send()
{
    int author,
        extract_sw,
        incl_header,
        reply_to = 0,
        header;
    short ngroup_len,
          infile_len;
    char ngroup[132],
         infile[256],
         id[256],
         from[256],
         idate[256],
         subj[256],
         subjline[132],
         xfrbuf[512],
         address[512],
         fpad[6],
         *cp,
         *cp1,
         *sa;
    FILE *fpr,
         *fpw = 0;
    struct stat sbuffer;
    $DESCRIPTOR(ngroup_dsc,ngroup);
    $DESCRIPTOR(infile_dsc,infile);

    *address = '\0';
    if (!(fpw = fopen(Mail_file,"w","rat=cr","rfm=var"))) {
        err_line("\tError: Send - cannot open tmp output file");
        return(0);
        }

    author = (cli$present(c$dsc("AUTHOR")) & 1);
    if (extract_sw = (cli$present(c$dsc("EXTRACT")) & 1)) {
        incl_header = (cli$present(c$dsc("HEADERS")) & 1);
        if (cli$present(c$dsc("QUOTE")) == CLI$_NEGATED) *fpad = '\0';
        else {
            strcpy(fpad,"> ");
            if (cli$get_value(c$dsc("QUOTE"),&ngroup_dsc,&ngroup_len) & 1) {
                if (ngroup_len > 5) ngroup_len = 5;
                ngroup[ngroup_len] = '\0';
                strcpy(fpad,ngroup);
                }
            }
        }
    if (author || extract_sw) {
        if ((!curr_g) || (curr_i <= 0)) {
            err_line("\tError: Send - No current item\n");
            return(0);
            }

        if (!(fpr = do_open_item(curr_g,curr_i,"r",fp_open))) {
            err_line("\tError: Send - cannot read current news item\n");
            return(0);
            }

        if (extract_sw)
            fprintf(fpw,"X-VMS-News: %s %s:%d\n",usr_nodename,
                ga[curr_g]->grp_name,ga[curr_g]->grp_ia[curr_i].itm_num);
        *id = '\0';
        *from = '\0';
        *subj = '\0';
        *idate = '\0';
        header = 1;

        while (fgets(xfrbuf,510,fpr)) {
            if ((*xfrbuf == '\n') && (header)) {
                if (extract_sw) {
                    if (incl_header) fprintf(fpw,"%s%s",fpad,xfrbuf);
                    else {
                        fprintf(fpw,"%sFrom: %s\n%sSubject:%s\n%s%s",fpad,from,fpad,subj,fpad,idate);
                        fprintf(fpw,"%s%s",fpad,"Message-ID:");
                        if (*id) fprintf(fpw,"%s\n\n",id);
                        else fprintf(fpw,"<%s %s:%d>\n\n", usr_nodename,ga[curr_g]->grp_name,ga[curr_g]->grp_ia[curr_i].itm_num);
                        }
                    }
                header = 0;
                continue;
                }
            else if (header) {
                if (!strncmp(xfrbuf,"From:",5)) {
                    strcpy(from,&xfrbuf[6]);
                    if (cp = strchr(from,'\n')) *cp = '\0';
                    if (!reply_to) {
                        cp = &xfrbuf[5];
                        if (sa = strchr(cp,'<')) {
                            strcpy(address,++sa);
                            if (sa = strchr(address,'>')) *sa = '\0';
                            if (sa = strchr(address,'\n')) *sa = '\0';
                            }
                        else {
                            while (isspace(*cp)) cp++;
                            strcpy(address,cp);
                            cp1 = address;
                            while (!isspace(*cp)) *cp1++ = *cp++;
                            *cp1 = '\0';
                            if (sa = strchr(address,'(')) *sa = '\0';
                            }
                        }
                    }
                else if (!strncmp(xfrbuf,"Reply-To:",9)) {
                    reply_to = 1;
                    cp = &xfrbuf[9];
                    if (sa = strchr(cp,'<')) {
                        strcpy(address,++sa);
                        if (sa = strchr(address,'>')) *sa = '\0';
                        if (sa = strchr(address,'\n')) *sa = '\0';
                        }
                    else {
                        while (isspace(*cp)) cp++;
                        strcpy(address,cp);
                        cp1 = address;
                        while (!isspace(*cp)) *cp1++ = *cp++;
                        *cp1 = '\0';
                        if (sa = strchr(address,'(')) *sa = '\0';
                        }
                    }
                else if (!strncmp(xfrbuf,"Message-ID:",11)) {
                    strcpy(id,&xfrbuf[12]);
                    if (cp = strchr(id,'\n')) *cp = '\0';
                    }
                else if (!strncmp(xfrbuf,"Subject:",8)) {
                    strcpy(subj,&xfrbuf[9]);
                    if (cp = strchr(subj,'\n')) *cp = '\0';
                    }
                else if (!strncmp(xfrbuf,"Date:",5)) {
                    strcpy(idate,xfrbuf);
                    }
                }
            if ((!header) || ((incl_header) && (header))) {
                if (extract_sw) {
                    fprintf(fpw,"%s%s",fpad,xfrbuf);
                    }
                }
            }
        fclose(fpr);
        if (*fp_open > 1) while (!delete(fp_open));
        *fp_open = '\0';
        }

    if (cli$get_value(c$dsc("INFILE"),&infile_dsc,&infile_len) == CLI$_ABSENT) *infile = '\0';
    else infile[infile_len] = '\0';
    if (*infile) {
        if (fpr = fopen(infile,"r")) {
            while (fgets(xfrbuf,512,fpr)) fputs(xfrbuf,fpw);
            fclose(fpr);
            }
        else {
            sprintf(err_oline,"\tError:Send - Cannot open send file %s\n",infile);
            err_line(err_oline);
            fclose(fpw);
            while (!delete(Mail_file));
            return(0);
            }
        }
    else if ((!(cli$present(c$dsc("EDIT")) & 1)) && !extract_sw) {
        err_line("\tSend - No file to send\n");
        fclose(fpw);
        while (!delete(Mail_file));
        return(0);
        }

    if ((fpr = fopen("SIGNATURE","r")) || (fpr = fopen("MAIL_SIGNATURE","r")) || (fpr = fopen("SYS$LOGIN:MAIL.SIGNATURE","r"))) {
        fputs("-- \n",fpw);
        while (fgets(xfrbuf,512,fpr)) fputs(xfrbuf,fpw);
        fclose(fpr);
        }
    fclose(fpw);

    if (author && !*address) {
        err_line("\tSend/Author - No author field located in item\n");
        while (!delete(Mail_file));
        return(0);
        }

    strcpy(xfrbuf,"MAIL/NOEDIT ");
    strcat(xfrbuf,Mail_file);
    if (cli$get_value(c$dsc("SUBJECT"),&ngroup_dsc,&ngroup_len) == CLI$_ABSENT) {
        if (!*subj) strcpy(subjline,ga[curr_g]->grp_ia[curr_i].itm_title);
        else strcpy(subjline,subj);
        status = get_input_dflt(&ngroup_dsc,c$dsc("MAIL/SUBJECT="),&ngroup_len,c$dsc(subjline),0);
        if (status == RMS$_EOF) {
            err_line("\tSend - Canceled\n");
            while (!delete(Mail_file));
            return(0);
            }
        }

    if (ngroup_len) {
        char nsubj[256];

        ngroup[ngroup_len] = '\0';
        strcpy(nsubj,ngroup);
        cp = nsubj;
        cp1 = ngroup;
        while (*cp) {
            if ((*cp1++ = *cp++) == '"') *cp1++ = '"';
            }
        *cp1 = '\0';
        sprintf(&xfrbuf[strlen(xfrbuf)],"/SUBJECT=\"%s\"",ngroup);
        }

    if (cli$present(c$dsc("SELF")) == CLI$_PRESENT)
        sprintf(&xfrbuf[strlen(xfrbuf)],"/SELF");
    else sprintf(&xfrbuf[strlen(xfrbuf)],"/NOSELF");
    sprintf(&xfrbuf[strlen(xfrbuf)]," ");
    if (cli$get_value(c$dsc("TO"),&ngroup_dsc,&ngroup_len) & 1) {
        if (author) {
            sprintf(&xfrbuf[strlen(xfrbuf)],"%s,",add_transform(address));
            }
        do {
            ngroup[ngroup_len] = '\0';
            sprintf(&xfrbuf[strlen(xfrbuf)],"%s,",add_transform(ngroup));
            } while (cli$get_value(c$dsc("TO"),&ngroup_dsc,&ngroup_len) & 1);
        }
    else {
        char *comma_pointer,
             *address_field;

        if (author) status = get_input_dflt(&ngroup_dsc,c$dsc("To: "),&ngroup_len,c$dsc(address),0);
        else status = get_input(&ngroup_dsc,c$dsc("To: "),&ngroup_len);
        if (status == RMS$_EOF) {
            err_line("\tSend - Canceled\n");
            while (!delete(Mail_file));
            return(0);
            }
        ngroup[ngroup_len] = '\0';
        address_field = ngroup;
        do {
            if (comma_pointer = strchr(address_field,',')) *comma_pointer++ = '\0';
            sprintf(&xfrbuf[strlen(xfrbuf)],"%s,",add_transform(address_field));
            address_field = comma_pointer;
            } while (address_field);
        }

    xfrbuf[strlen(xfrbuf) - 1] = '\0';

    if (cli$present(c$dsc("EDIT")) & 1) {
        if ((status = call_edit(Mail_file)) == 2) {
            err_line("\tSend - Canceled\n");
            while (!delete(Mail_file));
            return(0);
            }
        if (!status) status = get_input(&command,c$dsc("Mail item? [y]:"),&response_length);
        else response_length = 0;
        if (status == RMS$_EOF) {
            err_line("\tSend - Canceled\n");
            while (!delete(Mail_file));
            return(0);
            }
        if (!((status & 1) && ((!response_length) || ((response_length) && (toupper(*response) == 'Y'))))) {
            err_line("\tSend - Canceled\n");
            while (!(delete(Mail_file)));
            return(0);
            }
        }

    if (stat(Mail_file,&sbuffer)) {
        err_line("Error: Mail - extracted file not found");
        return(0);
        }
    if (!sbuffer.st_size) {
        err_line("Error: Mail - extracted file is empty");
        while (!(delete(Mail_file)));
        return(0);
        }

    err_line("Mail - Spawning MAIL task .. please wait");
    if (screen_active) {
        display_brdcst(2);
        no_broad_trap();
        smg$end_pasteboard_update(&pid);
        }
    _c$cks(lib$spawn(c$dsc(xfrbuf),0,0,0,0,0,0,0,0,0,0,0));

    if (screen_active) {
        smg$begin_pasteboard_update(&pid);
        broad_trap();
        }
    while (!(delete(Mail_file)));
    return(0);
}
