#module NEWSSELECT "V5.6"

/*
**++
**  FACILITY:
**
**      NEWSSELECT
**
**  ABSTRACT:
**
**      This module selects a newsgroup as the "current" newsgroup. The side
**      effect of selection is that the newsgroup is added to the current
**      newsgroup disectory display screen if necessary.
**
**  AUTHOR:
**
**      Geoff Huston
**
**  COPYRIGHT:
**
**      Copyright  1988
**
**  MODIFICATION HISTORY:
**
**      V5.5     7-Oct-1988     GIH
**          Remove "adding" informational message
**      V5.6    11-Nov-1988     GIH
**          Correctly position current item arrow on screen following select
**
**--
**/

#include "newsinclude.h"
#include "newsdefine.h"
#include "newsextern.h"

/*
 *  selnew
 *
 *  Pick out the next newsgroup with unread news with the max priority
 */

selnew(lev)
    int lev;
{
    int g,                             
        mg = 0,
        mp = 0;

    if (no_more_news) {
        err_line("\tSelect - No new items in registered groups\n");
        set_level(lev);
        return(0);
        }

    if ((curr_g) && (ga[curr_g]->grp_reg) && (ga[curr_g]->grp_unread)) {
        if (news_context != 1) return(do_select("%",curr_g,lev),1);
        else {
            mg = curr_g;
            mp = ga[curr_g]->grp_reg;
            }
        }

    g = 1;
    for (g = 1; g <= ga_size; ++g) {
        if ((ga[g]->grp_reg > mp) && (ga[g]->grp_unread)) {
            mp = ga[g]->grp_reg;
            mg = g;
            }
        }

    if (mg) {
        int i;
        do_select("%",mg,lev);
        if (lev < 2) return(1);
        if (curr_g && curr_i && ga[curr_g]->grp_ia[curr_i].itm_unread) return(1);
        for (i = 1; i < ga[curr_g]->grp_count; ++i)
            if (ga[curr_g]->grp_ia[i].itm_unread) break;
        cur_set_itm(curr_g,i);
        return(1);
        }
    else no_more_news = 1;
    if (!ga_size) err_line("\tSelect - NEWS has no Newsgroups\n");
    else err_line("\tSelect - No new items in registered groups\n");
    return(0);
}

selmark(lev)
    int lev;
{
    int i;
    unsigned int gm;
    unsigned short g,
                   m;                  
    char tg[80],
         *tag = 0;
    short tag_len;
    $DESCRIPTOR(tag_dsc,tg);

    if (cli$get_value(c$dsc("MARK"),&tag_dsc,&tag_len) & 1) {
        tg[tag_len] = '\0';
        tag = tg;
        }
    if (!curr_g) g = m = 0;
    else g = ga[curr_g]->grp_num;
    if ((g) && ((curr_i <= 0) || (news_context < 2))) m = 0;
    else if (g) m = ga[curr_g]->grp_ia[curr_i].itm_num;

    for (;;) {
        if (!mark_find(g,m,tag,&gm)) return(err_line("\tInfo: Read/Mark - No more items with this tag\n"),0);

        g = gm >> 16;
        m = gm & 0xFFFF;
        if (!(gm = ga_locate(g))) continue;
        if (!ga[gm]->grp_count) continue;
        if (!ga[gm]->grp_ia) map_items(gm);
        for (i = 1; i <= ga[gm]->grp_count; ++i)
            if (ga[gm]->grp_ia[i].itm_num == m) break;
        if (i > ga[gm]->grp_count) continue;
        break;
        }
    do_select("%",gm,lev);
    if (lev > 1) cur_set_itm(curr_g,i);
    return(0);
}

/*
 *  do_select
 *
 *  Pick out a news group by calling select(). Set the read context to
 *  -1 to indicate that no items have been read so far from this group.
 */

do_select(s,sg,lev)
    char *s;
    int sg,
        lev;
{
    char ngroup[SUBJLEN];
    int g = 0,
        save_level = news_context;
    $DESCRIPTOR(ngroup_dsc,ngroup);
    short ngroup_len = 0;

    if (!s) {
        if (cli$present(c$dsc("NEW")) == CLI$_PRESENT) return(set_level(1),selnew(lev),0);
        if (cli$present(c$dsc("MARK")) == CLI$_PRESENT) return(selmark(lev),0);
        set_level(1);
        if (cli$get_value(c$dsc("NEWSGROUP"),&ngroup_dsc,&ngroup_len) == CLI$_ABSENT) {
            if ((screen_active) && (curr_g)) g = curr_g;
            else if (curr_g) get_input_dflt(&ngroup_dsc,c$dsc("Newsgroup: "),&ngroup_len,c$dsc(ga[curr_g]->grp_name),0);
            else get_input(&ngroup_dsc,c$dsc("Newsgroup: "),&ngroup_len);
            }
        }
    else if (*s != '%') {
        set_level(1);
        strcpy(ngroup,s);
        ngroup_len = strlen(ngroup);
        }
    else {
        set_level(1);
        g = sg;
        }

    if (ngroup_len) {
        ngroup[ngroup_len] = '\0';
        util_cvrt(ngroup,ngroup);
        if (!(g = ga_search_name(ngroup))) {
            sprintf(err_oline,"\tError: Select - Newsgroup %s does not exist\n",ngroup);
            err_line(err_oline);
            set_level(save_level);
            return(0);
            }
        }
    else if (!g) g = curr_g;

    if ((screen_active) && (g) && (!ga[g]->grp_display_indx)) do_dir(DIR_ALL + 1,0);
    cur_set_grp(g);
    if ((curr_g) && (!screen_active)) printf("\tSelect - Newsgroup %s (%d items)\n",ga[curr_g]->grp_name,ga[curr_g]->grp_count);
    set_level(lev);
    return(0);
}

/*
 *  do_selgrp
 *
 *  select a newsgroup - CLI entry point
 */

do_selgrp()
{
    return(do_select(0,0,2));
}
