#module NEWSSKIP "V5.6"

/*
**++
**  FACILITY:
**
**      NEWSSKIP
**
**  ABSTRACT:
**
**      Mark items as seen.
**
**  AUTHOR:
**
**      Geoff Huston
**
**  COPYRIGHT:
**
**      Copyright  1988
**
**  MODIFICATION HISTORY:
**
**      V5.5    7-Oct-1988      GIH
**      V5.6    11-Nov-1988     GIH
**          No changes for V5.6 release
**--
**/

#include "newsinclude.h"
#include "newsdefine.h"
#include "newsextern.h"

/*
 *  screen_update_gread
 *
 *  Update the read field of the directory screen display
 */

screen_update_gread(g)
    int g;
{
    int indx;

    if ((screen_active) && (indx = ga[g]->grp_display_indx)) {
        if ((ga[g]->grp_reg) && (ga[g]->grp_unread)) smg$change_rendition(&grp_vd,&indx,c$rfi(4),c$rfi(1),c$rfi(5),c$rfi(SMG$M_BOLD),0);
        else  smg$change_rendition(&grp_vd,&indx,c$rfi(4),c$rfi(1),c$rfi(5),c$rfi(0),0);
        if (ga[g]->grp_unread) {
            sprintf(err_oline,"%5d",ga[g]->grp_unread);
            smg$put_chars(&grp_vd,c$dsc(err_oline),&indx,c$rfi(73),0,0,0,0);
            }
        else smg$put_chars(&grp_vd,c$dsc("     "),&indx,c$rfi(73),0,0,0,0);
        }
}

/*
 *  screen_update_iread
 *
 *  Update an item display on the screen to indicate that the item
 *  has been read
 */

screen_update_iread(g,i)
    int g,
        i;
{
    int indx;

    if (screen_active && ga[g]->grp_iavdsize) {
        if (ga[g]->grp_ia[i].itm_unread) smg$change_rendition(&(ga[g]->grp_iavd),&i,c$rfi(4),c$rfi(1),c$rfi(5),c$rfi(SMG$M_BOLD),0);
        else smg$change_rendition(&(ga[g]->grp_iavd),&i,c$rfi(4),c$rfi(1),c$rfi(5),c$rfi(0),0);
        }
}

skipfollowup()
{
    char title[SUBJLEN+1],
         *cp;
    int i;
    ITM_MEM_PTR iap;

    if ((!curr_g) || (news_context < 2) || (curr_i < 1)) return(err_line("\tError: Skip/Followup - No current item selected\n"),0);
    iap = ga[curr_g]->grp_ia;
    strcpy(title,iap[curr_i].itm_title);
    s_to_lower(title);
    if (!strncmp(title,"re:",3)) {
        strcpy(title,iap[curr_i].itm_title);
        cp = &title[3];
        while ((*cp) && (isspace(*cp))) cp++;
        if (!*cp) {
            err_line("\tError: Skip/Followup - No subject!\n");
            return(0);
            }
        }
    else cp = strcpy(title,iap[curr_i].itm_title);
    if (strlen(cp) > (SUBJLEN - 5)) cp[SUBJLEN - 5] = '\0';
    strip(cp,strlen(cp));
    for (i = 1; i <= ga[curr_g]->grp_count; ++i)
        if ((iap[i].itm_unread) && (substrcmp(iap[i].itm_title,cp))) item_update(curr_g,i);
    return(0);
}

/*
 *  do_skip
 *
 *  scan over all remaining new news in newsgroup
 */

do_skip()
{
    char ngroup[SUBJLEN];
    $DESCRIPTOR(ngroup_dsc,ngroup);
    short ngroup_len;
    int g,
        i;
    char before[100];
    short before_len;
    int bef_time;
    $DESCRIPTOR(before_dsc,before);

    if (cli$present(c$dsc("FOLLOWUP")) & 1) return(skipfollowup(),0);
    time(&bef_time);
    before_len = 0;
    if (cli$get_value(c$dsc("BEFORE"),&before_dsc,&before_len) & 1) {
        before[before_len] = '\0';
        bef_time = cvt_date_val(before);
        before_len = 1;
        }

    if (cli$present(c$dsc("ALL")) & 1) {
        for (g = 1; g <= ga_size; ++g) {
            if (ga[g]->grp_unread) {
                if (!before_len) ga[g]->grp_unread = 0;
                else if (!ga[g]->grp_ia) map_items(g);
                if (ga[g]->grp_ia) {
                    for (i = 1; i <= ga[g]->grp_count; ++i) {
                        if ((ga[g]->grp_ia[i].itm_unread) && (ga[g]->grp_ia[i].itm_date < bef_time)) {
                            ga[g]->grp_ia[i].itm_unread = 0;
                            if (ga[g]->grp_unread > 0) --ga[g]->grp_unread;
                            if (screen_active) screen_update_iread(g,i);
                            }
                        }
                    }
                else if (ga[g]->grp_iapaste > 511) {
                    char newreg[10];

                    sprintf(newreg," <%d\n",ga[g]->grp_topnum);
                    free(ga[g]->grp_iapaste);
                    strcpy((ga[g]->grp_iapaste = malloc(strlen(newreg) + 1)),newreg);
                    }
                if (screen_active) screen_update_gread(g);
                }
            }
        return(0);
        }

    g = curr_g;

    if (cli$present(c$dsc("POINTER")) & 1) {
        if (!g) return(err_line("\tError: Skip - No Newsgroup selected\n"),0);
        if (news_context == 1) return(err_line("\tError: Skip - No Newsgroup selected\n"),0);
        if (ga[g]->grp_unread) {
            if (ga[g]->grp_ia) {
                for (i = 1; i <= curr_i; ++i) {
                    if (ga[g]->grp_ia[i].itm_unread) {
                        ga[g]->grp_ia[i].itm_unread = 0;
                        if (ga[g]->grp_unread > 0) --ga[g]->grp_unread;
                        if (screen_active) screen_update_iread(g,i);
                        }
                    }
                if (screen_active) screen_update_gread(g);
                }
            }
        return(0);
        }

    if (cli$get_value(c$dsc("NEWG"),&ngroup_dsc,&ngroup_len) & 1) {
        ngroup[ngroup_len] = '\0';
        util_cvrt(ngroup,ngroup);

        if (!(g = ga_search_name(ngroup))) {
            sprintf(err_oline,"\tError: Skip - no such Newsgroup: %s\n",ngroup);
            err_line(err_oline);
            return(0);
            }
        }
    else if ((!(cli$present(c$dsc("NEWSGROUP")) & 1)) && (!before_len) && (news_context > 1)) {
        if (curr_g && (curr_i > 0)) {
            if (ga[curr_g]->grp_ia[curr_i].itm_unread) {
                ga[curr_g]->grp_ia[curr_i].itm_unread = 0;
                if (ga[curr_g]->grp_unread > 0) --ga[curr_g]->grp_unread;
                if (screen_active) screen_update_iread(curr_g,curr_i);
                }
            cur_down_itm(curr_g,1,1);
            }
        return(0);
        }

    if (!g) return(err_line("\tError: Skip - No Newsgroup selected\n"),0);

    if (ga[g]->grp_unread) {
        if (!before_len) ga[g]->grp_unread = 0;
        else if (!ga[g]->grp_ia) map_items(g);
        if (ga[g]->grp_ia) {
            for (i = 1; i <= ga[g]->grp_count; ++i) {
                if ((ga[g]->grp_ia[i].itm_unread) && (ga[g]->grp_ia[i].itm_date < bef_time)) {
                    ga[g]->grp_ia[i].itm_unread = 0;
                    if (ga[g]->grp_unread > 0) --ga[g]->grp_unread;
                    if (screen_active) screen_update_iread(g,i);
                    }
                }
            }
        else if (ga[g]->grp_iapaste > 511) {
            char newreg[10];

            sprintf(newreg," <%d\n",ga[g]->grp_topnum);
            free(ga[g]->grp_iapaste);
            strcpy((ga[g]->grp_iapaste = malloc(strlen(newreg) + 1)),newreg);
            }
        if (screen_active) screen_update_gread(g);
        }
    return(0);
}
