/*
**++
**  FACILITY:
**
**      NEWSVARIABLES
**
**  ABSTRACT:
**
**      Common NEWS variable declarations and defintions
**      Single definition of all global news variables, used to define
**      variables in NEWS.C and to reference the variables in NEWSEXTERN.H.
**
**  AUTHOR:
**
**      Geoff Huston
**
**  COPYRIGHT:
**
**      Copyright  1988
**
**  MODIFICATION HISTORY:
**
**      V5.5     7-Oct-1988     GIH
**          Remove hdid (help virtual display id - no longer used)
**      V5.6    11-Nov-1988     GIH
**          Add note-range variable array
**
**--
**/

extrnl
unsigned int status;            /* status return value */

extrnl
int   kid,                      /* SMG keyboard id */
      pid,                      /* SMG Pasteboard id */
      devrow,                   /* SMG device rows */
      devcol,                   /* SMG device columns */
      keytab,                   /* SMG key definition table */
      no_more_news iev(0),      /* global flag indicating all registered groups read */
      usr_line,                 /* output line on screen for paged output */
      ga_size iev(0),           /* size of group array */
      ga_malloc,                /* size of memory allocated for group array */
      cur_dir_type iev(DIR_ALL),/* current selection type */
      curr_g iev(0),            /* current group */
      curr_i iev(-1),           /* current item */
      news_context iev(1),      /* news level (1,2,3) */
      old_context iev(1),       /* news level (1,2,3) */
      grp_vd,                   /* group display */
      grp_display_size,         /* group display size */
      screen_active iev(0),     /* screen context */
      pid_created iev(0),       /* no screen at all! */
      trailer_vd,               /* input virtual display */
      sdid,                     /* item display */
      shdid,
      g_arrow iev(0),           /* screen group arrow */
      grp_header_vd,
      itm_header_vd,
      gv_size iev(0),
      grp_paste,
      itm_approved,
      forward_posting,
      net_news,
      auto_cre_grp,
      text_displayed iev(0),
      xref_enabled iev(1),
      mail_add_expiry iev(0),
      brdcst_line iev(0),
      brdcst_col iev(0);

extrnl
short response_length;          /* input length */

extrnl
unsigned short mail_flags;

extrnl
char  response[iv(256)],            /* input */
      usr_username[iv(33)],         /* who is this person anyway ? */
      usr_nodename[iv(17)],         /* and where ? */
      usr_persname[iv(256)],
      mail_queue[iv(256)],
      mail_form[iv(256)],
      mail_editor[iv(256)],
      Node_address[iv(80)],         /* Internet node address */
      Editor[iv(132)],              /* editor string */
      Viewer[iv(132)],              /* view command string */
      TPUedit[iv(132)],             /* tpu edit string */
      TPUview[iv(132)],             /* tpu view string */
      no_new_item[iv(132)],         /* add item error text returned */
      news_register[iv(132)],       /* register file name */
      news_register_d[iv(132)],     /* register file name  - back versions*/
      err_oline[iv(80)],            /* err line */
      itm_fname[iv(100)],           /* filename */
      Mail_file[iv(132)],           /* mail temp file name */
      Extract_file[iv(132)],
      Print_file[iv(132)],
      Print_save_file[iv(132)],
      Post_file[iv(132)],
      Organisation_name[iv(132)],
      newsmgr_dir[iv(132)],
      news_timezone[iv(132)],
      fp_open[iv(256)];             /* flag to indicate open files which require closing */


extrnl
FILE *fp;                       /* utility file */

extrnl
struct FAB grpfab,              /* newsgroup file fab */
           itmfab;              /* newsitem file fab */

extrnl
struct RAB grprab,              /* newsgroup file rab */
           itmrab;              /* newsitem file rab */

extrnl
ITM newsitm;                    /* newsitem i/o buffer */

extrnl
GRP newsgrp;                    /* newsgroup i/o buffer */

extrnl
jmp_buf env;

extrnl
GRP_MEM_PTR *ga;

extrnl
NOTE_RANGE d_itm[iv(20)];
