#module NNTP_DEC "V5.5"

/*
**++
**  FACILITY:
**
**      NNTP_DEC
**
**  ABSTRACT:
**
**      This module contains the QIO interface to DECnet for the NNTP
**      server module. This is used to support a single-threaded server.
**
**      The build routines create NEWSSERVER.EXE, a NNTP server for DECnet
**
**  AUTHOR:
**
**      Geoff Huston
**
**  COPYRIGHT:
**
**      Copyright  1988
**
**  MODIFICATION HISTORY:
**
**      V5.5     7-Oct-1988     GIH
**          Revised call interface to server added
**--
**/

#include signal

#define TIMEOUT     300         /* read wait timeout  - 5 minutes */

int f;                          /* decnet object i/o channel file descriptor */

int (*next_function)();         /* next call back to server module */

main()
{
    if (!server_init(1)) exit(1);
    if (!open_net()) exit(1);
    server_init_unit(1);
    while (next_function) (*next_function)(1);
    server_shut();
    close_net();
}

/*
 *  cancel_net
 *
 *  If the read timer expires then cancel this server task (by exiting)
 */

cancel_net()
{
    write_net("400 service discontinued - read timeout\r\n");
    close(f);
    exit(1);
}

/*
 *  read_net
 *
 *  read from the client process - if the read timer expires cancel this server
 */

read_net(buffer,size,unit)
    char *buffer;
    int size;
    int unit;
{
    int b_l;

    signal(SIGALRM,cancel_net);
    alarm(TIMEOUT);
    b_l = read(f,buffer,size);
    alarm(0);
    if (b_l <= 0) exit(1);
    if ((buffer[b_l - 2] == '\r') && (buffer[b_l - 1] == '\n'))
        buffer[--b_l - 1] = '\n';
    buffer[b_l] = '\0';
}

/*
 *  write_net
 *
 *  write to the client process - catch i/o errors and abort
 */

write_net(s,unit)
    char *s;
    int unit;
{
    if (write(f,s,strlen(s)) < 0) exit(1);
}

/*
 *  next_call
 *
 *  Set up the next NNTP server function to call
 */

next_call(unit,func,type)
    int unit;
    int (*func)();
    int type;
{
    next_function = func;
}

/*
 *  open_net
 *
 *  Open decnet channel
 */

open_net()
{
    return((f = open("SYS$NET",2)) != -1);
}

/*
 *  close_net
 *
 *  Close the decnet link
 */

close_net()
{
    close(f);
}
