#module NNTP_TTY "V5.5"

/*
**++
**  FACILITY:
**
**      NNTP_TTY
**
**  ABSTRACT:
**
**      This module contains the QIO interface to the terminal for an
**      interactive interface via NNTP to the local database. (This module
**      is used to check the functionality of the NNTP_SERVER code.
**
**  AUTHOR:
**
**      Geoff Huston
**
**  COPYRIGHT:
**
**      Copyright  1988
**
**  MODIFICATION HISTORY:
**      Compiled using VMS V5.0, VAX C2.4
**
**      V5.3    17-Jun-1988     GIH
**                              Version V5.3 Release
**
**      V5.5     7-Oct-1988     GIH
**              Revised call interface to server added
**--
**/

#include signal

#define TIMEOUT     300         /* read wait timeout  - 5 minutes */

int (*next_function)();

main()
{
    if (!server_init(1)) exit(1);
    if (!open_net()) exit(1);
    server_init_unit(1);
    while (next_function) (*next_function)(1);
    server_shut();
    close_net();
}

/*
 *  cancel_net
 *
 *  If the read timer expires then cancel this server task (by exiting)
 */

cancel_net()
{
    write_net("400 service discontinued - read timeout\r\n");
    exit(1);
}

/*
 *  read_net
 *
 *  read from the client process - if the read timer expires cancel this server
 */

read_net(buffer,size,unit)
    char *buffer;
    int size;
    int unit;
{
    signal(SIGALRM,cancel_net);
    alarm(TIMEOUT);
    gets(buffer);
    alarm(0);
    strcat(buffer,"\n");        /* FIX - add a newline to input string */
}

/*
 *  write_net
 *
 *  write to the client process - catch i/o errors and abort
 */

write_net(s,unit)
    char *s;
    int unit;
{
    printf("%s",s);
}

next_call(unit,func,type)
    int unit;
    int (*func)();
    int type;
{
    next_function = func;
}

/*
 *  open_net
 *
 *  Open tty channel
 */

open_net()
{
    return(1);
}

/*
 *  close_net
 *
 *  Close the tty link
 */

close_net()
{
}
