/*
 * This include file handles fixups needed for the DECthreads implementation
 * of the pthread library definitions  Files that include this file will
 * use the special macros it defines in order to be compatible with
 * both the Posix 1003.1c standard interface the old 1003.4a draft standard.
 */
#ifdef __GNUC__
#define pthread_self pthread_self_hidden
#endif
#include <pthread.h>
#ifdef __DECC
#include <reentrancy.h>
#endif

#ifndef PTHREAD_USE_D4
#ifndef PTHREAD_EXPLICIT_SCHED
/* 
 * When PTHREAD_EXPLICIT_SCHED not defined, assume we are using older draft 4 
 * pthread.h and define standard symbol to use in conditional tests.
 */
#define PTHREAD_USE_D4
#endif
#endif
/*
 * For some reason, the re-defines of malloc and free don't have correspondin
 * entries in the shareable images, so undefine them.
 */
#if defined(VAXC) || defined(_GNUC_)
#ifdef malloc
#undef malloc
#endif
#ifdef free
#undef free
#endif
#ifdef realloc
#undef realloc
#endif
#endif
/*
 * If the c routines ever become thread-reentrant, null out these definitions.
 * As an intermediate step, we've made these dependant upon a global flag.
 */
int http_reentrant_c_rtl;
#ifdef VMS
#define LOCK_C_RTL if ( !http_reentrant_c_rtl ) pthread_lock_global_np();
#define UNLOCK_C_RTL if ( !http_reentrant_c_rtl ) pthread_unlock_global_np();
#else
#define LOCK_C_RTL
#define UNLOCK_C_RTL
#define LOCK_VMS_RTL
#define UNLOCK_VMS_RTL
#endif

int http_reentrant_vms_rtl;
#ifdef VMS
#define LOCK_VMS_RTL 
#define UNLOCK_VMS_RTL
#endif
/*
 * Set symbol that tserver_tcp.h uses to detect if pthread headers known.
 */
#define loaded_pthread_np 1
/*
 * Workaround GCCs problem with structure returned by pthread_self() function.
 */
#ifdef __GNUC__
#undef pthread_self
void pthread_self ( pthread_t * );
static pthread_t gcc_pthread_self() {
    pthread_t temp;
    pthread_self ( &temp );
    return temp;
}
#define pthread_self gcc_pthread_self
#endif

#ifdef PTHREAD_USE_D4
#include <errno.h>
#define INITIALIZE_MUTEX(a) pthread_mutex_init ( a, pthread_mutexattr_default )
#define INITIALIZE_CONDITION(a) pthread_cond_init(a,pthread_condattr_default)
#define INITIALIZE_THREAD_ATTR(a) pthread_attr_create ( a )
#define PTHREAD_ERR_NO(status) ((status)==(-1) ? errno : (status))
#define CREATE_KEY(key,init) pthread_keycreate(key,init)
#define DETACH_THREAD(t) pthread_detach(&t)
#define GET_SPECIFIC(key,lval) \
  if ( pthread_getspecific(key, (pthread_addr_t *) &lval) ) lval =  (void *) 0;
#ifndef _POSIX_4SOURCE
struct sched_param { int sched_priority; };
#endif
#define SET_ATTR_SCHEDPARAM(attr,param) \
  pthread_attr_setprio(attr,(param)->sched_priority)
#define SET_ATTR_SCHEDPOLICY(attr,policy) pthread_attr_setsched(attr,policy)
/*
 * Rename some macros to 1.c forms.
 */
#define PTHREAD_ONCE_INIT  pthread_once_init
#define PTHREAD_EXPLICIT_SCHED PTHREAD_DEFAULT_SCHED

#else
#define INITIALIZE_MUTEX(a) pthread_mutex_init ( a, NULL )
#define INITIALIZE_CONDITION(a) pthread_cond_init ( a, NULL )
#define INITIALIZE_THREAD_ATTR(a) pthread_attr_init ( a )
#define PTHREAD_ERR_NO(status) status
typedef void (*pthread_destructor_t)(void *);
typedef void *(*pthread_startroutine_t)(void *);
#define CREATE_KEY(key,init) pthread_key_create(key, init)
#define DETACH_THREAD(t) pthread_detach(t)
#define GET_SPECIFIC(key,lval) lval=pthread_getspecific(key);
#define SET_ATTR_SCHEDPARAM(attr,param) pthread_attr_setschedparam(attr,param)
#define SET_ATTR_SCHEDPOLICY(attr,policy) pthread_attr_setschedpolicy(attr,policy)
#endif
