//------------------------------------------------------------------------------
// File: ps1.c
//
// Author: David W. Burhans
//
// Date: March 17, 1996
//
// Description:
// This file contains the PureSite order form generation CGI code.
//------------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#ifdef VMS
// Redirect operations to cgilib routines for DECthreads  server script env.
#include "cgilib.h"
#ifdef printf
#undef printf
#endif
#define printf cgi_printf
#ifdef getenv
#undef getenv
#endif
#define getenv cgi_info
#endif

#define LineFeed 10                 // ASCII LineFeed character.
                                    //
typedef enum en_CgiError            // CGI error types.
{                                   //
    CGI_SUCCESS,                    // No error.
    CGI_MEMORY_ERROR,               // Error during memory allocation.
    CGI_ENVIRONMENT_ERROR,          // Server failed to setup the environment correctly.
    CGI_ENUM_END		    // not all compilers like null enun items
} CGI_ERROR;                        //
                                    //
typedef struct st_PostContext     // HTML input field structure.
{                                   //
   char *pszName;                  // Field name.
   char *pszValue;                  // Field value.
} POST_CONTEXT;                     //----------------------------------------------
                                    //
static char *pszErrors[] =          // CGI related error messages.
{                                   // 
    "No error",                     // No error.
    "the server ran out of memory.", // Server ran out of memory.
    "the server failed to setup the CGI environment", // Server failed to setup the environment.
};                                  //------------------------------------------
                                    //
void CgiError(CGI_ERROR error)      // Send error message to the user.
{                                   //
    FILE  *pfileError;              // Error logging file.
    time_t timeError;               // Error time.
    char  *pszErrorTime;            // Error time as a string.
                                    //
    printf("<TITLE>Server Error</TITLE>%c",LineFeed);
    printf("<H1>Server Error</H1>%c",LineFeed);
    printf("Your order can not be processed because %s.<P>%c",
        pszErrors[(int)error], LineFeed);

    pfileError = fopen("~puresite/error.log", "a"); // Open the error log.
    if (NULL != pfileError)         // Error log open was successful.
    {                               //
        timeError = time(NULL);     // Get current time in seconds.
        pszErrorTime = ctime(&timeError); // Get current time as a string.
        pszErrorTime[24] = 0;       // Remove the NewLine character.
        fprintf(pfileError, "%s : %s",pszErrorTime, pszErrors[(int)error]);
        fclose(pfileError);         // Close the error log.
    }

    exit(1);
}

// Return the POST method CGI context.
CGI_ERROR GetPostContext(POST_CONTEXT **ppContext, int *pnEntryCount)
{
    char *pszContext;
    int   nContextLength;
    int   nEntryIndex;
    char *pszEnvironmentVariable;
    int   nIndex;

    pszEnvironmentVariable = getenv("CONTENT_LENGTH");
    if (pszEnvironmentVariable != NULL)
    {
        nContextLength = atoi(pszEnvironmentVariable);
    }
    else
    {
        return CGI_ENVIRONMENT_ERROR;
    }

    pszContext = (char*)malloc(sizeof(char) * nContextLength);
    if (NULL != pszContext)
    {
        for (*pnEntryCount = 0, nIndex = 0; nIndex < nContextLength; ++nIndex)
        {
            if (pszContext[nIndex] == '&')
            {
                ++(*pnEntryCount);
            }
        }

        *ppContext = malloc(sizeof(POST_CONTEXT) * (*pnEntryCount));
        if (NULL != *ppContext)
        {
            for (nEntryIndex = 0, nIndex = 0; nEntryIndex < *pnEntryCount; ++nEntryIndex)
            {
                ppContext[nEntryIndex]->pszName = &pszContext[nIndex];
                for (;pszContext[nIndex] != '=' && nIndex < nContextLength; ++nIndex)
                {
                    ;
                }

                if (nIndex == nContextLength)
                {
                    free(pszContext);
                    free(*ppContext);
                    return CGI_ENVIRONMENT_ERROR;
                }

                pszContext[nIndex] = 0;
                ++nIndex;

                ppContext[nEntryIndex]->pszValue = &pszContext[nIndex];
                for (;pszContext[nIndex] != '&' && nIndex < nContextLength; ++nIndex)
                {
                    ;
                }

                if ((nIndex == nContextLength) && (nEntryIndex != *pnEntryCount))
                {
                    free(pszContext);
                    free(*ppContext);
                    return CGI_ENVIRONMENT_ERROR;
                }

                pszContext[nIndex] = 0;
                ++nIndex;
            }
        }
        else
        {
            free(pszContext);
            return CGI_MEMORY_ERROR;
        }
    }
    else
    {
        return CGI_MEMORY_ERROR;
    }
}

typedef struct st_Product
{
    char  *pszName;
    double fPrice;
} PRODUCT;

PRODUCT product[] =
{
    { "china_rain_oil", 7.15 },
    { "china_rain_stick", 3.0 },
    { "dreams_oil", 9.0 },
    { "dreams_stick", 3.0 },
    { "eucalyptus_oil", 4.25 },
    { "eucalyptus_stick", 3.0 },
    { "gardina_oil", 7.15 },
    { "gardina_stick", 3.0 },
    { "jasmine_oil", 7.15 },
    { "jasmine_stick", 3.0 },
    { "juniper_oil", 6.55 },
    { "juniper_stick", 3.0 },
    { "lavander_oil", 9.15 },
    { "lavander_stick", 3.0 },
    { "mango_oil", 7.15 },
    { "mango_stick", 3.0 },
    { "patchouli_oil", 5.6 },
    { "patchouli_stick", 3.0 },
    { "rose_oil", 6.1 },
    { "rose_stick", 3.0 },
    { "sandalwood_oil", 9.15 },
    { "sandalwood_stick", 3.0 },
    { "vanilia_oil", 7.15 },
    { "vanilia_stick", 3.0 },
    { "wood_blue_burner", 3.75 },
    { "ceramic_blue_burner", 16.0 },
    { "wood_black_burner", 3.75 },
    { "ceramic_black_burner", 16.0 },
    { "wood_natural_burner", 3.75 },
    { "ceramic_white_burner", 16.0 },
    { "diffuser", 6.0 },
    { "lamp_ring", 6.0 }
};

void OrderFormHeader(void)
{
    printf("<HEAD><TITLE>PureSite Order Form</TITLE></HEAD>");
    printf("<BODY><CENTER><H1>PureSite Order Form</H1><HR>");
//    printf("<FORM METHOD=POST ACTION=\"http://www.GANet.NET/cgi-bin/ps2\"\12");

//    The next line is for testing purposes only!
    printf("<FORM METHOD=POST ACTION=\"http://hoohoo.ncsa.uiuc.edu/cgi-bin/post-query\"\12");
    printf("<TABLE BORDER=2><TR><TH>Product</TH><TH>Quantity</TH><TH>UnitPrice</TH><TH>Total</TH></TR>\12");
}

void OrderFormClose(void)
{
    printf("Please fill out all fields below, or we will not be able to process your order.<P>\12");
    printf("<P><TABLE><TR><TD>Name:</TD><TD><INPUT SIZE=50 NAME=\"Name\" VALUE=\"\"></TD></TR>\12");
    printf("<TR><TD>Address:</TD><TD><INPUT SIZE=50 NAME=\"Address1\" VALUE=\"\"></TD></TR>\12");
    printf("<TR><TD></TD><TD><INPUT SIZE=50 NAME=\"Address2\" VALUE=\"\"></TD></TR>\12");
    printf("<TR><TD></TD><TD><INPUT SIZE=50 NAME=\"Address3\" VALUE=\"\"></TD></TR>\12");
    printf("<TR><TD></TD><TD><INPUT SIZE=50 NAME=\"Address4\" VALUE=\"\"></TD></TR>\12");
    printf("<TR><TD>Telephone:</TD><TD><INPUT SIZE=50 NAME=\"Telephone\" VALUE=\"\"></TD></TR>\12");
    printf("<P><TR><TD>Credit card:</TD><TD><INPUT TYPE=\"radio\" NAME=\"CardType\" VALUE=\"VISA\">VISA</TD></TR>\12");
    printf("<TR><TD></TR><TD><INPUT TYPE=\"radio\" NAME=\"CardType\" VALUE=\"MasterCard\">MasterCard</TD></TR>\12");
    printf("<TR><TD>Card number:</TD><TD><INPUT SIZE=50 NAME=\"CardNumber\" VALUE=\"\"></TD></TR>");
    printf("<TR><TD>Expiration date:</TD><TD><INPUT SIZE=50 NAME=\"Expiration\" VALUE=\"\"></TD></TR>\12");
    printf("<P><TR><TD COLSPAN=2><B>All credit card information is kept totally confidential.\12");
    printf("</TABLE><P>\12");
    printf("<INPUT TYPE=\"submit\" VALUE=\"Continue With Purchase\"></FORM>\12");
}

void BadProductRequest(void)
{
    printf("<TITLE>Invalid Order</TITLE>");
    printf("<H1>Invalid Order</H1>");
    printf("<P>It seems that all products had a quantity of zero<BR>");
    printf("Please make the appropriate changes to your order form and");
    printf("resubmit your order.<P>");
    printf("Thank you for shopping PureSite.");
}

int main(int argc, char **argv)
{
    CGI_ERROR       cgiCC;
    POST_CONTEXT   *ppostContext;
    int             nEntryCount;
    int             nIndex;
    int             nProductIndex;
    int             nQuantity;
    double          dSubTotal = 0.0;
#ifdef VMS
    int status;
    status = cgi_init ( argc, argv );
    if ( (status&1) == 0 ) exit(status);	// init error
#endif

    printf("Content-type: text/html\12\12");

    cgiCC = GetPostContext(&ppostContext, &nEntryCount); // Retrieve the post context.
    if (CGI_SUCCESS == cgiCC)       // Retrieval was successful.
    {                               //
        for (nIndex = 0; nIndex < nEntryCount; ++nIndex)
        {
            if (ppostContext[nIndex].pszValue)
            {
                nQuantity = atoi(ppostContext[nIndex].pszValue);
                if (0 < nQuantity)
                {
                    nProductIndex = atoi(ppostContext[nIndex].pszName);
                    dSubTotal += ((double)nQuantity * product[nProductIndex].fPrice);
                }
            }
        }

        if (0.0 != dSubTotal)
        {
            OrderFormHeader();

            for (nIndex = 0; nIndex < nEntryCount; ++nIndex)
            {
                if (ppostContext[nIndex].pszValue)
                {
                    nQuantity = atoi(ppostContext[nIndex].pszValue);
                    if (0 < nQuantity)
                    {
                        nProductIndex = atoi(ppostContext[nIndex].pszName);

                        printf("<TR><TD>%s</TD><TD>%d</TD><TD ALIGN=right>US$ %3.2f</TD><TH ALIGN=right>US$ %3.2f</TH></TR>\12",
                            product[nProductIndex].pszName, nQuantity,
                            product[nProductIndex].fPrice,
                            ((double)nQuantity * product[nProductIndex].fPrice));

                        printf("<INPUT TYPE=HIDDEN NAME=\"%s\" VALUE=\"%s\"",
                            product[nProductIndex].pszName,
                            product[nProductIndex].fPrice);
                    }
                }
            }

            printf("<INPUT TYPE=HIDDEN NAME=\"SubTotal\" VALUE=\"%3.2f\"",
                dSubTotal);
            printf("<INPUT TYPE=HIDDEN NAME=\"Total\" VALUE=\"%3.2f\"",
                (dSubTotal + 5.0));
            printf("<TR><TD></TD><TD COLSPAN=2 ALIGN=right>dSubTotal:</TD><TH>US$ %3.2f</TH></TR>\12",dSubTotal);
            printf("<TR><TD></TD><TD COLSPAN=2 ALIGN=right>Shipping and Handling:</TD><TH>US$ 5.00</TH></TR>\12");
            printf("<TR><TD></TD><TH COLSPAN=2 ALIGN=right>Total:</TH><TH>US$ $3.2</TH></TR>\12",
                (dSubTotal + 5.0));
            printf("</TABLE></CENTER><P>\12");

            OrderFormClose();
        }
        else
        {
            BadProductRequest();
        }

        free(ppostContext[0].pszName);   // Free the context string.
        free(ppostContext);               // Free the context entry structures.
    }
    else
    {
        CgiError(cgiCC);
    }

   return 0;
}
