$!
$! This procedure is invoked by WWWEXEC.COM to handle posting/putting of 
$! documents.  DECnet file access is used to perform file operations to
$! ensure writes occur by authorized personel.
$!
$! Date: 6-APR-1996
$! revised: 8-APR-1996
$!
$ set noon
$ crlf = f$fao("!/")
$ put = "write net_link"
$ www_max_cgilib_content = 128000
$ authentication_header = "WWW-authenticate: Basic realm=""Server upload"
$!
$! Read content into temporary file and put CGI vars in logical name table.
$!
$ tfile = "sys$scratch:wwwexec_" + method + f$getjpi("0","PID") + ".tmp"
$ create/name_table cgi_env		! holds environment logicals.
$ mcr www_root:[bin]cgi_symbols.exe cgi_env 'tfile'
$ set file 'tfile'/attribute=rfm:stm
$!! show log/table=cgi_env
$!
$! Decode the host or authorization header into username and password.
$! encoding packs 6 bits per character.
$!
$ www_http_host = f$trnlnm("HTTP_HOST","CGI_ENV")
$ if www_http_host .nes. ""
$ then
$    auth_decoded = f$element(0,"@",www_http_host)
$ else
$    www_http_authorization = f$trnlnm("HTTP_AUTHORIZATION","CGI_ENV")
$    if WWW_HTTP_AUTHORIZATION .eqs. "" then goto auth_fail
$    auth_encoded = f$edit(www_http_authorization,"TRIM,COMPRESS")
$    auth_type = f$edit(f$element(0," ",auth_encoded),"UPCASE")
$    fail_reason = ", unknown type"
$    if auth_type .nes. "BASIC" then goto auth_fail
$    fail_reason = ", authorization syntax error"
$    auth_encoded = f$element(1," ",auth_encoded)
$    auth_decoded = ""
$    div_4 = 16		! divisor for getting high 4 bits
$    div_6 = 4		! ""                       2
$    div_8 = 1
$    i = 0			! encoded string character position
$    opos = 0		! decoded string bit position
$    low = 0		! tracks spillover bits.
$    next_hex:
$       c = f$extract(i,1,auth_encoded)
$       if c .eqs. "=" .or. c .eqs. "" then goto hex_done
$       n = f$locate(c,-
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/")
$       if n .gt. 63 then goto bad_hex
$       low = low + 2
$       if ( low .gt. 2 )
$       then
$      	auth_decoded[opos,low-2] = n / div_'low'
$         	opos = opos + 8
$       endif
$       if ( low .lt. 8 )
$       then
$   	   auth_decoded[opos+low,8-low] = n
$       else
$        	low = 0
$       endif
$       i = i + 1
$       if i .lt. 200 then goto next_hex
$!
$   auth_fail:
$     put "content-type: text/plain",crlf, - 	! CGI header
         "Status: 401 authorization failed''fail_reason'",crlf, -
         authentication_header,crlf,crlf
$     goto cleanup
$   hex_done:
$     if low .lt. 8 then auth_decoded = f$extract(0,opos/8,auth_decoded)
$ endif
$!
$! Construct DECnet node specification as logical with user and node.
$!
$ password = f$element(1,":",auth_decoded)
$ if password .eqs. "" .or. password .eqs. ":" then auth_decoded = "-:-"
$ node_spec = "0""""" + f$element(0,":",auth_decoded) + " " + -
	f$element(1,":",auth_decoded) + """""::"
$ hide_pwd = f$verify(0)
$ define/nolog wwwpost_this_node "''node_spec'"
$ hide_pwd = f$verify(hide_pwd)
$!
$! See if request included content and that destination path had a translation.
$!
$ path_translated = f$trnlnm("PATH_TRANSLATED","CGI_ENV")
$ content_length = f$trnlnm("CONTENT_LENGTH","CGI_ENV")
$ if content_length .eqs. "" then content_length = "-1"
$ content_length = f$integer(content_length)
$ if ( content_length .ge. 0 .and. path_translated .nes. "" )
$ then
$!
$!      Convert path_translated to VMS format.
$!
$	fulldir = f$element(1,"/",path_translated) + ":"
$	separator = "["
$	final_sep = ""
$	i = 2
$	next_part = f$element(i,"/",path_translated)
$ next_slash:
$	i = i + 1
$	last_part = next_part
$	next_part = f$element(i,"/",path_translated)
$	if next_part .eqs. "/"
$	then
$	    fulldir = fulldir + final_sep + last_part
$	else
$	    fulldir = fulldir + separator + last_part
$	    separator = "."
$	    final_sep = "]"
$	    goto next_slash
$	endif
$ else
$	put "Content-type: text/plain",crlf, -
$		"Status: 400 no content",crlf,crlf,-
		"Missing content or indecipherable header",crlf
$	goto cleanup
$ endif
$!
$! Copy content file to final destination, using authenicated username
$! and password so ownership is retained.
$!
$ expanded_fulldir = f$parse(fulldir,,,,"NO_CONCEAL")	! dont' assume logicals
$ if expanded_fulldir .eqs. ""
$ then
$     put "Content-type: text/plain",crlf,"Status: 500 post error", crlf, -
	    crlf, "Post to ", fulldir, " failed, bad parse", crlf
$    goto cleanup
$ endif
$ copy 'tfile' wwwpost_this_node::'expanded_fulldir'/log
$ status = $status
$ if ( status ) 
$ then 
$    put "Content-type: text/plain",crlf, crlf, -
		"Post to ", fulldir, "completed", crlf
$ else
$!
$!   Error in copy, try to make more specific.
$!
$    open/read auth_ver wwwpost_this_node::login.com
$    status2 = $status
$    if status2 then close auth_ver
$!
$    condition = f$message(status2,"IDENT")
$    if status2 .or. (condition .eqs. "%FNF")
$    then
$!	File or directory exists, indicating username/password good so
$!	copy must have failed for reasons other than invalid login.
$!
$        put "Content-type: text/plain",crlf,"Status: 500 post error", crlf, -
	    crlf, "Post to ", expanded_fulldir, " failed", crlf, -
	    f$message(status),crlf
$    else
$!
$!	Assume DEnet problem.
$!
$	put "content-type: text/plain",crlf
$	if condition .eqs. "%ACC"
$	then
$	    rsp = "401"
$	    if f$type(www_http_authorization) .nes. "" then rsp = "403"
$	    put "Status: ''rsp' authorization failed",crlf, -
         	    authentication_header,crlf,crlf,-
		    "Login information invalid",crlf
$	else
$	     put "Status: 500 DECnet error", crlf,crlf, -
		"Possible network configuration error: ",f$message(status),crlf
$	endif
$    endif
$ endif
$ write sys$output "Full dir: ", fulldir
$!
$! Delete temporary resources and exit.
$!
$ cleanup:
$  deassign/table=lnm$process_directory cgi_env
$  if f$trnlnm("wwwpost_this_node","LNM$PROCESS") .nes. "" then -
	deassign wwwpost_this_node
$  delete 'tfile';*
$ exit
