#
# MMS Description file for XAnim
#
# Based on the Unix Makefile
# Made by Rick Dyson (dyson@IowaSP.Physics.UIowa.EDU)
# Created  17-NOV-1993 for XAnim v2.60.0
# Modified 10-JUN-1994 for XAnim v2.68
# Modified 22-DEC-1994 for XAnim v2.69.7.4a
# Modified 19-JAN-1995 for XAnim v2.69.7.5
# Modified 31-JAN-1995 for XAnim v2.69.7.6
# Modified 02-MAY-1995 for XAnim v2.69.7.8
# Modified  5-JAN-1996 for XAnim v2.70.3

#####################################
# Choose your favorite compiler.
#
# standard VAX C
CC = cc /Warnings = NoInformationals

# For building on a Alpha OpenVMS with DEC C, invoke with
# MMS /Macro = Alpha=1

.ifdef Alpha
ALP = /Prefix = All /Include = ([], X11:)
.endif

#####################################
# Machine Specific Flags
# 
# NO_INSTALL_CMAP prevents XAnim from specifically installing a cmap.
#  this causes problems on some PC versions of X11
#MACH = "NO_INSTALL_CMAP"

#####################################
#
# If you use DECWindows XUI (not Motif) use this define
# 
#DEFS = /Define = R3_INTRINSICS

#####################################
# Optimization flags
#
OPTIMIZE= /Optimize

#####################################
# Debug flags
#
#DEBUG = /Debug /NoOptimize

#####################################
# Note sure about XA_REMOTE_DEFS. Comment them out if you have compile
# problems.
#
#XA_REMOTE_DEFS = /Define = (XA_MOTIF,_NO_PROTO,XA_FORK)
#XA_REMOTE_DEFS = -DXA_MOTIF -D_NO_PROTO

#####################################
#  FINAL CFLAGS
#
CFLAGS	=  $(CFLAGS) $(OPTIMIZE) $(DEBUG) $(DEFS) $(XA_REMOTE_DEFS) $(ALP)

#####################################
#  Give the path to your include directories
#
.first
.ifdef Alpha
	@ Define /NoLog Sys Sys$Library
.else
	@ Define /NoLog Sys Sys$Library
	@ Define /NoLog X11 DECW$Include
	@ Define /NoLog VAXC$INCLUDE DECW$Include,Sys$Library
.endif

CFILES = xanim.c xa_show.c xa_x11.c xa_fli.c xa_iff.c  \
	xa_gif.c xa_txt.c unpacker.c xa_utils.c xa_act.c \
	xa_set.c xa_cmap.c xa_rle.c xa_wav.c xa_au.c \
	xa_avi.c xa_qt.c xa_audio.c xa_color.c \
	xa_jpg.c xa_mpg.c xa_dl.c xa_jmov.c \
	xa_replay.c xa_dumfx.c

OFILES = xanim.obj xa_show.obj xa_x11.obj xa_fli.obj xa_iff.obj  \
	xa_gif.obj xa_txt.obj unpacker.obj xa_utils.obj xa_act.obj \
	xa_set.obj xa_cmap.obj xa_rle.obj xa_wav.obj xa_au.obj \
	xa_avi.obj xa_qt.obj xa_audio.obj xa_color.obj \
	xa_jpg.obj xa_mpg.obj xa_dl.obj xa_jmov.obj \
	xa_replay.obj xa_dumfx.obj

xanim :		xanim.exe xanim.hlb
	@ Write Sys$Output ""
	@ Write Sys$Output "A Successful build of XANIM v2.70.3"

xanim.exe : $(OFILES) xanim.opt
	- $(LINK) $(LINKFLAGS) xanim.opt/Option

xa_show.obj : xanim.h xa_show.c
	- CC /NoWarnings $(CFLAGS) xa_show.c

xa_x11.obj : xanim.h xa_config.h xa_x11.h xa_x11.c
	- CC /NoWarnings $(CFLAGS) xa_x11.c

xa_avi.obj : xanim.h xa_config.h xa_avi.h xa_avi.c
        - CC /NoWarnings $(CFLAGS) xa_avi.c

xa_qt.obj : xanim.h xa_config.h xa_qt.h xa_qt.c
        - CC /NoWarnings $(CFLAGS) xa_qt.c

.c.obj :
	$(CC) $(CFLAGS) $*.c

xanim.opt :
	- @Make_OptionFile.com

# DO NOT DELETE THIS LINE
xanim.obj : xanim.h
xanim.obj : xa_config.h
xanim.obj : xa_x11.h
xanim.obj : xanim.c
xa_fli.obj : xanim.h
xa_fli.obj : xa_config.h
xa_fli.obj : xa_fli.h
xa_fli.obj : xa_fli.c
xa_iff.obj : xanim.h
xa_iff.obj : xa_config.h
xa_iff.obj : xa_iff.h
xa_iff.obj : xa_iff.c
xa_gif.obj : xanim.h
xa_gif.obj : xa_config.h
xa_gif.obj : xa_gif.h
xa_gif.obj : xa_gif.c
xa_txt.obj : xanim.h
xa_txt.obj : xa_config.h
xa_txt.obj : xa_txt.c
xa_dl.obj : xanim.h
xa_dl.obj : xa_config.h
xa_dl.obj : xa_dl.h
xa_dl.obj : xa_dl.c
xa_pfx.obj : xanim.h
xa_pfx.obj : xa_config.h
xa_pfx.obj : xa_pfx.h
xa_pfx.obj : xa_pfx.c
xa_rle.obj : xanim.h
xa_rle.obj : xa_config.h
xa_rle.obj : xa_rle.h
xa_rle.obj : xa_rle.c
xa_wav.obj : xanim.h
xa_wav.obj : xa_config.h
xa_wav.obj : xa_avi.h
xa_wav.obj : xa_wav.c
xa_au.obj : xanim.h
xa_au.obj : xa_config.h
xa_au.obj : xa_au.c
xa_jpg.obj : xanim.h
xa_jpg.obj : xa_config.h
xa_jpg.obj : xa_jpg.h
xa_jpg.obj : xa_jpg.c
xa_mpg.obj : xanim.h
xa_mpg.obj : xa_config.h
xa_mpg.obj : xa_mpg.h
xa_mpg.obj : xa_mpg.c
xa_mpg.obj : xa_jpg.c
xa_jmov.obj : xanim.h
xa_jmov.obj : xa_config.h
xa_jmov.obj : xa_jmov.h
xa_jmov.obj : xa_jmov.c
xa_replay.obj : xanim.h
xa_replay.obj : xa_config.h
xa_replay.obj : xa_replay.h
xa_replay.obj : xa_replay.c
xa_set.obj : xanim.h
xa_set.obj : xa_config.h
xa_set.obj : xa_iff.h
xa_set.obj : xa_iff.c
xa_set.obj : xa_set.h
xa_set.obj : xa_set.c
xa_act.obj : xanim.h
xa_act.obj : xa_config.h
xa_act.obj : xa_act.c
xa_color.obj : xanim.h
xa_color.obj : xa_color.c
xa_dumfx.obj : xanim.h
xa_dumfx.obj : xa_dumfx.c
xa_utils.obj : xanim.h
xa_utils.obj : xa_config.h
xa_utils.obj : xa_utils.c
xa_cmap.obj : xanim.h
xa_cmap.obj : xa_config.h
xa_cmap.obj : xa_cmap.c
xa_audio.obj : xanim.h
xa_audio.obj : xa_config.h
xa_audio.obj : xa_audio.h
xa_audio.obj : xa_audio.c
xa_ipc.obj : xanim.h
xa_ipc.obj : xa_config.h
xa_ipc.obj : xa_ipc.h
xa_ipc.obj : xa_ipc.c
unpacker.obj : unpacker.c

clean :
	@- Delete /NoLog /NoConfirm *.obj;*
	@- Purge /NoLog /NoConfirm
