@ [Inherit('SYS$LIBRARY:STARLET')] Module GET_UAI (Input, Output);  K (************************************************************************** K *                 (FUNCTION)      G E T _ U A I                           * K *                                                                         * K *      Linguaggio:     PASCAL                                             * K *      Autore:         Franco                          Versione 1.2       * K *      Created:        29-AUG-1989                                        * K *      Last revision:  09-SEP-1991  (08)  (FB)                            * K *                                                                         * K *      Utenza:         FB                                                 * K *-------------------------------------------------------------------------* K *------------------------D O C U M E N T A Z I O N E----------------------* K *-------------------------------------------------------------------------* K *                 (FUNCTION)     G E T _ U A I                            * K *                                                                         * K *      Funzione Pascal  di  interfaccia  per la system service $GETUAI.   * K *      Serve  per  ottenere  informazioni su  un determinato utente  in   * K *      SYSUAF.                                                            * K *                                                                         * K *      Deve essere  chiamata  fornendo  in input  l'username, il  campo   * K *      in SYSUAF  di  cui si  vuole ottenere  l'informazione, la varia-   * K *      bile  intera  nella quale  verra` fornito  il valore  di ritorno   * K *      da $GETUAI  (quando numerico), la  variabile stringa nella quale   * K *      verra` fornito il valore di ritorno da $GETUAI (quando stringa).   * K *                                                                         * K *      Restituisce, come  integer,  lo stato  della chiamata a $GETUAI,   * K *      quando questa viene  effettuata,  o  uno  stato  aggiuntivo (nel   * K *      caso  in  cui il field richiesto non venga supportato dalla pre-   * K *      sente routine).                                                    * K *                                                                         * K *                            ********************                         * K *                                                                         * K *                      MODALITA` DI CHIAMATA DA PASCAL                    * K *                                                                         * K *      Chiamata consigliata  (da Pascal  -  "stringa" e` suggerito come   * K *      VARYING [XX] OF CHAR, dove XX<=512):                               * K *                                                                         * K *      [External] FUNCTION GET_UAI (VAR p1,P2 : stringa;                  * K *                                   VAR P3    : INTEGER;                  * K *                                   VAR p4    : stringa): Integer;        * K *      Extern;                                                            * K *                                                                         * K *                            ********************                         * K *                                                                         * K *                           DESCRIZIONE  PARAMETRI                        * K *                                                                         * K *                                                                         * K *      PARAMETRI: P1: USRNAM (Username - da fornire a GET_UAI);           * K *                     Type:      Char_String                              * K *                     Access:    Read only                                * K *                     Mechanism: by value                                 * K *                                                                         * K *                 P2: Item (Item-descriptor - da fornire a GET_UAI)       * K *                     Type:      Char_String                              * K *                     Access:    Read only                                * K *                     Mechanism: by value                                 * K *                                                                         * K *                 P3: RESULTANT_VALUE (Intero fornito da GET_UAI)         * K *                     Type:      Integer;                                 * K *                     Access:    Write only                               * K *                     Mechanism: by value                                 * K *                                                                         * K *                 P4: RESULTANT_STRING (Stringa fornita da GET_UAI)       * K *                     Type:      Char_String                              * K *                     Access:    Write only                               * K *                     Mechanism: by value                                 * K *                                                                         * K *                            ********************                         * K *                                                                         * K *                             STATI DI RITORNO                            * K *                                                                         * K *      RETURNS:       STATUS (valore di GET_UAI)                          * K *                     Type:      Integer                                  * K *                     Access:    Write only                               * K *                     Mechanism: by value                                 * K *                                                                         * K *      Ritorna: tutti gli stati della Sys.Serv. $GETUAI, piu` il valore   * K *      SS$_UNSUPPORTED (in caso di item non supportati).                  * K *                                                                         * K *                            ********************                         * K *                           FIELDS SUPPORTATI (P2)                        * K *                                                                         * K *         ACCOUNT          fornisce  solo stringa (intero=0)              * K *         ASTLM            fornisce  intero e stringa                     * K *         BATCH_ACCESS_P   fornisce  intero e stringa                     * K *         BATCH_ACCESS_S   fornisce  intero e stringa                     * K *         BIOLM            fornisce  intero e stringa                     * K *         BYTLM            fornisce  intero e stringa                     * K *         CLITABLES        fornisce  solo stringa (intero=0)              * K *         CPUTIM           fornisce  intero e stringa                     * K *         DEFCLI           fornisce  solo stringa (intero=0)              * K *         DEFDEV           fornisce  solo stringa (intero=0)              * K *         DEFDIR           fornisce  solo stringa (intero=0)              * K *         DEF_PRIV         fornisce  intero e stringa                     * K *         DFWSCNT          fornisce  intero e stringa                     * K *         DIALUP_ACCESS_P  fornisce  intero e stringa                     * K *         DIALUP_ACCESS_S  fornisce  intero e stringa                     * K *         DIOLM            fornisce  intero e stringa                     * K *         ENCRYPT          fornisce  intero e stringa                     * K *         ENCRYPT2         fornisce  intero e stringa                     * K *         ENQLM            fornisce  intero e stringa                     * K *         EXPIRATION       fornisce  intero e stringa                     * K *         FILLM            fornisce  intero e stringa                     * K *         FLAGS            fornisce  solo stringa (intero=0)              * K *         JTQUOTA          fornisce  intero e stringa                     * K *         LASTLOGIN_I      fornisce  intero e stringa                     * K *         LASTLOGIN_N      fornisce  intero e stringa                     * K *         LGICMD           fornisce  solo stringa (intero=0)              * K *         LOCAL_ACCESS_P   fornisce  intero e stringa                     * K *         LOCAL_ACCESS_S   fornisce  intero e stringa                     * K *         LOGFAILS         fornisce  intero e stringa                     * K *         MAXACCTJOBS      fornisce  intero e stringa                     * K *         MAXDETACH        fornisce  intero e stringa                     * K *         MAXJOBS          fornisce  intero e stringa                     * K *         NETWORK_ACCESS_P fornisce  intero e stringa                     * K *         NETWORK_ACCESS_S fornisce  intero e stringa                     * K *         OWNER            fornisce  solo stringa (intero=0)              * K *         PBYTLM           fornisce  intero e stringa                     * K *         PGFLQUOTA        fornisce  intero e stringa                     * K *         PRCCNT           fornisce  intero e stringa                     * K *         PRI              fornisce  intero e stringa                     * K *         PRIMEDAYS        fornisce  solo stringa (intero=0)              * K *         PRIV             fornisce  intero e stringa                     * K *         PWD              fornisce  intero e stringa                     * K *         PWD2             fornisce  intero e stringa                     * K *         PWD_DATE         fornisce  intero e stringa                     * K *         PWD2_DATE        fornisce  intero e stringa                     * K *         PWD_LENGTH       fornisce  intero e stringa                     * K *         PWD_LIFETIME     fornisce  intero e stringa                     * K *         QUEPRI           fornisce  intero e stringa                     * K *         REMOTE_ACCESS_P  fornisce  intero e stringa                     * K *         REMOTE_ACCESS_S  fornisce  intero e stringa                     * K *         SALT             fornisce  intero e stringa                     * K *         SHRFILLM         fornisce  intero e stringa                     * K *         TQCNT            fornisce  intero e stringa                     * K *         UIC              fornisce  intero e stringa                     * K *         USERNAME         fornisce  solo stringa (intero=0)              * K *         WSEXTENT         fornisce  intero e stringa                     * K *         WSQUOTA          fornisce  intero e stringa                     * K *                                                                         * K *                                                                         * K *-------------------------------------------------------------------------* K *                          A G G I O R N A M E N T I                      * K *                             (cambi   versione)                          * K *                                                                         * K *      V1.0         versione di partenza.                                 * K *                   6-OCT-1989 FB: Risolto problema con DIOLM: per er-    * K *                   rore scaricavo il  risultato in un'integer  invece    * K *                   che in una Word.                                      * K *                   9-OCT-1989 FB: Risolto problema  con JTQUOTA:  per    * K *                   errore scaricavo in Word invece che in Integer.       * K *                   14-NOV-1989 FB: implementata  piccola patch per il    * K *                   campo MAXDETACH: prima non gestiva il valore NONE,    * K *                   ma  ritornava  in  stringa  65535. Ora  ritorna la    * K *                   stringa NONE.                                         * K *                                                                         * K *      V1.1         10-MAY-1990 FB: implementato riconoscimento dei pri-  * K *                   vilegi,  con l'eccezione di GRPPRV, READALL, SECU-    * K *                   RITY. Supportato item PRIV e DEFPRIV.                 * K *                   11-MAY-1990 FB: implementato riconoscimento delle     * K *                   date; supportati campi LASTLOGIN_I e _N, EXPIRATION,  * K *                   PWD_DATE, PWD_LIFETIME, PWD2_DATE.                    * K *                   15-MAY-1990 FB:  implementato  riconoscimento  UIC;   * K *                   supportato campo UIC.                                 * K *                   16-MAY-1990 FB: implementato riconoscimento accessi;  * K *                   supportati campi:   BATCH_ACCESS_P,  BATCH_ACCESS_S,  * K *                   DIALUP_ACCESS_P,   DIALUP_ACCESS_S,  LOCAL_ACCESS_P,  * K *                   LOCAL_ACCESS_S,  NETWORK_ACCESS_P, NETWORK_ACCESS_S,  * K *                   REMOTE_ACCESS_P, REMOTE_ACCESS_S. Implementato rico-  * K *                   noscimento  primedays;  supportato  campo  PRIMEDAYS  * K *                   (che era l'ultimo in lista di attesa).                * K *                   17-MAY-1990 FB: implementato riconoscimento flags     * K *                                                                         * K *      V1.2         09-SEP-1991 FB: implementato riconoscimento dei due   * K *                   flag DISPWDDIC e DISPWDHIS, novita` di VMS 5.4;       * K *                   grazie alla struttura di GET_UAI, pero`, essa puo`    * K *                   essere utilizzata senza problemi anche in VMS 5.3.    * K *                                                                         * K **************************************************************************)    [HIDDEN] CONST   Lim_1 = 512;  
 [HIDDEN] TYPE #   String = Varying [Lim_1] OF Char;    [HIDDEN] VAR   Status : Integer;     8 [Global] FUNCTION Get_uai (VAR Usrnam          : String;8                            VAR Item            : String;9                            VAR Resultant_value : Integer; I                            VAR Resultant_string: String)       : Integer;    TYPE  K    Quadword         = Unsigned;   (* tratto come UNSIGNED per difficolta` a L                                     rendere una quadword; spero che basti *)   VAR        Q_out             : Quadword;  '    W_out             : [Word] 0..65535;   (    Tri_bytes         : [Byte(3)] 0..255;  %    B_out             : [Byte] 0..255;       Uic_Long : Unsigned;       Giorni : PRIMEDAYS$TYPE;        Flags  : FLAGS$TYPE;      
    Bin_msk_g, 
    Bin_msk_m, 
    Garb_s,	    S_out, 	    Field, -    Us                : Varying [512] OF Char;       Garbage,     Buff_len,    Prepare_routine, 	    I_out,     It,    Lun,     Filler_Status,     Status            : Integer;        Filler_Length     : Unsigned;      Item_list         : Record 9                          Buffer_length : [Word] 0..65535; 9                          Item_code     : [Word] 0..65535; 1                          Buffer_address: Integer; 1                          Return_length : Integer; 1                          End_of_list   : Integer;                         End;     < [External] FUNCTION STR$trim (%DESCR A,B : String): Integer;            Extern;    9 [External] FUNCTION LIB$SYS_ASCTIM (%REF   lu : Unsigned; 7                                     %DESCR ot : String; 9                                     %REF   it : Unsigned; B                                     %REF   fl : Unsigned):Integer;            Extern;    4 PROCEDURE Set_Prepare (P_it,P_prep,P_len : Integer);    Begin    It:=P_it;    Prepare_routine:=P_prep;     Buff_len:=P_len  End;     ) PROCEDURE Unpad (VAR In_s,Out_s: string);   VAR   found : Integer;  BEGIN%    found:=find_nonmember(In_s,[' ']); 3    Out_s:=SUBSTR(In_S,found,(length(In_s)-found+1))   End;     * PROCEDURE Unzero (VAR In_s,Out_s: string);  VAR   found : Integer;  BEGINB    Found:=find_member(In_s,['1','2','3','4','5','6','7','8','9']);    IF Found > 0 ;       Then Out_s:=SUBSTR(In_S,found,(length(In_s)-found+1))        Else Out_s:='0'   End;      PROCEDURE Recognize_Privilege;    VAR   Exponent  : integer;   resultant : Unsigned;I    BEGIN t   Resultant_String:='';*   FOR Exponent:=0 to 30 DO	    BEGIN *3     resultant:=UAND((2**Exponent),Resultant_Value);      CASE Int(Resultant) OFB 	PRV$M_ALLSPOOL 	: Resultant_String:=Resultant_String+',ALLSPOOL';> 	PRV$M_BUGCHK 	: Resultant_String:=Resultant_String+',BUGCHK';> 	PRV$M_BYPASS 	: Resultant_String:=Resultant_String+',BYPASS';> 	PRV$M_CMEXEC 	: Resultant_String:=Resultant_String+',CMEXEC';> 	PRV$M_CMKRNL 	: Resultant_String:=Resultant_String+',CMKRNL';> 	PRV$M_DETACH 	: Resultant_String:=Resultant_String+',DETACH';B 	PRV$M_DIAGNOSE 	: Resultant_String:=Resultant_String+',DIAGNOSE';@ 	PRV$M_EXQUOTA 	: Resultant_String:=Resultant_String+',EXQUOTA';< 	PRV$M_GROUP 	: Resultant_String:=Resultant_String+',GROUP';> 	PRV$M_GRPNAM 	: Resultant_String:=Resultant_String+',GRPNAM';> 	PRV$M_LOG_IO 	: Resultant_String:=Resultant_String+',LOG_IO';< 	PRV$M_MOUNT 	: Resultant_String:=Resultant_String+',MOUNT';> 	PRV$M_NETMBX 	: Resultant_String:=Resultant_String+',NETMBX';< 	PRV$M_NOACNT 	: Resultant_String:=Resultant_String+',ACNT';: 	PRV$M_OPER 	: Resultant_String:=Resultant_String+',OPER';> 	PRV$M_PFNMAP 	: Resultant_String:=Resultant_String+',PFNMAP';> 	PRV$M_PHY_IO 	: Resultant_String:=Resultant_String+',PHY_IO';> 	PRV$M_PRMCEB 	: Resultant_String:=Resultant_String+',PRMCEB';> 	PRV$M_PRMGBL 	: Resultant_String:=Resultant_String+',PRMGBL';> 	PRV$M_PRMMBX 	: Resultant_String:=Resultant_String+',PRMMBX';> 	PRV$M_PSWAPM 	: Resultant_String:=Resultant_String+',PSWAPM';> 	PRV$M_SETPRI 	: Resultant_String:=Resultant_String+',ALTPRI';> 	PRV$M_SETPRV 	: Resultant_String:=Resultant_String+',SETPRV';> 	PRV$M_SYSGBL 	: Resultant_String:=Resultant_String+',SYSGBL';> 	PRV$M_SYSNAM 	: Resultant_String:=Resultant_String+',SYSNAM';> 	PRV$M_SYSLCK 	: Resultant_String:=Resultant_String+',SYSLCK';> 	PRV$M_SYSPRV 	: Resultant_String:=Resultant_String+',SYSPRV';> 	PRV$M_TMPMBX 	: Resultant_String:=Resultant_String+',TMPMBX';> 	PRV$M_VOLPRO 	: Resultant_String:=Resultant_String+',VOLPRO';< 	PRV$M_WORLD 	: Resultant_String:=Resultant_String+',WORLD';< 	PRV$M_SHMEM 	: Resultant_String:=Resultant_String+',SHMEM';	       End    End;F   IF UAND(PRV$M_SHARE,Resultant_Value) = PRV$M_SHARE 	(* Patch per  *)G      Then Resultant_String:=Resultant_String+',SHARE';	(* SHARE      *) !   IF Length(Resultant_String) > 0 4      Then Resultant_String:=SUBSTR(Resultant_string,%                                    2, ?                                    length(Resultant_String)-1);  End;    1 PROCEDURE Recognize_uic (VAR Bit_string: String);    VAR    K,Tot : integer;   J :string;   BEGINi	   Tot:=0;s   FOR K:=0 to 15 DOs	     BEGINm#       J:=Substr(Bit_String,16-K,1);d       IF J = '1'          Then Tot:=Tot+(2**K);     End;   Bit_String:=Oct(Tot);     Unzero(Bit_String,Bit_String); End;    ; PROCEDURE Recognize_Primedays (VAR gruppo : PRIMEDAYS$TYPE; 4                                VAR uscita : String); BEGINN
   Uscita:=''; ;   IF NOT Gruppo.UAI$V_MONDAY    THEN Uscita:=Uscita+',Mon';t;   IF NOT Gruppo.UAI$V_TUESDAY   THEN Uscita:=Uscita+',Tue'; ;   IF NOT Gruppo.UAI$V_WEDNESDAY THEN Uscita:=Uscita+',Wed'; ;   IF NOT Gruppo.UAI$V_THURSDAY  THEN Uscita:=Uscita+',Thu'; ;   IF NOT Gruppo.UAI$V_FRIDAY    THEN Uscita:=Uscita+',Fri'; ;   IF NOT Gruppo.UAI$V_SATURDAY  THEN Uscita:=Uscita+',Sat'; ;   IF NOT Gruppo.UAI$V_SUNDAY    THEN Uscita:=Uscita+',Sun';C   IF Length(Uscita) > 0        Then Uscita:=SUBSTR(Uscita,%                                    2, 5                                    length(Uscita)-1);  END;    3 PROCEDURE Recognize_Flags (VAR gruppo : FLAGS$TYPE; 0                            VAR uscita : String); BEGIN 
   Uscita:=''; E   IF Gruppo.UAI$V_DISCTLY             Then Uscita:=Uscita+',Disctly'; D   IF Gruppo.UAI$V_DEFCLI              Then Uscita:=Uscita+',Defcli';E   IF Gruppo.UAI$V_LOCKPWD             Then Uscita:=Uscita+',Lockpwd'; H   IF Gruppo.UAI$V_RESTRICTED          Then Uscita:=Uscita+',Restricted';E   IF Gruppo.UAI$V_DISACNT             Then Uscita:=Uscita+',Disuser';TH   IF Gruppo.UAI$V_DISWELCOM           Then Uscita:=Uscita+',Diswelcome';I   IF Gruppo.UAI$V_DISMAIL             Then Uscita:=Uscita+',Disnewmail';  E   IF Gruppo.UAI$V_NOMAIL              Then Uscita:=Uscita+',Dismail'; D   IF Gruppo.UAI$V_GENPWD              Then Uscita:=Uscita+',Genpwd';I   IF Gruppo.UAI$V_PWD_EXPIRED         Then Uscita:=Uscita+',Pwd_Expired';IJ   IF Gruppo.UAI$V_PWD2_EXPIRED        Then Uscita:=Uscita+',Pwd2_Expired';G   IF Gruppo.UAI$V_DISPWDDIC           Then Uscita:=Uscita+',DisPwdDic';WG   IF Gruppo.UAI$V_DISPWDHIS           Then Uscita:=Uscita+',DisPwdHis';sC   IF Gruppo.UAI$V_AUDIT               Then Uscita:=Uscita+',Audit'; G   IF Gruppo.UAI$V_DISREPORT           Then Uscita:=Uscita+',Disreport'; J   IF Gruppo.UAI$V_DISRECONNECT        Then Uscita:=Uscita+',Disreconnect';G   IF Gruppo.UAI$V_AUTOLOGIN           Then Uscita:=Uscita+',Autologin'; Q   IF Gruppo.UAI$V_DISFORCE_PWD_CHANGE Then Uscita:=Uscita+',Disforce_Pwd_Change'; E   IF Gruppo.UAI$V_CAPTIVE             Then Uscita:=Uscita+',Captive'; F   IF Gruppo.UAI$V_DISIMAGE            Then Uscita:=Uscita+',Disimage';     IF Length(Uscita) > 0*       Then Uscita:=SUBSTR(Uscita,%                                    2, 5                                    length(Uscita)-1);  END;      2 PROCEDURE Invert_Transform (VAR stringa : String);   VAR ,   Indice, Nuovo_indice, Lunghezza : Integer;   Internal_String : String;    BEGINT.   Internal_String:='                        ';   Lunghezza:=Stringa.Length;   For Indice:=1 to Lunghezza DO 	     Begin )       Nuovo_Indice:=Lunghezza-(Indice-1);        If Stringa[Indice] = '1'0          Then Internal_String[Nuovo_indice]:='-'0          Else Internal_String[Nuovo_indice]:='#'     End;   Stringa:=Internal_String   END;       Begin     Prepare_routine:=0;    Buff_len:=0;     Us:=Usrnam;    Field:=Item;,    It:=0;             7    (*************  Descrizione dei campi: *************   % 	PRIMO:   Field della system service   	SECONDO: 1: restituisce STRING '                  2: restituisce INTEGER .                  3: restituisce Word_in_lengthB                  4: restituisce String con un byte contenente SIZE 		 5: restituisce un BYTE > 		 6: restituisce Quadword_in_Length (la tratto come Unsigned)<  		    ma Resultant_String va trattata per contenere la data> 		 7: restituisce Quadword_in_length (la tratto come Unsigned)? 		    ma Resultant_String va trattata per contenere i privilegiiM                  8: restituisce longword, ma Resultant string va trattata perc!                     contenere UIC K                  9: restituisce tre bytes; va trattata per contenere la ma- C                     schera binaria di accesso nelle varie modalita` L                 10: restituisce quadword_in_length; destinana a contenere la;                     password "crypted" (nessun trattamento) N                 11: restituisce un record, ma Resultant string va trattata per'                     contenere PrimedaysEJ                 12: restituisce un record, ma Resultant String va trattata'                     per contenere Flagsi8    ****************************************************)    D    If Field = 'ACCOUNT'          Then Set_Prepare(UAI$_Account,1,0);B    If Field = 'ASTLM'            Then Set_Prepare(UAI$_Astlm,3,2);B    If Field = 'BIOLM'            Then Set_Prepare(UAI$_Biolm,3,2);B    If Field = 'BYTLM'            Then Set_Prepare(UAI$_Bytlm,2,4);G    If Field = 'CLITABLES'        Then Set_Prepare(UAI$_Clitables,4,32); C    If Field = 'CPUTIM'           Then Set_Prepare(UAI$_Cputim,2,4); D    If Field = 'DEFCLI'           Then Set_Prepare(UAI$_Defcli,4,32);D    If Field = 'DEFDEV'           Then Set_Prepare(UAI$_Defdev,4,32);D    If Field = 'DEFDIR'           Then Set_Prepare(UAI$_Defdir,4,64);D    If Field = 'DFWSCNT'          Then Set_Prepare(UAI$_Dfwscnt,2,4);B    If Field = 'DIOLM'            Then Set_Prepare(UAI$_Diolm,2,3);D    If Field = 'ENCRYPT'          Then Set_Prepare(UAI$_Encrypt,3,1);E    If Field = 'ENCRYPT2'         Then Set_Prepare(UAI$_Encrypt2,3,1); B    If Field = 'ENQLM  '          Then Set_Prepare(UAI$_Enqlm,3,2);B    If Field = 'FILLM'            Then Set_Prepare(UAI$_Fillm,3,2);C    If Field = 'FLAGS'            Then Set_Prepare(UAI$_Flags,12,4);=D    If Field = 'JTQUOTA'          Then Set_Prepare(UAI$_Jtquota,2,6);D    If Field = 'LGICMD'           Then Set_Prepare(UAI$_Lgicmd,4,64);E    If Field = 'LOGFAILS'         Then Set_Prepare(UAI$_Logfails,3,2); H    If Field = 'MAXACCTJOBS'      Then Set_Prepare(UAI$_Maxacctjobs,3,2);F    If Field = 'MAXDETACH'        Then Set_Prepare(UAI$_Maxdetach,3,2);D    If Field = 'MAXJOBS'          Then Set_Prepare(UAI$_Maxjobs,3,2);C    If Field = 'OWNER'            Then Set_Prepare(UAI$_Owner,4,32); C    If Field = 'PBYTLM'           Then Set_Prepare(UAI$_Pbytlm,2,4); F    If Field = 'PGFLQUOTA'        Then Set_Prepare(UAI$_Pgflquota,2,4);C    If Field = 'PRCCNT'           Then Set_Prepare(UAI$_Prccnt,2,4); @    If Field = 'PRI'              Then Set_Prepare(UAI$_Pri,5,1);G    If Field = 'PRIMEDAYS'        Then Set_Prepare(UAI$_Primedays,11,4);iA    If Field = 'PWD'              Then Set_Prepare(UAI$_Pwd,10,8);tB    If Field = 'PWD2'             Then Set_Prepare(UAI$_Pwd2,10,8);G    If Field = 'PWD_LENGTH'       Then Set_Prepare(UAI$_Pwd_length,5,1); C    If Field = 'QUEPRI'           Then Set_Prepare(UAI$_Quepri,5,1); A    If Field = 'SALT'             Then Set_Prepare(UAI$_Salt,5,1); E    If Field = 'SHRFILLM'         Then Set_Prepare(UAI$_Shrfillm,3,2); B    If Field = 'TQCNT'            Then Set_Prepare(UAI$_Tqcnt,3,2);F    If Field = 'USERNAME'         Then Set_Prepare(UAI$_Username,1,12);E    If Field = 'WSEXTENT'         Then Set_Prepare(UAI$_Wsextent,2,8); D    If Field = 'WSQUOTA'          Then Set_Prepare(UAI$_Wsquota,2,8);A    If Field = 'PRIV'             Then Set_Prepare(UAI$_Priv,7,8);tE    If Field = 'DEF_PRIV'         Then Set_Prepare(UAI$_Def_priv,7,8);cG    If Field = 'EXPIRATION'       Then Set_Prepare(UAI$_Expiration,6,8);rH    If Field = 'LASTLOGIN_I'      Then Set_Prepare(Uai$_Lastlogin_i,6,8);H    If Field = 'LASTLOGIN_N'      Then Set_Prepare(Uai$_Lastlogin_n,6,8);E    If Field = 'PWD_DATE'         Then Set_Prepare(Uai$_Pwd_Date,6,8);LI    If Field = 'PWD_LIFETIME'     Then Set_Prepare(Uai$_Pwd_Lifetime,6,8);NF    If Field = 'PWD2_DATE'        Then Set_Prepare(Uai$_Pwd2_Date,6,8);@    If Field = 'UIC'              Then Set_Prepare(Uai$_Uic,8,4);K    If Field = 'BATCH_ACCESS_P'   Then Set_Prepare(Uai$_Batch_Access_P,9,3); K    If Field = 'BATCH_ACCESS_S'   Then Set_Prepare(Uai$_Batch_Access_S,9,3); L    If Field = 'DIALUP_ACCESS_P'  Then Set_Prepare(Uai$_Dialup_Access_P,9,3);L    If Field = 'DIALUP_ACCESS_S'  Then Set_Prepare(Uai$_Dialup_Access_S,9,3);K    If Field = 'LOCAL_ACCESS_P'   Then Set_Prepare(Uai$_Local_Access_P,9,3); K    If Field = 'LOCAL_ACCESS_S'   Then Set_Prepare(Uai$_Local_Access_S,9,3);-M    If Field = 'NETWORK_ACCESS_P' Then Set_Prepare(Uai$_Network_Access_P,9,3); M    If Field = 'NETWORK_ACCESS_S' Then Set_Prepare(Uai$_Network_Access_S,9,3); L    If Field = 'REMOTE_ACCESS_P'  Then Set_Prepare(Uai$_Remote_Access_P,9,3);L    If Field = 'REMOTE_ACCESS_S'  Then Set_Prepare(Uai$_Remote_Access_S,9,3);      If It <> 0        Then Begin&              Item_list.End_of_list:=0;$              CASE Prepare_routine OF'                  1,4: With Item_list Do                          BeginW<                           Buffer_length := Size(S_out.Body);.                           Item_code     := It;@                           Buffer_address:= Iaddress(S_out.Body);B                           Return_length := Iaddress(S_out.Length);                         End;'                   2 : With Item_list Do:                         BeginN4                           Buffer_length := Buff_len;.                           Item_code     := It;;                           Buffer_address:= Iaddress(I_out); 9                           Return_length := Iaddress(Lun);                          End;'                   3 : With Item_list Doc                         Begin 4                           Buffer_length := Buff_len;.                           Item_code     := It;;                           Buffer_address:= Iaddress(W_out); 9                           Return_length := Iaddress(Lun);                          End;  '                   5 : with Item_list DoO                         Begin_4                           Buffer_length := Buff_len;.                           Item_code     := It;;                           Buffer_address:= Iaddress(B_out);c9                           Return_length := Iaddress(Lun);                          End;  )                 6,7,10: with Item_list Do                          BeginC4                           Buffer_Length := Buff_len;.                           Item_Code     := It;;                           Buffer_Address:= Iaddress(Q_out);_8                           Return_Length := Iaddress(lun)                         End;  )                     8 : With Item_List Doo                         Begin 4                           Buffer_Length := Buff_len;.                           Item_Code     := It;>                           Buffer_Address:= Iaddress(Uic_long);8                           Return_Length := Iaddress(lun)                         End;  )                   9   : With Item_List Dor                         Begin 4                           Buffer_Length := Buff_len;.                           Item_Code     := It;?                           Buffer_Address:= Iaddress(Tri_Bytes); 8                           Return_Length := Iaddress(lun)                         End;)                    11 : With Item_List Do                           Begin4                           Buffer_Length := Buff_len;.                           Item_Code     := It;<                           Buffer_Address:= Iaddress(Giorni);8                           Return_Length := Iaddress(lun)                         End;)                    12 : With Item_List Dor                          Begin4                           Buffer_Length := Buff_len;.                           Item_Code     := It;;                           Buffer_Address:= Iaddress(Flags); 8                           Return_Length := Iaddress(lun)                         End;              End;   2              Status := $GETUAI(,,us,Item_list,,,);              If Odd (Status)                 Then Begin'                        Get_uai:=Status; .                        CASE Prepare_routine OFG                        1: Begin                             (*stringa*) 1                               Resultant_value:=0; G                               Garbage:=STR$TRIM(Resultant_string,S_out)e                           End;G                        2: Begin                             (*integer*) 5                               Resultant_value:=I_out; 3                               Writev(Garb_s,I_out); <                               Unpad(Garb_s,Resultant_string)                           End;N                        3: Begin                             (*word in length*)5                               Resultant_value:=W_out;d3                               Writev(Garb_s,W_out); X                               IF (field = 'MAXDETACH') AND       (* patch 14/11/89 FB *):                                  (resultant_value = 65535)7                                  Then Garb_s := 'NONE'; <                               Unpad(Garb_s,Resultant_string)                           End;N                        4: Begin                             (* string - [1] *)1                               Resultant_value:=0;iA                               Garbage:=STR$TRIM(Resultant_string,RI                                        SUBSTR(S_out,2,(Length(S_out)-2)))                            End;G                        5: Begin                              (* byte *) 5                               Resultant_value:=B_out;n3                               Writev(Garb_s,B_out);,<                               Unpad(Garb_s,Resultant_string)                           End;                        6: BeginO:                               Resultant_Value:=Int(Q_out);5                               If Resultant_Value <> 0 k                                  Then Filler_Status:=LIB$SYS_ASCTIM(Filler_Length,Resultant_String,Q_Out,0),@                                  Else Resultant_String:='(None)'                           End;                     7,10: Begin::                               Resultant_Value:=Int(Q_out);3                               Writev(Garb_s,Q_out);P5                               CASE Prepare_Routine OFXO                                  7: Recognize_Privilege;            (* privs *)CO                                 10: Writev(Resultant_String,Q_out); (* pwd   *)S!                              End;;                             End;                         8: Begin =                               Resultant_Value:=Int(Uic_long);PD                               bin_msk_g:=substr(bin(uic_long),2,16);E                               bin_msk_m:=substr(bin(uic_long),18,16); 7                               recognize_uic(bin_msk_g);B7                               recognize_uic(bin_msk_m);MO                               Resultant_String:='['+Bin_msk_g+','+Bin_msk_m+']'S                           End;                        9: Beginn>                               Resultant_Value:=Int(Tri_Bytes);5                               Garb_s:=Bin(Tri_Bytes);a3                               Unpad(Garb_s,Garb_s); 7                               Invert_Transform(Garb_s);P6                               Resultant_String:=Garb_s                           End;                       11: BeginP1                               Resultant_Value:=0;,J                               Recognize_primedays(Giorni,Resultant_String)                           End;                       12: BeginV1                               Resultant_Value:=0;YE                               Recognize_flags(Flags,Resultant_String)                            End;                      End                    End               Else Begin)                     Resultant_value := 0;aW                     Resultant_string := '%GET_UAI-E-ERRSS, error from System Service.';g%                     Get_uai := Statust                    End            End       Else Begin!             Resultant_value := 0;=L             Resultant_string := '%GET_UAI-F-UNSUPPORTED, unsupported item.';%             Get_uai:=SS$_Unsupported;(            End   End; End.  