$! _finish_unpacking.com
$ v = 'f$verify(0)'
$!
$! Clean up some details that get lost when using tar file containers.
$! First make *.EXE have fixed-length, 512-byte record format;
$! next make directories which grant read also grant execute access;
$! then fix the decw$include and X11 synonym for header subdirectories;
$! last extract VMS-specific header files from text library container.
$!
$ com_fil = f$environment("PROCEDURE")
$ old_def = f$environment("DEFAULT")
$ set default 'f$string(f$parse("_.;",com_fil) - "_.;")'
$!
$ echo	= "write sys$output"
$ vers := 'f$getsyi("VERSION")'
$ vms_v61 = f$int(f$extract(1,1,vers)).gt.6 -
     .or. f$int(f$extract(1,1,vers)).eq.6 .and. f$int(f$extract(3,1,vers)).ge.1
$!
$ echo "_finish_unpacking phase 1"
$ call fix_format [...]*.EXE;0
$ call fix_format [...]*.%LB;0
$ echo "_finish_unpacking phase 2"
$ call fix_parent
$ call fix_dirpro [...]*.DIR;1
$ if f$search("[.gcc.include.x11]x11--decw$include.com").eqs.""
$ then	echo " forced to skip phase 3"
$ else	echo "_finish_unpacking phase 3"
$	@[.gcc.include.x11]x11--decw$include.com
$ endif
$ if  f$search("[.gcc.include.vms]vms-headers.com").eqs."" -
 .or. f$search("[.gcc.include.vms]vms-headers.tlb").eqs."" -
 .or. f$search("[.gcc.include.vms]vms-headers.list").eqs.""
$ then	echo " forced to skip phase 4"
$ else	echo "_finish_unpacking phase 4  (this will take quite a while...)"
$	@[.gcc.include.vms]vms-headers.com
$ endif
$ echo "_finish_unpacking finished!"
$ set default 'old_def'
$ exit	1 + 0*f$verify(v)
$
$!!!
$! Make sure a specified file has attributes rfm=fix=512, rat=none.
$!
$fix_format: subroutine
$ wildcard = f$locate("*",p1) .ne. f$locate("%",p1) -
	.or. f$locate("...",p1) .lt. f$length(p1)
$ prev_f = ""
$ffloop:
$  f = f$search(p1)
$  if f.eqs."" then  goto ffdone
$  vers = f$parse(f,,,"VERSION")
$  f = f$edit(f - vers,"LOWERCASE")
$  if f.eqs.prev_f then  goto ffloop	!found new version of previous file
$  echo " Checking ''f'  "
$  if  f$file_attr(f,"RFM").eqs."FIX" -
 .and. f$file_attr(f,"MRS").eqs."512" -
 .and. f$file_attr(f,"RAT").eqs.""
$  then echo "   ok"
$  else echo "   Fixing ''f'  "
$	call new_protection "''f'" "" "__fixup_newpro"
$	set file/Protection=(S:rwed,O:rwed) 'f''vers' !make sure it's modifiable
$	if vms_v61
$	then set file/Attribute=(RFM=Fix,LRL=512,MRS=512,RAT=None) 'f''vers'
$	else exchange copy -
		'f''vers' /Transfer_Mode=Block /Record_Format=Fixed=512 -
		fix512.tmp /Carriage_Control=None /Best_Try_Contiguous
$	     copy/Replace fix512.tmp 'f''vers'
$	     delete/noConfirm/noLog fix512.tmp;*
$	endif
$	set file/Protection=('__fixup_newpro') 'f''vers'
$	delete/Symbol/Global __fixup_newpro
$  endif
$  prev_f = f
$ if wildcard then  goto ffloop
$ffdone:
$ endsubroutine !fix_format
$!!!
$
$!!!
$! Set execute access for directory protection that grants read access.
$!
$fix_dirpro: subroutine
$ wildcard = f$locate("*",p1) .ne. f$locate("%",p1) -
	.or. f$locate("...",p1) .lt. f$length(p1)
$fdloop:
$  f = f$search(p1)
$  if f.eqs."" then  goto fddone
$  call new_protection "''f'" "__fixup_oldpro" "__fixup_newpro"
$  if __fixup_newpro.nes.__fixup_oldpro then -
	set file/Protection=('__fixup_newpro') 'f'
$  delete/Symbol/Global __fixup_oldpro
$  delete/Symbol/Global __fixup_newpro
$ if wildcard then  goto fdloop
$fddone:
$ endsubroutine !fix_dirpro
$!!!
$
$!!!
$! Figure out filename of current directory and pass it to fixup_dirpro.
$!
$fix_parent: subroutine
$ f = f$environment("DEFAULT")
$ d = f$parse(f,,,"DIRECTORY","SYNTAX_ONLY")
$! fold in root if present
$ if f$extract(1,7,d).eqs."000000." then  d = d - "000000."
$ l = f$length(d)
$ if l.gt.8 .and. f$extract(l-8,7,d).eqs.".000000" then -
	d = f$extract(0,l-8) + f$extract(l-1,1,d)
$ d = d - "][" - "><" - "]<" - ">["
$! now check for subdirectory
$ l = f$length(d)
$ p = f$locate(".",d)	!find first dot
$ if p.lt.l
$ then
$   t = p
$fp_loop:
$     p = t + 1		!past dot
$     t = p + f$locate(".",f$extract(p,l-p,d))	!find next dot
$   if t.lt.l then  goto fp_loop
$! reached final dot
$   f = f$extract(p,l-p-1,d)
$   d = f$extract(0,p-1,d) + f$extract(1.and.(f$extract(0,1,d).eqs."<"),1,"]>")
$ else
$! top level directory
$   f = f$extract(1,l-2,d)
$   d = "[000000]"
$ endif
$!
$! now do the actual fixup
$ call fix_dirpro 'd''f'.DIR;1
$ endsubroutine !fix_parent
$!!!
$
$!!!
$! Create two symbols holding protection strings for a file.
$!
$new_protection: subroutine
$ oldpro = f$edit(f$file_attr(p1,"PRO"),"COLLAPSE") -
		- "YSTEM" - "WNER" - "ROUP" - "ORLD"	!keep "S"+"O"+"G"+"W"
$ tmp = f$parse(p1,,,"TYPE","SYNTAX_ONLY")
$ if tmp.nes.".DIR" .and. tmp.nes.".EXE"
$ then	newpro = oldpro		!no change made
$ else	newpro = ""		!build it piece by piece
$	i = 0
$np_loop:	!add execute access to any category that allows read access
$	  tmp = f$element(i,",",oldpro)
$	  if tmp.eqs."," then  goto np_done
$	  j = f$locate("=",tmp)
$	  k = f$length(tmp) - j
$	  if f$locate("R",f$extract(j,k,tmp)).lt.k -
       .and. f$locate("E",f$extract(j,k,tmp)).eq.k then  tmp = tmp + "E"
$	  newpro = newpro + "," + tmp
$	  i = i + 1
$	goto np_loop
$np_done:
$	newpro = newpro - ","	!strip leading comma
$ endif
$ if p2.nes."" then  'p2' == oldpro
$ if p3.nes."" then  'p3' == newpro
$ endsubroutine !new_protection
$!!!
