$! bison_startup.com
$ v = 'f$verify(0)'
$!
$!	This command file sets up the necessary logical name for Bison.
$!	It performs the same function as the older install_bison.com,
$!	but is more appropriately named and tries to be more robust.
$!
$!	This procedure assumes that it is in the same directory as
$!	bison.exe, bison.cld, bison.simple, and bison.hairy.
$!	It defines GNU_BISON such that they can all be accessed as
$!	gnu_bison:[000000]bison.exe, gnu_bison:[000000]bison.cld, etc.
$!
$ gosub make_path
$!
$! Select which logical name table will hold the definition.
$! [Bug: this ought to come from our command line.]
$ table = "/Job"
$ if f$priv("GRPNAM").or.f$priv("GRPPRV") then	table = "/Group"
$ if f$priv("SYSNAM").or.f$priv("SYSPRV") then	table = "/System"
$!
$! Define GNU_BISON, then we're done.
$!
$ on error then continue
$ define 'table' /Translation=(Concealed) GNU_BISON 'path'
$ exit ($status .or. %x10000000) + 0*f$verify(v)
$
$
$!
$make_path:
$!	Construct a rooted path for our directory.
$!
$! Start with the full file specification for this procedure.
$ path = f$environment("PROCEDURE")
$ pdev = f$parse(path,,,"DEVICE","NO_CONCEAL")
$ pdev = f$parse(f$getdvi(pdev,"LOGVOLNAM"),pdev,,"DEVICE","SYNTAX_ONLY")
$ pdir = f$parse(path,,,"DIRECTORY","NO_CONCEAL")
$ root = ""
$! Split pdir into root, if present, and directory.
$ dlen = f$length(pdir)
$ path = f$locate(".]",pdir)
$ if path.lt.dlen
$ then
$   root = f$extract(0,path+2,pdir)
$   pdir = f$extract(path+2,255,pdir)
$ else
$   path = f$locate(".>",pdir)
$   if path.lt.dlen then  root = f$extract(0,path+2,pdir)
$   if path.lt.dlen then  pdir = f$extract(path+2,255,pdir)
$ endif
$! An explicit reference to the MFD is redundant.
$ if f$extract(1,7,pdir).eqs."000000." then  pdir = pdir - "000000."
$ dlen = f$length(pdir)
$ rlen = f$length(root)
$ brkt = f$extract(dlen-1,1,pdir)	!closing bracket, "]" or ">"
$!
$! Possibly fixup rooted directory specification.
$ if rlen.eq.0
$ then
$!   not already rooted; easy to deal with
$   root = f$extract(0,dlen-1,pdir) + "." + brkt
$ else
$!   first force root to use same punctuation as regular directory
$   root = f$extract(0,1,pdir) + f$extract(1,rlen-2,root) + brkt
$!   now merge root and directory into new root
$   if pdir.nes."[000000]" .and. pdir.nes."<000000>" then -
      root = f$extract(0,rlen-1,root) + f$extract(1,dlen-2,pdir) + "." + brkt
$ endif
$!
$! Join device and directory into path.
$ path = pdev + root
$ return	!from make_path
