$! build_gcc.com -- short DCL procedure to build gcc.exe (VMS compiler driver).
$!
$!	Operations performed:
$! creates gcc_cmd.cld from gcc.cld, then compiles it into gcc_cmd.obj;
$! compiles gcc.c into gcc.obj, then links it with gcc_cmd to make gcc.exe;
$! creates gcc.hlp from gcc.rnh; note: use LIBRARY/HELP manually to install it.
$!	Options:
$! an argument of "CLD" or "CMD" causes just the 1st step to be performed;
$! an argument of "HLP" or "DOC" causes just the 3rd step to be performed.
$
$! Select the compiler used to build gcc.exe
$  compiler = "VAXC"
$!  compiler = "DECC"
$!  compiler = "GCC"
$
$! Linker options
$  link_flags = "/noTraceback"
$
$  say = "write sys$output"
$  On Error Then Goto err_exit
$  On Control_Y Then Goto err_exit
$  If p1.eqs."HELP" .or. p1.eqs."HLP" .or. p1.eqs."DOC" Then Goto do_help
$!
$  Open/Read cld_in gcc.cld
$  Copy sys$input: gcc_cmd.cld
! gcc_cmd.cld -- this is a copy of gcc.cld which has been revised to
! eliminate the "image" directive.  It is generated by build_gcc.com
! and ends up getting compiled with `set command/object' and then
! linked into gcc.exe.  It should not be modified manually.
module gcc_cmd
$  Open/Append cld_out gcc_cmd.cld
$  say "creating gcc_cmd.cld from gcc.cld"
$cld_loop:
$  Read/End=cld_done cld_in inline
$  canonline = f$edit(inline,"Trim,Upcase,Uncomment")
$  If canonline.eqs."" Then Goto cld_loop
$  If f$locate("IMAGE",canonline).ne.0
$  Then	Write cld_out inline
$	Goto cld_loop
$  EndIf
$! "image" found and now discarded; retain rest of input as-is
$  Copy cld_in: cld_out:
$cld_done:
$  Close cld_out
$  Close cld_in
$  say "compiling gcc_cmd.cld into gcc_cmd.obj"
$  Set Command/Object=gcc_cmd.obj gcc_cmd.cld
$  If p1.eqs."CLD" .or. p1.eqs."CMD" Then Exit
$!
$! make a linker options file for version identification
$  create gcc-vms.opt
$  search gcc.c "#define","GCC_DRIVER_VERSION" /Exact/Match=AND/Output=ident.tmp
$  open/Read/Error=skip_ident id_in ident.tmp
$  read/End=skip_ident id_in ident_line
$  open/Append id_out gcc-vms.opt
$  ident_line = "gcc-vms " + f$element(1,"""",ident_line)
$  write id_out "identification=""",ident_line,""""
$skip_ident:
$  close/noLog id_in
$  close/noLog id_out
$  delete/noConfirm ident.tmp;*
$!
$! do the main compilation
$  cc_mod = ""
$  cc_def = f$trnlnm("DECC$CC_DEFAULT") - "/"
$  Goto &compiler
$
$vaxc:
$  if cc_def.nes."" .and. cc_def.nes."VAXC" then cc_mod = "/VAXC"
$  say "compiling gcc.c with VAX C"
$  CC'cc_mod'/Obj=gcc.obj gcc.c
$  say "linking gcc.exe"
$  Link/Exe=gcc.exe gcc.obj,gcc_cmd.obj,gcc-vms.opt/Options,-
	sys$input:/Options 'link_flags'
sys$share:vaxcrtl.exe/Shareable
$  Goto do_help
$
$decc:
$  if cc_def.nes."" .and. cc_def.nes."DECC" then cc_mod = "/DECC"
$  say "compiling gcc.c with DEC C"
$  CC'cc_mod'/Standard=VAXC/Obj=gcc.obj gcc.c
$  say "linking gcc.exe"
$  Link/Exe=gcc.exe gcc.obj,gcc_cmd.obj,gcc-vms.opt/Options 'link_flags'
$  Goto do_help
$
$gcc:
$gnuc:
$  say "compiling gcc.c with GNU C"
$  GCC /noVerbose/Debug/Obj=gcc.obj gcc.c
$  say "linking gcc.exe"
$  Link/Exe=gcc.exe gcc.obj,gcc_cmd.obj,gcc-vms.opt/Options,-
	gnu_cc:[000000]gcclib.olb/Library,sys$library:vaxcrtl.olb/Library 'link_flags'
$  Goto do_help
$
$do_help:
$  say "creating gcc.hlp from gcc.rnh"
$  Runoff gcc.rnh /Output=gcc-hlp.tmp
$! crude hack to strip DSR's explicit <cr><lf> characters
$  Open/Read hlp_in gcc-hlp.tmp
$  Create gcc.hlp
! gcc.hlp -- online help entry for GCC, created from gcc.rnh by build_gcc.com
$  Open/Append hlp_out gcc.hlp
$  crlf = ".."
$  crlf[0,16] = %x0A0D
$hlp_loop:
$  Read/End=hlp_done hlp_in inline
$  l = f$length(inline)
$  If f$extract(l-2,2,inline).eqs.crlf Then inline = f$extract(0,l-2,inline)
$  Write hlp_out inline
$  Goto hlp_loop
$hlp_done:
$  Close hlp_out
$  Close hlp_in
$  Delete/noConfirm gcc-hlp.tmp;*
$  say "done."
$  Exit 1
$
$err_exit:
$  If f$trnlnm("cld_in" ,,,,,"Confine") Then Close/noLog cld_in
$  If f$trnlnm("cld_out",,,,,"Confine") Then Close/noLog cld_out
$  If f$trnlnm("id_in"	,,,,,"Confine") Then Close/noLog id_in
$  If f$trnlnm("id_out" ,,,,,"Confine") Then Close/noLog id_out
$  If f$trnlnm("hlp_in" ,,,,,"Confine") Then Close/noLog hlp_in
$  If f$trnlnm("hlp_out",,,,,"Confine") Then Close/noLog hlp_out
$!
$  Exit %x002C	!%SYSTEM-F-ABORT, abort
