/* <_assert.c>
 *
 *	Routine for gcclib to handle assert()'s i/o.
 */

#include <stdio.h>

/* __assert_gcc(expr_string,filename,line_number)
   Output a diagnostic message to stderr if possible;
   used in <assert.h>, prior to abort().
 */
void __assert_gcc( const char *expr, const char *name, int line )
{		/* note: VAXCRTL's stdio has extra level of indirection */
    register FILE *fp = stderr;
    if (!fp || !*fp)  fp = fdopen(2, "w");	/* open new channel if nec. */
    (void)fflush((FILE *)0);			/* flush all active streams */
    if (fp) {					/* output the message */
	(void)fprintf(fp, "\nAssertion %s failed; \n file \"%s\", line %d \n\n",
		      expr, name, line);
	if (fp != stderr)  (void)fclose(fp);	/* clean up if necessary */
    }
    return;
}
