/* <gcc_puts.c>
 */

/*
   Use alternate routine in place of VAXCRTL's puts().	That one has a
   bug:  when writing an empty string to a terminal, one garbage character
   will be output.  This behavior depends on the output device; disk files
   aren't affected.  fputs() has no such problem, so we use it instead.
 */
#define puts	gcc_puts
#include <stdio.h>

/*
 * puts -- write a string plus a newline to standard output.
 */
int puts ( const char *str )
{
    register int result = 0;

    if (*str)  result = fputs(str, stdout);
    if (result >= 0)  result = fputc('\n', stdout);

    return result;
}
