/* <strcmp.c>
 */
#include <string.h>

/*
 * strcmp -- compare two strings; return 0 if equal, negative if first
 *	    is less than second, positive otherwise.
 */
int strcmp ( const char *lft, const char *rgt )
{
    register const char *s1 = lft, *s2 = rgt;

    while (*s1++ == *s2)
	if (!*s2++)  return 0;

    return ((unsigned char)*--s1 < (unsigned char)*s2) ? -1 : 1;
}
