/* <strcspn.c>
 */
#include <string.h>

/*
 * strcspn -- count the longest prefix of 'str' of chars not contained in 'set'.
 */
size_t strcspn ( const char *str, const char *set )
{
    register const char *s1, *s2;
    register char c;
    register size_t len = 0;

    if (str) {
	for (s1 = str; (c = *s1) != '\0'; s1++) {
	    /* look for current char in 'set' */
	    for (s2 = set; *s2; s2++)
		if (*s2 == c)  break;
	    /* continue only if it didn't match */
	    if (!*s2)  len++;  else  break;
	}
    }
    return len;
}
