/* <strncat.c>
 */
#include <string.h>

/*
 * strncat -- append at most 'cnt' chars of 'src' to the end of 'dst'.
 */
char *strncat ( char *dst, const char *src, size_t cnt )
{
    register char *s1 = dst;
    register const char *s2 = src;
    register size_t n = cnt;

    while (*s1++)	/* first move to end of 'dst' */
	continue;
    --s1;
    /* note that strncat() always adds terminator, unlike strncpy() */
    if (n > 0)
	while ((*s1++ = *s2++) != '\0')
	    if (--n == 0) { *s1 = '\0'; break; }
    return dst;
}
