/* <strncmp.c>
 */
#include <string.h>

/*
 * strncmp -- compare two strings, examining at most 'cnt' characters.
 */
int strncmp ( const char *lft, const char *rgt, size_t cnt )
{
    register const char *s1 = lft, *s2 = rgt;
    register int n = (int)cnt;

    if (n > 0) {
	do {
	    if ((unsigned char)*s1 < (unsigned char)*s2)  return -1;
	    else if (!*s1)  return *s2 ? -1 : 0;
	    else if ((unsigned char)*s1++ > (unsigned char)*s2++)  return 1;
	} while (--n > 0);
    } else if (cnt) {
	register size_t n = cnt;
	/*
	   An outrageously large--but legal--count value has been
	   supplied,  so we can't use simple integers here.  That
	   forces use of post-decrement, which is slower.
	 */
	while (n-- > 0)
	    if ((unsigned char)*s1 < (unsigned char)*s2)  return -1;
	    else if (!*s1)  return *s2 ? -1 : 0;
	    else if ((unsigned char)*s1++ > (unsigned char)*s2++)  return 1;
    }
    return 0;	/* matched */
}
