/* <strncpy.h>
 */
#include <string.h>

/*
 * strncpy -- copy at most 'cnt' characters from 'src' to 'dst'.
 *	    If 'src' is shorter than 'cnt', fill the difference with NULs.
 */
char *strncpy ( char *dst, const char *src, size_t cnt )
{
    register char *s1;
    register const char *s2;
    register int n = (int)cnt;		/* not unsigned! */

    if (n > 0) {		/* normal case */
     /* assert( n == cnt ); */

	for (s1 = dst, s2 = src; *s2; )
	    if (--n >= 0)  *s1++ = *s2++;  else  break;

	while (--n >= 0)  *s1++ = '\0';

    } else if (cnt) {		/* do it the slow way */
	register size_t n = cnt;	/* this one is unsigned */

	for (s1 = dst, s2 = src; *s2; )
	    if (n-- > 0)  *s1++ = *s2++;  else	break;

	while (n-- > 0)  *s1++ = '\0';
    }

    return dst;
}
