/* <strspn.c>
 */
#include <string.h>

/*
 * strspn -- count the longest prefix of 'str' of chars contained in 'set'.
 */
size_t strspn ( const char *str, const char *set )
{
    register const char *s1, *s2;
    register size_t len = 0;

    if (str) {
	for (s1 = str; *s1; s1++) {
	    /* look for current char in 'set' */
	    for (s2 = set; *s2; s2++)
		 if (*s2 == *s1)  { len++; break; }
	    /* done if not-matched */
	    if (!*s2) break;
	}
    }
    return len;
}
