/* <strstr.c>
 */
#include <string.h>

/*
 * strstr -- search 'str' for occurance of 'sub'.
 */
char *strstr ( const char *str, const char *sub )
{
    register const char *s1, *s2;
    register int i, k;
#define TABSIZ 0x20	/* 0x40 would be case-sensitive, so possibly better */
    char tstr[TABSIZ], tsub[TABSIZ];	/* nibble count tables */
 /* assert( (TABSIZ & ~(TABSIZ-1)) == TABSIZ ); */

    /* special case: empty substring */
    if (!*sub)	return (char *)str;

    /* do some useful work while determining relative lengths */
    for (i = 0; i < TABSIZ; i++)  tstr[i] = tsub[i] = 0;	/* init */
    for (k = 0, s1 = str; *s1; k++)  tstr[*s1++ & (TABSIZ-1)]++;
    for (	s2 = sub; *s2; --k)  tsub[*s2++ & (TABSIZ-1)]++;

    /* evaulate the info we've collected */
    if (k < 0)	return (char *)0;   /* sub longer than str, so can't match */
    for (i = 0; i < TABSIZ; i++)	/* does sub have more 'x's than str? */
	if (tsub[i] > tstr[i])	return (char *)0;   /* match not possible */

    /* now actually compare the substring repeatedly to parts of the string */
    for (i = 0; i <= k; i++) {
	s1 = &str[i];
	s2 = sub;
	while (*s1++ == *s2++)
	    if (!*s2)  return (char *)&str[i];	/* full match */
    }
    return (char *)0;	/* not found */
}
