$! gcc_ivp.com
$!
$! This is a simple "installation validation procedure" for gcc.
$! Successful execution indicates that gcc has been installed
$! correctly.  It also contains an example of compiling, linking,
$! and executing a trivial C program.
$!
$	on error then goto bail
$	old_loc = f$environment("DEFAULT")
$	echo = "write sys$output"
$	abort = "exit %x1000002C"
$!
$ if f$trnlnm("GNU_CC").eqs.""
$ then  type sys$input:

  Logical name GNU_CC is not defined.  Either GCC_STARTUP.COM
  has not been executed or the installation of gcc has failed.

$       abort
$ endif
$!
$ echo "Changing default directory"
$	set default sys$scratch
$	show default
$!
$ echo "Creating gcc_ivp_main"
$! this file doesn't need any C preprocessing, so checks the compiler proper
$ create gcc_ivp_main.i
$DECK
extern int printf(const char *,...);
void show_args(int,char **);

int main( int argc, char *argv[] )
{
  if (argc > 1)
    show_args(argc - 1, &argv[1]);
  else
    printf("No arguments supplied.\n");

  return 0;
}
$EOD
$
$ echo "Creating gcc_ivp_func"
$! this file needs preprocessing, so checks the preprocessor and header files
$ create gcc_ivp_func.c
$DECK
#include <assert.h>
#include <stdio.h>

#include <stsdef.h> /* not needed here, but accesses the vms subdirectory */

void show_args( int ac, char *av[] )
{
  int	i;

  assert( ac > 0 ); /* linker will need __assert_gcc() from gcclib.olb */
  for (i = 0; i < ac; i++)
    fputs(av[i], stdout);
#ifdef FINAL_NEWLINE
  putchar('\n');
#endif
}
$EOD
$
$ echo "Compiling gcc_ivp_main"
$ gcc gcc_ivp_main.i /Obj=ivp_main.obj		!override .obj name
$!
$ echo "Compiling gcc_ivp_func"
$ gcc gcc_ivp_func.c /Def=("FINAL_NEWLINE=1")	!default .obj name
$!
$ echo "Linking gcc_ivp"
$ link /Exe=gcc_ivp.exe ivp_main.obj,gcc_ivp_func.obj,-
	gnu_cc:[000000]gcclib.olb/Libr,sys$library:vaxcrtl.olb/Libr
$!
$ echo "Executing gcc_ivp"
$!
$!	A symbol whose value begins with a dollar sign creates a
$!	"foreign command", which provides a way to invoke any .EXE
$!	file with arbitrary command line arguments, which can't be
$!	done with the RUN command.  `sys$disk:' designates the
$!	default device, and `[]' represents the default directory.
$!
$ gcc_ivp = "$sys$disk:[]gcc_ivp"
$!
$!	Command line arguments containing mixed or upper case letters
$!	or spaces (and certain other punctuation, such as exclamation
$!	point) need to be quoted, lower case letters and filename
$!	punctuation characters do not.	Excess whitespace is discarded.
$!
$ gcc_ivp "  Installation of gcc " successful		"!"
$!
$ status = 1
$ goto cleanup
$!
$bail:
$ status = $status
$ type sys$input:

    The installation validation procedure for gcc has failed.

$!
$cleanup:
$ on error then continue
$ delete = "delete /noConfirm/noLog/Since=-0:10:0"
$!
$ echo "Cleaning up IVP work files"
$ if f$search("gcc_ivp.exe").nes."" then  delete gcc_ivp.exe;*
$ if f$search("*ivp_*.obj") .nes."" then  delete *ivp_%%%%.obj;*
$ if f$search("gcc_ivp_*.%").nes."" then  delete gcc_ivp_%%%%.%;*
$!
$ echo "Restoring default directory"
$	set default 'old_loc'
$	show default
$!
$ echo "Done"
$ exit	'status' .or. %x10000000
