$! gcc_startup.com
$ v = 'f$verify(0)'
$!
$!	This command file sets up the necessary logical names for GCC.
$!	It performs the same function as the older gcc_install.com,
$!	a superset of the much older install_gcc.com.
$!
$!	This procedure assumes that it is in the same directory as
$!	gcc.exe, gcc.com, gcc-*.exe, and gcclib.olb.
$!	It defines GNU_CC such that they can all be accessed as
$!	gnu_cc:[000000]gcc.exe, gnu_cc:[000000]gcc.com, etc.
$!
$ gosub make_path
$ prfx = path - brkt
$!
$! Select which logical name table will hold the definition.
$! [Bug: this ought to come from our command line.]
$ table = "/Job"
$ if f$priv("GRPNAM").or.f$priv("GRPPRV") then	table = "/Group"
$ if f$priv("SYSNAM").or.f$priv("SYSPRV") then	table = "/System"
$!
$! Define GNU_CC, GNU_CC_INCLUDE, and possibly GNU_GXX_INCLUDE
$!	(GNU_CC_INCLUDE is a searchlist when using the newer header file set).
$ on error then goto bail
$ define 'table' /Translation=(Concealed) -
	GNU_CC			'path'
$ define 'table' /Translation=(Concealed) -
	GNU_CC_INCLUDE		'f$string(prfx + "include." + brkt)',-
				'f$string(prfx + "include.vms." + brkt)'
$ if f$parse("gnu_cc:[gxx_include]").nes."" then -
  define 'table' /Translation=(Concealed) -
	GNU_GXX_INCLUDE		'f$string(prfx + "gxx_include." + brkt)'
$!
$! Define GNU_CC_VERSION
$!	(need gcc's help to figure out the right value).
$ gosub find_version
$ define 'table' -
	GNU_CC_VERSION "''version'"
$!
$! Possibly define LIBGXX_SHR
$!	(makes it easier to have libg++ in the gnu_cc directory tree).
$ if f$search("gnu_cc:[000000]libgxx_shr.exe").nes."" then -
  define 'table'  LIBGXX_SHR	GNU_CC:[000000]LIBGXX_SHR
$!
$! Done.
$bail:
$ exit ($status .or. %x10000000) + 0*f$verify(v)
$
$
$!
$make_path:
$!	Construct a rooted path for our directory.
$!
$! Start with the full file specification for this procedure.
$ path = f$environment("PROCEDURE")
$ pdev = f$parse(path,,,"DEVICE","NO_CONCEAL")
$ pdev = f$parse(f$getdvi(pdev,"LOGVOLNAM"),pdev,,"DEVICE","SYNTAX_ONLY")
$ pdir = f$parse(path,,,"DIRECTORY","NO_CONCEAL")
$ root = ""
$! Split pdir into root, if present, and directory.
$ dlen = f$length(pdir)
$ path = f$locate(".]",pdir)
$ if path.lt.dlen
$ then
$   root = f$extract(0,path+2,pdir)
$   pdir = f$extract(path+2,255,pdir)
$ else
$   path = f$locate(".>",pdir)
$   if path.lt.dlen then  root = f$extract(0,path+2,pdir)
$   if path.lt.dlen then  pdir = f$extract(path+2,255,pdir)
$ endif
$! An explicit reference to the MFD is redundant.
$ if f$extract(1,7,pdir).eqs."000000." then  pdir = pdir - "000000."
$ dlen = f$length(pdir)
$ rlen = f$length(root)
$ brkt = f$extract(dlen-1,1,pdir)	!closing bracket, "]" or ">"
$!
$! Possibly fixup rooted directory specification.
$ if rlen.eq.0
$ then
$!   not already rooted; easy to deal with
$   root = f$extract(0,dlen-1,pdir) + "." + brkt
$ else
$!   first force root to use same punctuation as regular directory
$   root = f$extract(0,1,pdir) + f$extract(1,rlen-2,root) + brkt
$!   now merge root and directory into new root
$   if pdir.nes."[000000]" .and. pdir.nes."<000000>" then -
      root = f$extract(0,rlen-1,root) + f$extract(1,dlen-2,pdir) + "." + brkt
$ endif
$!
$! Join device and directory into path.
$ path = pdev + root
$ return	!from make_path
$
$
$!
$find_version:
$!	Query the preprocessor for gcc's version number.
$!
$ version = "unknown"
$ on error then goto version_found
$ ptmp = f$parse("gcc-" + f$getjpi("","PID") + ".tmp;","sys$scratch")
$! get version feedback into a scratch file
$ if f$trnlnm("VERS_TMP").nes."" then  close/noLog vers_tmp
$ open/Write vers_tmp 'ptmp'
$ define/User sys$output vers_tmp:
$ define/User sys$error  vers_tmp:
$ mcr gnu_cc:[000000]gcc-cpp.exe -version _NL: -o _NL:
$ close vers_tmp
$! load version feedback from scratch file into a symbol
$ vers_line = "version unknown"
$ open/Read vers_tmp 'ptmp'
$ read/End=vers_tmp vers_tmp vers_line
$vers_tmp: close vers_tmp
$ delete/noConfirm/noLog 'ptmp'*
$! extract version identification from the symbol
$ vers_line = f$edit(vers_line,"COMPRESS,TRIM") + " ()"
$ ptmp = f$locate("version ",f$edit(vers_line,"LOWERCASE"))
$ if ptmp.lt.f$length(vers_line) then -
	vers_line = f$extract(ptmp+8,255,vers_line)
$ version = f$extract(0,f$locate(" (",vers_line),vers_line)
$version_found:
$ on error then goto bail
$ return	!from find_version
