/* <assert.h>
 *
 *	Debugging assistance.  Use GCC/DEFINE="NDEBUG" to suppress assert()s.
 */
#define _ASSERT_H

#undef assert
#ifndef NDEBUG
# ifdef __cplusplus
extern "C" {
# endif

#ifndef abort
extern void abort(
# if defined(__STDC__) || defined(__cplusplus)
		  void
# endif
		      )
# if __GNUC_MINOR__ >= 5
			__attribute__((noreturn))
# endif
						 ;
#endif

#ifdef __STDC__
extern void __assert_gcc(const char *,const char *,int);
# define __assert0(_Ex,_Fl,_Ln) __assert_gcc(#_Ex,_Fl,_Ln)
#else	/*!__STDC__ => -traditional */
extern void __assert_gcc();
# define __assert0(_Ex,_Fl,_Ln) __assert_gcc("_Ex",_Fl,_Ln)
#endif	/*?__STDC__*/

# define assert(_X) ((_X)?(void)0:(__assert0(( _X ),__FILE__,__LINE__),abort()))

# ifdef __cplusplus
}
# endif
#else	/*NDEBUG*/

# define assert(_X) ((void)0)
#endif	/*NDEBUG*/
