/* <ctype.h>
 *
 *	VAXCRTL compatible character manipulation.
 */
#ifndef _CTYPE_H
#define _CTYPE_H
# ifdef __cplusplus
extern "C" {
# endif

extern __const char _ctype_[];
/*
 *	The following bit of ugliness is to ensure that the _ctype_[]
 *	initialization is brought in from the VAXCRTL library.
 */
extern int __ctype_init__ __asm("_$$PsectAttributes_GLOBALVALUE$$c$v_ctypedefs");
static __const void *__ctype_hack__[] = {_ctype_,&__ctype_init__,&__ctype_hack__};

/* internal macros */
#define _U	0001
#define _L	0002
#define _N	0004
#define _S	0010
#define _P	0020
#define _C	0040
#define _X	0100
#define _B	0200

int toupper(int), tolower(int);   /* these are in VAXCRTL & required by ANSI */
int _toupper(int), _tolower(int); /* these are in GCCLIB, but redefined below */

/*
 *	ctype macros:  Note we need to strip the character to 7-bit ASCII.
 *	The results are not accurate for 8-bit data, but are at least safe.
 */
#define isalpha(c)	(_ctype_[(c)&0177] & (_U|_L))
#define isupper(c)	(_ctype_[(c)&0177] & _U)
#define islower(c)	(_ctype_[(c)&0177] & _L)
#define isdigit(c)	(_ctype_[(c)&0177] & _N)
#define isxdigit(c)	(_ctype_[(c)&0177] & (_N|_X))
#define isspace(c)	(_ctype_[(c)&0177] & _S)
#define ispunct(c)	(_ctype_[(c)&0177] & _P)
#define isalnum(c)	(_ctype_[(c)&0177] & (_U|_L|_N))
#define isprint(c)	(_ctype_[(c)&0177] & (_P|_U|_L|_N|_B))
#define isgraph(c)	(_ctype_[(c)&0177] & (_P|_U|_L|_N))
#define iscntrl(c)	(_ctype_[(c)&0177] & _C)
#define isascii(c)	((unsigned char)(c) <= 0177)

#define toascii(c)	((c) & 0177)
#define _toupper(c)	((c) & ~040)
#define _tolower(c)	((c) |	040)
/* the above 2 macros only give reliable results when passed an ASCII letter */

# ifdef __cplusplus
}
# endif
#endif	/*_CTYPE_H*/
