/* <errno.h>
 *
 *	VAXCRTL error codes (+ codes we may use later)
 */
#ifndef _ERRNO_H
#define _ERRNO_H
# ifdef __cplusplus
extern "C" {
# endif

#define EPERM		1	/* Not owner */
#define ENOENT		2	/* No such file or directory */
#define ESRCH		3	/* No such process */
#define EINTR		4	/* Interrupted system call */
#define EIO		5	/* I/O error */
#define ENXIO		6	/* No such device or address */
#define E2BIG		7	/* Arg list too long */
#define ENOEXEC		8	/* Exec format error */
#define EBADF		9	/* Bad file number */
#define ECHILD		10	/* No children */
#define EAGAIN		11	/* No more processes */
#define ENOMEM		12	/* Not enough core */
#define EACCES		13	/* Permission denied */
#define EFAULT		14	/* Bad address */
#define ENOTBLK		15	/* Block device required */
#define EBUSY		16	/* Mount device busy */
#define EEXIST		17	/* File exists */
#define EXDEV		18	/* Cross-device link */
#define ENODEV		19	/* No such device */
#define ENOTDIR		20	/* Not a directory*/
#define EISDIR		21	/* Is a directory */
#define EINVAL		22	/* Invalid argument */
#define ENFILE		23	/* File table overflow */
#define EMFILE		24	/* Too many open files */
#define ENOTTY		25	/* Not a typewriter */
#define ETXTBSY		26	/* Text file busy */
#define EFBIG		27	/* File too large */
#define ENOSPC		28	/* No space left on device */
#define ESPIPE		29	/* Illegal seek */
#define EROFS		30	/* Read-only file system */
#define EMLINK		31	/* Too many links */
#define EPIPE		32	/* Broken pipe */

/* math software; per ANSI, these two are also defined in <math.h> */
#define EDOM		33	/* Argument too large */
#define ERANGE		34	/* Result too large */

/*** internally, sys_errlist[] ends here (with different #35) ***/

/* non-blocking and interrupt i/o */
#define EWOULDBLOCK	35	/* Operation would block */
#define EINPROGRESS	36	/* Operation now in progress */
#define EALREADY	37	/* Operation already in progress */

/* ipc/network software */

	/* argument errors */
#define ENOTSOCK	38	/* Socket operation on non-socket */
#define EDESTADDRREQ	39	/* Destination address required */
#define EMSGSIZE	40	/* Message too long */
#define EPROTOTYPE	41	/* Protocol wrong type for socket */
#define ENOPROTOOPT	42	/* Protocol not available */
#define EPROTONOSUPPORT 43	/* Protocol not supported */
#define ESOCKTNOSUPPORT 44	/* Socket type not supported */
#define EOPNOTSUPP	45	/* Operation not supported on socket */
#define EPFNOSUPPORT	46	/* Protocol family not supported */
#define EAFNOSUPPORT	47	/* Address family not supported by protocol family */
#define EADDRINUSE	48	/* Address already in use */
#define EADDRNOTAVAIL	49	/* Can't assign requested address */

	/* operational errors */
#define ENETDOWN	50	/* Network is down */
#define ENETUNREACH	51	/* Network is unreachable */
#define ENETRESET	52	/* Network dropped connection on reset */
#define ECONNABORTED	53	/* Software caused connection abort */
#define ECONNRESET	54	/* Connection reset by peer */
#define ENOBUFS		55	/* No buffer space available */
#define EISCONN		56	/* Socket is already connected */
#define ENOTCONN	57	/* Socket is not connected */
#define ESHUTDOWN	58	/* Can't send after socket shutdown */
#define ETOOMANYREFS	59	/* Too many references: can't splice */
#define ETIMEDOUT	60	/* Connection timed out */
#define ECONNREFUSED	61	/* Connection refused */

	/* */
#define ELOOP		62	/* Too many levels of symbolic links */
#define ENAMETOOLONG	63	/* File name too long */

/* should be rearranged */
#define EHOSTDOWN	64	/* Host is down */
#define EHOSTUNREACH	65	/* No route to host */
#define ENOTEMPTY	66	/* Directory not empty */

/*** VAX C's <errno.h> (as of V3.2) ends at #65 ***/

/* quotas & mush */
#define EPROCLIM	67	/* Too many processes */
#define EUSERS		68	/* Too many users */
#define EDQUOT		69	/* Disc quota exceeded */

/* Sun NFS, Network File System */
#define ESTALE		70	/* Stale NFS file handle */
#define EREMOTE		71	/* Too many levels of remote in path */

/* Sun lock, SystemV Record Locking */
#define EDEADLK		78	/* Deadlock condition */
#define ENOLCK		79	/* No record locks available */

/* Intelligent device errors */
#define EPWROFF		80	/* Device power is off */
#define EDEVERR		81	/* Device error */
#define ENOINIT		82	/* Device not initialized */

/* Program loading errors */
#define EBADEXEC	83	/* Bad executable */

/* VMS-specific */
#define EVMSERR 65535	/* VMS-specific error code for non-translatable errors from VMS to C */

/*
 *	Define the VAXCTRL error reporting variables
 */
/* UNIX style error code */
extern __volatile int errno	__asm("_$$PsectAttributes_NOSHR$$errno");
/* VMS error code when errno == EVMSERR */
#define vaxc$errno __gnuc_errno		/* hide '$', in case -ansi is used */
extern __volatile int vaxc$errno __asm("_$$PsectAttributes_NOSHR$$vaxc$errno");

#if defined(_CMA_ERRNO_H) || defined(CMA_ERRNO)
/* note: <cma_errno.h> will redefine 'errno' without using #undef first */
#undef errno
#endif

#ifndef _STRERROR_P
#define _STRERROR_P
/* this is _not_ standard, neither the elipsis nor having it in <errno.h>, */
/* but it is useful enough to have it here				   */
#ifdef __STDC__
char	*strerror(int __err, ...);	/* 2nd arg used iff 1st is EVMSERR */
#else
char	*strerror();
#endif
#endif

# ifdef __cplusplus
}
# endif
#endif	/*_ERRNO_H*/
