/* <float.h>
 *
 *	Floating point constants.
 */
#ifndef _FLOAT_H
#define _FLOAT_H
/* note: there are several discrepancies between this <float.h> and VAX C's */
/* Automated generation using 'enquire' version 4.3, CWI, Amsterdam */

   /* Radix of exponent representation */
#define FLT_RADIX 2
   /* Number of base-FLT_RADIX digits in the significand of a float */
#define FLT_MANT_DIG 24
   /* Number of decimal digits of precision in a float */
#define FLT_DIG 6
   /* Addition rounds to 0: zero, 1: nearest, 2: +inf, 3: -inf, -1: unknown */
#define FLT_ROUNDS 1
   /* Difference between 1.0 and the minimum float greater than 1.0 */
   /* (note: VAX C's <float.h> has ((float)(1.0/16777216)) which is (1.0F/(1<<24))) */
#define FLT_EPSILON 1.19209290e-07F
   /* Minimum int x such that FLT_RADIX**(x-1) is a normalised float */
#define FLT_MIN_EXP (-127)
   /* Minimum normalised float */
#define FLT_MIN 2.93873588e-39F
   /* Minimum int x such that 10**x is a normalised float */
#define FLT_MIN_10_EXP (-38)
   /* Maximum int x such that FLT_RADIX**(x-1) is a representable float */
#define FLT_MAX_EXP 127
   /* Maximum float (note: VAX C's float.h omits the final '3' digit) */
#define FLT_MAX 1.70141173e+38F
   /* Maximum int x such that 10**x is a representable float */
#define FLT_MAX_10_EXP 38

#ifndef __GFLOAT__
	/* Normal D-float double precision */

   /* Number of base-FLT_RADIX digits in the significand of a double */
#define DBL_MANT_DIG 56
   /* Number of decimal digits of precision in a double */
#define DBL_DIG 16
   /* Difference between 1.0 and the minimum double greater than 1.0 */
   /* (note: VAX C's <float.h> has ((1.0/10485766/10485766/65536)) */
   /*  which is (1.0/(1<<(20+20+16))), sort of :-)		   */
#define DBL_EPSILON 2.77555756156289135e-17
   /* Minimum int x such that FLT_RADIX**(x-1) is a normalised double */
#define DBL_MIN_EXP (-127)
   /* Minimum normalised double */
#define DBL_MIN 2.93873587705571877e-39
   /* Minimum int x such that 10**x is a normalised double */
#define DBL_MIN_10_EXP (-38)
   /* Maximum int x such that FLT_RADIX**(x-1) is a representable double */
#define DBL_MAX_EXP 127
   /* Maximum double */
#define DBL_MAX 1.70141183460469229e+38
   /* Maximum int x such that 10**x is a representable double */
#define DBL_MAX_10_EXP 38

	/* long double is equivalent to double in the current implementation */

   /* Number of base-FLT_RADIX digits in the significand of a long double */
#define LDBL_MANT_DIG 56
   /* Number of decimal digits of precision in a long double */
#define LDBL_DIG 16
   /* Difference between 1.0 and the minimum long double greater than 1.0 */
#define LDBL_EPSILON 2.77555756156289135e-17L
   /* Minimum int x such that FLT_RADIX**(x-1) is a normalised long double */
#define LDBL_MIN_EXP (-127)
   /* Minimum normalised long double */
#define LDBL_MIN 2.93873587705571877e-39L
   /* Minimum int x such that 10**x is a normalised long double */
#define LDBL_MIN_10_EXP (-38)
   /* Maximum int x such that FLT_RADIX**(x-1) is a representable long double */
#define LDBL_MAX_EXP 127
   /* Maximum long double */
#define LDBL_MAX 1.70141183460469229e+38L
   /* Maximum int x such that 10**x is a representable long double */
#define LDBL_MAX_10_EXP 38

#else	/*__GFLOAT__*/
	/* Alternate G-float double precision */

#define DBL_MANT_DIG 53
#define DBL_DIG 15
   /* (note: VAX C's <float.h> has ((1.0/10485766/10485766/8192)) */
   /*  which is (1.0/(1<<(20+20+13))), sort of :-)		  */
#define DBL_EPSILON 2.2204460492503131e-16
#define DBL_MIN_EXP (-1023)
   /* (note: VAX C's <float.h> ends in 00346e instead of 0035e) */
#define DBL_MIN 5.5626846462680035e-309
#define DBL_MIN_10_EXP (-308)
#define DBL_MAX_EXP 1023
   /* (note: VAX C's <float.h> has an extra '4' before the 'e') */
#define DBL_MAX 8.9884656743115785e+307
#define DBL_MAX_10_EXP 307

#define LDBL_MANT_DIG 53
#define LDBL_DIG 15
#define LDBL_EPSILON 2.2204460492503131e-16L
#define LDBL_MIN_EXP (-1023)
#define LDBL_MIN 5.5626846462680035e-309L
#define LDBL_MIN_10_EXP (-308)
#define LDBL_MAX_EXP 1023
#define LDBL_MAX 8.9884656743115785e+307L
#define LDBL_MAX_10_EXP 307

#endif	/*?__GFLOAT__*/

#endif	/*_FLOAT_H*/
