/*
	<iso646.h> -- macros for use in place of certain tokens that are
		not expressible in the invariant subset of ISO 646:1991
 
	public-domain implementation for all versions of C
 
	last edit:	13-Dec-1992	Gwyn@ARL.Army.Mil
 
	complies with the following standard:
		ANSI/ISO 9899:1990[1992] (as expected to be amended in 1993)
 
	Usage:	??=include <iso646.h>
 
	Notes:	The C standard has always required that the following
		trigraphs be supported in translation phase 1:
			??= mapped to #
			??( mapped to [
			??/ mapped to \
			??) mapped to ]
			??' mapped to ^
			??< mapped to {
			??! mapped to |
			??> mapped to }
			??- mapped to ~
 
		The forthcoming normative addendum to the C standard that
		requires conforming implementations to provide <iso646.h>
		also requires support in translation phases 3..4 for the
		following preprocessing tokens:
			%: alternate spelling for #
			%:%: alternate spelling for ##
		It also requires support in translation phases 3..7 for the
		following preprocessing tokens:
			<% alternate spelling for {
			%> alternate spelling for }
			<: alternate spelling for [
			:> alternate spelling for ]
 
		The C standard also requires that the "difficult" characters
		be somehow provided in both the basic source and execution
		character sets, regardless of the provision of trigraph,
		digraph, and macro alternatives for these characters.
 
		It is suggested that all C programmers avoid use of the
		following identifiers in their programs, in case somebody
		later needs to use <iso646.h> in maintaining the programs.
 */
 
#if !defined(__cplusplus) || !defined(__GNUC_MINOR__) || (__GNUC__ == 2 && __GNUC_MINOR__ < 7)
		/* (these have become built-ins for g++ 2.7) */

#define or	||
#define bitor	|
#define or_eq	|=
#define xor	^
#define xor_eq	^=
#define compl	~
#define and	&&
#define bitand	&
#define and_eq	&=
#define not	!
/* #define ne	!= */
#define not_eq	!=

#endif	/* !__cplusplus || !__GNUC_MINOR__ */
