/* <limits.h>
 *
 *	LIMITS - Definitions of platform's max & min integral values.
 */
#ifndef _LIMITS_H
#define _LIMITS_H

/* 8-bit bytes */
#define CHAR_BIT	8

#define SCHAR_MAX	127
#define SCHAR_MIN	(-128)
#define UCHAR_MAX	(255U)

/* for VAX/VMS, we've got signed chars by default */
#define CHAR_MAX	SCHAR_MAX
#define CHAR_MIN	SCHAR_MIN

/* sizeof short == 2 */
#define SHRT_MAX	32767
#define SHRT_MIN	(-32768)
#define USHRT_MAX	(65535U)

/* sizeof int == 4 */
#define INT_MAX		2147483647
#define INT_MIN		(-2147483647-1)
#define UINT_MAX	(4294967295U)

/* sizeof long == 4 */
#define LONG_MAX	(2147483647L)
#define LONG_MIN	(-2147483647L-1L)
#define ULONG_MAX	(4294967295UL)

#endif	/*_LIMITS_H*/
