/* <malloc.h>
 *
 *	Unix-compatability memory allocator header; use ANSI <stdlib.h> instead.
 */
#ifndef _MALLOC_H
#define _MALLOC_H
# ifdef __cplusplus
extern "C" {
# endif

#ifdef __STDC__
 /* 'unsigned's should actually be 'size_t' */
void	*malloc(unsigned);
void	*calloc(unsigned, unsigned);
void	*realloc(void *, unsigned);
void	 free(void *);
void	 cfree(void *);
int	 brk(void *);			/* also in our <unixlib.h> */
void	*sbrk(unsigned long);		/*  ditto  */
#else
char	*malloc(), *calloc(), *realloc();
void	 free(), cfree();
int	 brk();
char	*sbrk();
#endif

# ifdef __cplusplus
}
# endif
#endif	/*_MALLOC_H*/
