/* <math.h>
 *
 *	Run-time library math functions.
 */
#ifndef _MATH_H
#define _MATH_H
# ifdef __cplusplus
extern "C" {
# endif

#ifdef __GFLOAT__
# define HUGE_VAL (8.988465674311578540726371186585e+307)
#else
# define HUGE_VAL (1.70141183460469229e+38)
#endif

/* these are also defined in <errno.h> */
#define EDOM	33	/* Argument too large */
#define ERANGE	34	/* Result too large */

/* alternate representation of doubles requires different library routines,
   with names prefixed by "vaxc$g" */
#if    __GFLOAT__
# define ___gdecl(_func,_arglist) _func _arglist __asm("_vaxc$g" #_func)
#elif  __MIXED_FLOAT__
# define ___gdecl(_func,_arglist) _func _arglist __asm("_vaxc$d" #_func)
#else
# define ___gdecl(_func,_arglist) _func _arglist
#endif

/* these are routines in VAXCRTL listed by K&R2's ANSI <math.h> description */
double	___gdecl(acos,	(double));
double	___gdecl(asin,	(double));
double	___gdecl(atan,	(double));
double	___gdecl(atan2, (double,double));
double	___gdecl(ceil,	(double));
double	___gdecl(cos,	(double));
double	___gdecl(cosh,	(double));
double	___gdecl(exp,	(double));
double	___gdecl(fabs,	(double));
double	___gdecl(floor, (double));
double	___gdecl(fmod,	(double,double));
double	___gdecl(frexp, (double,int *));
double	___gdecl(ldexp, (double,int));
double	___gdecl(log,	(double));
double	___gdecl(log10, (double));
double	___gdecl(modf,	(double,double *));
double	___gdecl(pow,	(double,double));
double	___gdecl(sin,	(double));
double	___gdecl(sinh,	(double));
double	___gdecl(sqrt,	(double));
double	___gdecl(tan,	(double));
double	___gdecl(tanh,	(double));

/* these two are in VAX C's <math.h> (and VAXCRTL) */
#ifndef _CABS_T
#define _CABS_T
typedef struct CABS_T { double real, imag; } cabs_t;
#endif	/*_CABS_T*/
double	___gdecl(cabs,	(cabs_t));	/* sqrt(.real*.real + .imag*.imag) */
double	___gdecl(hypot, (double,double));	/* sqrt(d1*d1 + d2*d2) */

#undef ___gdecl		/*__GFLOAT__*/

# ifdef __cplusplus
}
# endif
#endif	/*_MATH_H*/
