/* <signal.h>
 *
 *	VAXCRTL compatible signal definitions.
 */
#ifndef _SIGNAL_H
#define _SIGNAL_H
# ifdef __cplusplus
extern "C" {
# endif

#define NSIG	17	/* number of signals (VAX C has 17, but ends at 15) */

#define SIGHUP	1		/* hangup */
#define SIGINT	2		/* interrupt */
#define SIGQUIT 3		/* quit */
#define SIGILL	4		/* illegal instruction (not reset when caught) */
#define ILL_RESAD_FAULT  0x0	/* reserved addressing mode fault */
#define ILL_PRIVIN_FAULT 0x1	/* privilidged instruction fault */
#define ILL_RESOP_FAULT  0x2	/* reserved operand fault */
#define SIGTRAP 5		/* trace trap (not reset when caught) */
#define SIGIOT	6		/* IOT instruction */
#define SIGEMT	7		/* EMT instruction */
#define SIGFPE	8		/* floating point exception */
#define FPE_INTOVF_TRAP  0x1
#define FPE_INTDIV_TRAP  0x2
#define FPE_FLTOVF_TRAP  0x3
#define FPE_FLTDIV_TRAP  0x4
#define FPE_FLTUND_TRAP  0x5
#define FPE_DECOVF_TRAP  0x6
#define FPE_SUBRNG_TRAP  0x7
#define FPE_FLTOVF_FAULT 0x8
#define FPE_FLTDIV_FAULT 0x9
#define FPE_FLTUND_FAULT 0xa
#define SIGKILL 9		/* kill (cannot be caught or ignored) */
#define SIGBUS	10		/* bus error */
#define SIGSEGV 11		/* segmentation violation */
#define SIGSYS	12		/* bad argument to system call */
#define SIGPIPE 13		/* write to a pipe with no one to read it */
#define SIGALRM 14		/* alarm clock */
#define SIGTERM 15		/* software termination signal from kill */

#if 0	/* not implemented [yet?] (obtained from Ultrix <signal.h>) */
#define SIGURG	16		/* urgent condition on IO channel */
#define SIGSTOP 17		/* sendable stop signal not from tty */
#define SIGTSTP 18		/* stop signal from tty */
#define SIGCONT 19		/* continue a stopped process */
#define SIGCHLD 20		/* to parent on child stop or exit */
#define SIGTTIN 21		/* to readers pgrp upon background tty read */
#define SIGTTOU 22		/* like TTIN for output if (tp->t_local&LTOSTOP) */
#define SIGIO	23		/* input/output possible signal */
#define SIGXCPU 24		/* exceeded CPU time limit */
#define SIGXFSZ 25		/* exceeded file size limit */
#define SIGVTALRM 26		/* virtual time alarm */
#define SIGPROF 27		/* profiling time alarm */
#define SIGWINCH 28		/* window size changes */
#define SIGLOST 29		/* Sys-V rec lock: notify user upon server crash */
#define SIGUSR1 30		/* User signal 1 (from SysV) */
#define SIGUSR2 31		/* User signal 2 (from SysV) */
#define SIGCLD	SIGCHLD		/* SysV */
#define SIGABRT SIGIOT		/* BRL */
#endif	/* not implemented */

#if !defined(_SIG_ATOMIC_T) && !defined(_SIG_ATOMIC_T_)
typedef long sig_atomic_t;
#endif
#define _SIG_ATOMIC_T
#define _SIG_ATOMIC_T_
#if !defined(_SIGSET_T) && !defined(_SIGSET_T_)
typedef int  sigset_t;
#endif
#define _SIGSET_T
#define _SIGSET_T_

#define SV_ONSTACK	01
#define SV_INTERRUPT	02
#define SA_NOCLDSTOP	04
#define SV_OLDSIG	010000		/*(from Ultrix /usr/include/signal.h)*/
struct sigvec {
	void	(*sv_handler)();	/* handler address */
	sigset_t sv_mask;		/* mask of signals to be blocked */
	int	sv_flags;		/* flag to indicate signal stack */
#define sv_onstack sv_flags		/* old name for flags */
};
struct sigaction {	/* POSIX version of the above */
	void	(*sa_handler)();
	sigset_t sa_mask;
	int	sa_flags;
};
struct sigcontext {
	int	sc_onstack;		/* signal stack flag to restore */
	int	sc_mask;		/* signal mask to restore */
	int	sc_sp;			/* stack pointerto restore */
	int	sc_pc;			/* pc to return to */
	int	sc_ps;			/* psl to restore */
};
struct sigstack {
	char	*ss_sp;			/* signal stack pointer */
	int	ss_onstack;		/* current status */
};

#ifndef __STRICT_ANSI__
#define sigmask(X)	(1UL << ((X) - 1))
#endif

#ifdef __STDC__

# ifdef VMS_SIGNALS
	/* Additional arguments above and beyond the signal number.
	   Presence of these optional arguments makes type-correct
	   declarations just about impossible unless __SIG_ARGS is
	   used.  Default action is to ignore the extra arguments and
	   pretend that we're dealing with vanilla ANSI-sanctioned
	   signals.
	 */
# define __SIG_ARGS int,...
# else
	/* portable arguments instead of full VMS signals */
# define __SIG_ARGS int
# endif

# define SIG_ERR ((void (*)(__SIG_ARGS))-1)	/* invalid */
# define SIG_DFL ((void (*)(__SIG_ARGS))0)	/* default */
# define SIG_IGN ((void (*)(__SIG_ARGS))1)	/* ignore */
# define BADSIG  SIG_ERR		/* pre-ANSI name */

void (*signal(int,void (*)(__SIG_ARGS)))(__SIG_ARGS);
void (*ssignal(int,void (*)(__SIG_ARGS)))(__SIG_ARGS);

int alarm(unsigned);		/* note: returns int, not unsigned */
int gsignal(__SIG_ARGS);	/* functionally equivalent to raise(), but works! */
int kill(int,int);
int pause(void);
int raise(int);			/* note: as of VMS V5.4, missing from VAXCRTL */
int sigblock(int);
int sigpause(int);
int sigsetmask(int);
int sigstack(struct sigstack *,struct sigstack *);
int sigvec(int,struct sigvec *,struct sigvec *);
int sleep(unsigned);		/* note: returns int, not unsigned */

/* condition handler capable of dealing with setjmp/longjmp */
#ifndef _VAXC$ESTABLISH_P
#define _VAXC$ESTABLISH_P
/* void VAXC$ESTABLISH(unsigned long (*)(unsigned long *,unsigned long *)); */
/* this prototype matches VAX C's, but the one above is more appropriate */
void VAXC$ESTABLISH(int (*)(void *,void *));
#endif

#else	/*!__STDC__ => -traditional */

# define SIG_ERR ((void (*)())-1)
# define SIG_DFL ((void (*)())0)
# define SIG_IGN ((void (*)())1)
# define BADSIG  SIG_ERR

void (*signal)(), (*ssignal)();
int alarm(), gsignal(), kill(), pause(), raise(), sleep();
int sigblock(), sigpause(), sigsetmask(), sigstack(), sigvec();
void VAXC$ESTABLISH();

#endif	/*?__STDC__*/

# ifdef __cplusplus
}
# endif
#endif	/*_SIGNAL_H*/
