/* <stat.h>
 *
 *	VAXCRTL compatible stat definition.
 */
#ifndef _STAT_H
#define _STAT_H
# ifdef __cplusplus
extern "C" {
# endif

/* in case <sys/types.h> hasn't been included yet */
#ifndef _INO_T
#define _INO_T
typedef unsigned short ino_t;	/* broken def, forcing array [3] below */
#undef FIXED_INO_T
#endif
#ifndef _DEV_T
#define _DEV_T
typedef char *dev_t;
#endif
#ifndef _OFF_T
#define _OFF_T
typedef long off_t;
#endif

/*
 *	Because of alignment differences between VAX C and GNU C
 *	we can't normally access any field AFTER st_gid.  To fix this
 *	the macro stat_alignment_fix(statp) makes fields AFTER st_gid
 *	work right.  stat_alignment_fix2(statp) allows st_fab_mrs to be
 *	accessed.
 *
 *	VMS/GCC defines the CPP variable "PCC_ALIGNMENT" if UNIX PCC
 *	style alignment is in effect.  Otherwise, VAX C style
 *	alignment is in effect.
 */
#ifdef	PCC_ALIGNMENT
#define stat_alignment_fix(statp) \
	((struct stat *)((char *)statp - sizeof(short)))

#define stat_alignment_fix1(statp) \
	((struct stat *)((char *)statp - sizeof(short) - sizeof(char)))
#endif	/*PCC_ALIGNMENT*/

#define _STAT_T
#define _STAT_T_
typedef struct stat {
	dev_t	st_dev;
# ifdef FIXED_INO_T	/* see <sys/types.h> */
	ino_t	st_ino;		/* single 6-byte cookie */
# else
	ino_t	st_ino[3];	/* bogus array, compatible with VAXC */
# endif
	unsigned short st_mode;
	int	st_nlink;
	unsigned st_uid;
	unsigned short st_gid;	/* <---- The big screw...  VAX C doesn't
					do alignment so everything following
					this is wrong! */
	dev_t	st_rdev;
	off_t	st_size;
	unsigned st_atime;
	unsigned st_mtime;
	unsigned st_ctime;
	char	st_fab_rfm;
	char	st_fab_rat;
	char	st_fab_fsz;	/* <---- Another screw */
	unsigned st_fab_mrs;
} stat_t;

#define S_IFMT	 0170000	 /* type of file */
#define		 S_IFDIR 0040000 /* directory */
#define		 S_IFCHR 0020000 /* character special */
#define		 S_IFBLK 0060000 /* block special */
#define		 S_IFREG 0100000 /* regular */
#define		 S_IFMPC 0030000 /* multiplexed char special */
#define		 S_IFMPB 0070000 /* multiplexed block special */
#define S_ISUID  0004000	 /* set user id on execution */
#define S_ISGID  0002000	 /* set group id on execution */
#define S_ISVTX  0001000	 /* save swapped text even after use */
#define S_IREAD  0000400	 /* read permission, owner */
#define S_IWRITE 0000200	 /* write permission, owner */
#define S_IEXEC  0000100	 /* execute/search permission, owner */

#ifdef __STDC__
int  fstat(int, stat_t *);
int  stat(const char *, stat_t *);
#else	/*!__STDC__ => -traditional */
int  fstat(), stat();
#endif	/*?__STDC__*/

#ifndef S_ISDIR
#define S_ISDIR(mode)	(((mode) & S_IFMT) == S_IFDIR)
#endif
#ifndef S_ISCHR
#define S_ISCHR(mode)	(((mode) & S_IFMT) == S_IFCHR)
#endif
#ifndef S_ISBLK
#define S_ISBLK(mode)	(((mode) & S_IFMT) == S_IFBLK)
#endif
#ifndef S_ISREG
#define S_ISREG(mode)	(((mode) & S_IFMT) == S_IFREG)
#endif

# ifdef __cplusplus
}
# endif
#endif	/*_STAT_H*/
