/* <stdarg.h>
 *
 *  --	ANSI-C style variable argument lists
 */
#ifndef _STDARG_H
#define _STDARG_H

#if !defined(_VA_LIST) && !defined(_VA_LIST_)
# define _VA_LIST
# define _VA_LIST_
typedef char *va_list;
#endif

#ifdef va_start /* remove varargs macros */
# undef va_alist
# undef va_dcl
# undef __va_rounded_size
# undef va_start
# undef va_end
# undef va_arg
# undef va_count
# undef va_start_1
#endif

/* Amount of space required in an argument list for an arg of type TYPE.
   TYPE may alternatively be an expression whose type is used.	*/

#define __va_rounded_size(TYPE)  \
 (((sizeof (TYPE) + sizeof (int) - 1) / sizeof (int)) * sizeof (int))

#if __GNUC__ == 2 && __GNUC_MINOR__ >= 6
#define va_start(AP,LASTARG)	\
 (AP = (va_list) __builtin_next_arg(LASTARG))
#elif __GNUC__ > 1
#define va_start(AP,LASTARG)	\
 (((void) &LASTARG), (AP = (va_list) __builtin_next_arg()))
#else
#define va_start(AP,LASTARG)	\
 (AP = (va_list) ((int *) &LASTARG + 1))
#endif

#define va_end(AP)	((void)(AP = 0))

/* Increment AP, then return its previous value.  Assumes little-endian arch. */
#define va_arg(AP,TYPE)		\
 (AP += __va_rounded_size(TYPE), *(TYPE *) (AP - __va_rounded_size(TYPE)))

#endif	/*_STDARG_H*/
