/* <stddef.h>
 *
 *	ANSI-C "standard definitions"
 */
#ifndef _STDDEF_H
#define _STDDEF_H
/*
 *  Note: long vs int assumes VAX hardware => int is sufficient and
 *	matches the VAX C headers (hence the actual run-time library).
 */

/* Signed type of difference of two pointers. */
#if !defined(_PTRDIFF_T) && !defined(_PTRDIFF_T_)
typedef int ptrdiff_t;
#endif
#define _PTRDIFF_T
#define _PTRDIFF_T_

/* Unsigned type of `sizeof' something. */
#if !defined(_SIZE_T) && !defined(_SIZE_T_)
typedef unsigned size_t;
#endif
#define _SIZE_T
#define _SIZE_T_

/* Wide characters, not yet supported by VAXCRTL [match VAXC's <stddef.h>] */
#ifndef __WCHAR_TYPE__
#define __WCHAR_TYPE__ unsigned int
#endif
#if !defined(_WCHAR_T) && !defined(_WCHAR_T_) && (!defined(__cplusplus) || __GNUC_MINOR__ < 7)
typedef __WCHAR_TYPE__ wchar_t;
#endif
#define _WCHAR_T
#define _WCHAR_T_

/* A null pointer constant. */
#ifdef NULL
#undef NULL
#endif
#define NULL ((void *)0)

/* Offset of member _Member in a struct of type _Type. */
#define offsetof(_Type,_Member) ((size_t)&((_Type *)0)->_Member)

/* prototype definition macro; hardly standard! but useful for BSD compat */
#ifndef __P	/* from <sys/cdefs.h> */
# ifdef __STDC__
#  define __P(protos) protos
# else	/*!__STDC__ => -traditional */
#  define __P(protos) ()
# endif /*?__STDC__*/
#endif	/*__P*/

#endif	/*_STDDEF_H*/
