/* <stdio.h>
 *
 *	This defines a VAXCRTL compatible standard I/O interface.
 */
#ifndef _STDIO_H
#define _STDIO_H
# ifdef __cplusplus
extern "C" {
# endif

#if defined(__STDC__) && !defined(_STDDEF_H)
#include <stddef.h>	/* get size_t, NULL */
#endif

/*
 *	The maximum number of files we can have open at a time
 *	(not really; blocks of this many are chained together by vaxcrtl)
 */
#define _NFILE 20

/*
 *	STDIO buffer size
 */
#if defined(vax) || defined(__vax__) || defined(__VAX__)
#define BUFSIZ 512
#else	/* assume Alpha */
#define BUFSIZ 8192
#endif

/*
 *	Arguments to setvbuf()
 */
#define _IOLBF 1	/* line buffered */
#define _IOFBF 2	/* fully buffered */
/* #def _IONBF 4 */	/* unbuffered (really defined below) */

/*
 *	This is what the VAXCRTL stdio FILE structure looks like
 */
struct	_iobuf	{
	int	_cnt;			/* # of characters in the buffer */
	char	*_ptr;			/* Pointer into the buffer	 */
	char	*_base;			/* Pointer to start of buffer	 */
	char	_flag;			/* STDIO flags			 */
#define _IOREAD		0001			/* Open for reading	 */
#define _IOWRT		0002			/* Open for writing	 */
#define _IONBF		0004			/* No buffer		 */
#define _IOMYBUF	0010			/* Using "my" buffer	 */
#define _IOEOF		0020			/* At End Of File	 */
#define _IOERR		0040			/* I/O error has occured */
#define _IOSTRG		0100			/* Doing I/O to a string */
#define _IORW		0200			/* Open for read/write	 */
	char	_file;			/* File descriptor		 */
};

/*
 *	Instead of passing around pointers to _iobuf structures, VAXCRTL
 *	passes around pointers to pointers.
 */
typedef struct _iobuf *FILE;

/*
 *	Cookie used by fgetpos() and fsetpos() [alternatives to ftell/fseek]
 *	Internally, it's a 6-byte RFA plus a 2-byte offset within record.
 */
typedef struct _FPOS_T { unsigned : 32, : 32; } fpos_t;

/*
 *	Also, stdin/stdout/stderr need to be defined
 *	[We also use a hack here that makes the GCC assembler modify
 *	 the psect attributes to match those of the VAXCRTL]
 */
extern FILE *stdin	__asm("_$$PsectAttributes_NOSHR$$stdin");
extern FILE *stdout	__asm("_$$PsectAttributes_NOSHR$$stdout");
extern FILE *stderr	__asm("_$$PsectAttributes_NOSHR$$stderr");

/*
 *	Define NULL and EOF
 */
#ifndef __STDC__	/* got it from <stddef.h> if __STDC__ */
#define NULL 0
#endif
#define EOF	(-1)

#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#define SEEK_EOF SEEK_END	/* VAX C compatability */

#define FOPEN_MAX 8	/* minimum number simultaneously open files */
#define OPEN_MAX  8	/* ditto (note: minimum _guaranteed_; more possible) */
#define TMP_MAX  32	/* minimum number of unique names tmpnam() gives */
#define FILENAME_MAX 39 /* longest filename [should be 255; see below] */

/*
 *	Buffer sizes for various return values
 */
#define L_ctermid	64	/* size of device name */
#define L_cuserid	16	/* size of user name */
#define L_tmpnam	256	/* size of file name */
#define L_lcltmpnam	256	/* size of file local name */
#define L_nettmpnam	256	/* size of file network name */

/*
 *	Define the stdio macros; note that getc and putc are function calls.
 */
#ifdef __STDC__ /* these usually-macros have functions backing them */
int	getchar(void);
int	putchar(int);
#endif		/* most of the others should too, but don't as of V5.4-3 */
#define getc(fp)	fgetc(fp)
#define getchar()	fgetc(stdin)
#define putc(x,fp)	fputc((x),fp)
#define putchar(x)	fputc((x),stdout)
#define feof(fp)	(((*fp)->_flag & _IOEOF)!=0)
#define ferror(fp)	(((*fp)->_flag & _IOERR)!=0)
#define fileno(fp)	((*fp)->_file)
#define clearerr(fp)	((*fp)->_flag &= ~(_IOERR|_IOEOF))

/* VAX C compatibility */
#define vaxc$record_read(fp,buf,max_size) read(fileno(fp),(buf),(max_size))
#define vaxc$record_write(fp,buf,size) fwrite((buf),(size),1,(fp))

/*
 *	Check for alternate representation of doubles; affects formatted I/O.
 */
#if    __GFLOAT__
# define ___gdecl(_func,_arglist) _func _arglist __asm("_vaxc$g" #_func)
#elif  __MIXED_FLOAT__
# define ___gdecl(_func,_arglist) _func _arglist __asm("_vaxc$d" #_func)
#else
# define ___gdecl(_func,_arglist) _func _arglist
#endif

/*
 *	Declare stdio routines
 */
#ifdef __STDC__

/* access */
FILE	*fopen(const char *,const char *,...);
FILE	*fdopen(int,const char *);
FILE	*freopen(const char *,const char *,FILE *,...);
int	 fflush(FILE *);
int	 fclose(FILE *);

/* unformatted input/output */
int	 fgetc(FILE *file_ptr);
int	 ungetc(int,FILE *);
int	 fputc(int,FILE *);
int	 getw(FILE *file_ptr);
int	 putw(int,FILE *);
char	*gets(char *);
int	 puts(const char *);
char	*fgets(char *,int,FILE *);
int	 fputs(const char *,FILE *);
size_t	 fread(void *,size_t,size_t,FILE *);
size_t	 fwrite(const void *,size_t,size_t,FILE *);

/* formatted input/output */
# define ___va_list_t char *
int  ___gdecl(scanf,	(const char *,...));
int  ___gdecl(printf,	(const char *,...));
int  ___gdecl(vprintf,	(const char *,___va_list_t));
int  ___gdecl(fscanf,	(FILE *,const char *,...));
int  ___gdecl(fprintf,	(FILE *,const char *,...));
int  ___gdecl(vfprintf, (FILE *,const char *,___va_list_t));
int  ___gdecl(sscanf,	(const char *,const char *,...));
int  ___gdecl(sprintf,	(char *,const char *,...));
int  ___gdecl(vsprintf, (char *,const char *,___va_list_t));
# undef ___va_list_t

/* positioning */
int	 fseek(FILE *,long,int);
long	 ftell(FILE *);
int	 fsetpos(FILE *,const fpos_t *);
int	 fgetpos(FILE *,fpos_t *);
int	 rewind(FILE *);

/* miscellaneous */
void	 perror(const char *);
int	 remove(const char *);
void	 setbuf(FILE *,char *);
int	 setvbuf(FILE *,char *,int,size_t);
char	*fgetname(FILE *,char *,...); /* optional arg is VMS vs shell name format */
char	*tmpnam(char *);
FILE	*tmpfile(void);

#else	/*!__STDC__ => -traditional */

FILE	*fopen(), *fdopen(), *freopen();
int	 fflush(), fclose();
int	 fgetc(), ungetc(), fputc(), getw(), putw(), puts(), fputs();
char	*gets(), *fgets();
unsigned fread(), fwrite();
int	___gdecl(scanf,    ());
int	___gdecl(printf,   ());
int	___gdecl(vprintf,  ());
int	___gdecl(fscanf,   ());
int	___gdecl(fprintf,  ());
int	___gdecl(vfprintf, ());
int	___gdecl(sscanf,   ());
int	___gdecl(sprintf,  ());
int	___gdecl(vsprintf, ());
long	 ftell();
int	 fseek(), fgetpos(), fsetpos(), rewind();
void	 perror(), setbuf();
int	 remove();
int	 setvbuf();
char	*fgetname(), *tmpnam();
FILE	*tmpfile();

#endif	/*?__STDC__*/

#undef ___gdecl		/*__GFLOAT__*/

# ifdef __cplusplus
}
# endif
#endif	/*_STDIO_H*/
