/* <stdlib.h>
 *
 *	ANSI-C Standard Library definitions
 */
#ifndef _STDLIB_H
#define _STDLIB_H
# ifdef __cplusplus
extern "C" {
# endif
			/* note: no !defined(__STDC__) handling, deliberately */

#ifndef _STDDEF_H
#include <stddef.h>	/* get size_t, NULL */
#endif

/*
   These exit macro values work with either exit() or return from main(),
   and avoid unnecessary warnings from the DCL command intrepretor.  They
   don't match VAX C's <stdlib.h>, which has 0 and 2 respectively.  Using 0
   for success works with VAXCRTL's exit() but requires additional compiler
   support in main() (which VAX C neglects to provide).  2 always provokes
   "%NONAME-E-NOMSG, Message number 00000002"; similarly for unfixed 0.
 */
#define EXIT_SUCCESS 1			/* SS$_NORMAL, STS$K_SUCCESS */
#define EXIT_FAILURE 0x10000002		/* (STS$K_ERROR | STS$M_INHIB_MSG) */

#define RAND_MAX 2147483647	/* 0x7FFFFFFF */

#if (__GNUC__ == 2 && !__STRICT_ANSI__)
#if (__GNUC_MINOR__ >= 5)
void abort(void) __attribute__((noreturn));
void exit(int) __attribute__((noreturn));
void _exit(int) __attribute__((noreturn));
#else
volatile void abort(void);
volatile void exit(int), _exit(int);
#endif
#else
void abort(void);
void exit(int), _exit(int);
#endif
int  atexit(void (*)(void));

void *bsearch(const void *,const void *,size_t,size_t,
	      int (*)(const void *,const void *));
#ifdef GCC_QSORT
/*
   N.B.:  as of V5.5-1, VAXCRTL's qsort() is still buggy!  [fixed in V5.5-2]
   Do not use it to sort something whose size is not a multiple of 4
   after having previously sorted something that is a multiple of 4.
   Othewise, it will sort incorrectly and can also corrupt the data.

   Link with GNU_CC:[000000]GNULIB.OLB/LIB _in front of_ VAXCRTL.OLB so that
   the reliable version in there will be used.	However, if you link with
   VAXCRTL.EXE, you're out of luck; the linker will take that one instead of
   the object library one regardless of the order they're presented to it.

   Defining GCC_QSORT will force use of the working routine regardless of
   how the program gets linked.
 */
#define qsort	gcc_qsort
#endif	/*GCC_QSORT*/
void qsort(void *,size_t,size_t,int (*)(const void *,const void *));

int  rand(void);
int  srand(int);		/* routine to initialize rand() */

char *getenv(const char *);	/* also declared in VAX C's <unixlib.h> */
int  system(const char *);	/* also declared in VAX C's <processes.h> */

/* math related routines */
#ifndef _DIV_T
#define _DIV_T
typedef struct DIV_T { int quot, rem; } div_t;
#endif
#ifndef _LDIV_T
#define _LDIV_T
typedef struct LDIV_T { long quot, rem; } ldiv_t;
#endif

/* check for alternate representation of doubles */
#if    __GFLOAT__
# define ___gdecl(_func,_arglist) _func _arglist __asm("_vaxc$g" #_func)
#elif  __MIXED_FLOAT__
# define ___gdecl(_func,_arglist) _func _arglist __asm("_vaxc$d" #_func)
#else
# define ___gdecl(_func,_arglist) _func _arglist
#endif

int	abs(int);
double	___gdecl(atof, (const char *));
int	atoi(const char *);
long	atol(const char *);
div_t	div(int,int);
long	labs(long);
ldiv_t	ldiv(long,long);
double	___gdecl(strtod, (const char *,char **));
long	strtol(const char *,char **,int);
unsigned long strtoul(const char *,char **,int);

/* memory manipulation routines; note: cfree() is gone; see also <malloc.h> */
void	*malloc(size_t);
void	*calloc(size_t, size_t);
void	*realloc(void *, size_t);
void	free(void *);

#undef ___gdecl		/*__GFLOAT__*/

# ifdef __cplusplus
}
# endif
#endif	/*_STDLIB_H*/
