/* <string.h>
 *
 *	Run-time library string manipulation functions, per ANSI.
 */
#ifndef _STRING_H
#define _STRING_H
# ifdef __cplusplus
extern "C" {
# endif
			/* note: not the same as <strings.h> */
			/* n.b.: no !defined(__STDC__) handling */
#ifndef _STDDEF_H
#include <stddef.h>	/* get size_t, NULL */
#endif

#ifdef GCC_STRINGS
/*
   Rename some routines available from GCCLIB so that they're guaranteed
   not to produce linker problems by conflicting with similar ones in
   VAXCRTL.  They're present in order to work-around a serious bug in
   strncat() [still present as of VMS V5.5-1], where it will fall into
   an infinite loop if the source string's length is more than 65535
   characters longer than the number being copied.  The set of routines
   corresponds to those of module C$STRINGS in VAXCRTL.
 */
#define strlen	gcc_strlen
#define strcpy	gcc_strcpy
#define strcat	gcc_strcat
#define strncpy gcc_strncpy
#define strncat gcc_strncat
#define strspn	gcc_strspn
#define strcspn gcc_strcspn
#define strpbrk gcc_strpbrk
#endif	/*GCC_STRINGS*/

#ifdef GCC_STRINGS_TOO
/*
   Other ANSI string manipulation routines available from GCCLIB
   for completeness.
 */
#define strcmp	gcc_strcmp
#define strncmp gcc_strncmp
#define strchr	gcc_strchr
#define strrchr gcc_strrchr
#define strstr	gcc_strstr
#endif	/*GCC_STRINGS_TOO*/

size_t	 strlen(const char *__str);
char	*strcpy(char *__dst, const char *__src);
char	*strcat(char *__dst, const char *__src);
int	 strcmp(const char *__lft, const char *__rgt);
char	*strncpy(char *__dst, const char *__src, size_t __cnt);
char	*strncat(char *__dst, const char *__src, size_t __cnt);
int	 strncmp(const char *__lft, const char *__rgt, size_t __cnt);
char	*strchr(const char *__str, int __chr);
char	*strrchr(const char *__str, int __chr);
size_t	 strspn(const char *__str, const char *__set);
size_t	 strcspn(const char *__str, const char *__set);
char	*strpbrk(const char *__str, const char *__set);
char	*strstr(const char *__str, const char *__sub);
char	*strtok(char *__tkn, const char *__str);
#ifndef _STRERROR_P
#define _STRERROR_P
#if !defined(__STRICT_ANSI__) && !defined(__HIDE_FORBIDDEN_NAMES)
char	*strerror(int __err, ...);	/* 2nd arg used iff 1st is EVMSERR */
#else
char	*strerror(int);
#endif
#endif

void	*memset(void *__mem, int __val, size_t __cnt);
void	*memcpy(void *__dst, const void *__src, size_t __cnt);
void	*memmove(void *__dst, const void *__src, size_t __cnt);
int	 memcmp(const void *__lft, const void *__rgt, size_t __cnt);
void	*memchr(const void *__mem, int __trg, size_t __cnt);

# ifdef __cplusplus
}
# endif
#endif	/*_STRING_H*/
