/* <sys/cdefs.h>
 *
 *	Miscellaneous macros provided for BSD compatibility.
 */
#ifndef _SYS_CDEFS_H
#define _SYS_CDEFS_H

/* macros for declaring prototypes, token pasting, and stringizing */
#if defined(__STDC__) || defined(__cplusplus)
# define __P(args)	args
# define __CONCAT(l,r)	l ## r
# define __STRING(arg)	# arg
#else	/*!__STDC__ => -traditional */
# define __P(args)	()
# define __CONCAT(l,r)	l/**/r
# define __STRING(arg)	"arg"
 /* give the non-traditional keywords special names */
# define const	  __const__
# define volatile __volatile__
# define signed   __signed__
# define inline   __inline__
# define typeof   __typeof__
#endif	/*__STDC__||__cplusplus*/

/* macros for bracketing groups of function prototypes for C++ */
#ifndef __cplusplus
# define __BEGIN_DECLS
# define __END_DECLS
#else
# define __BEGIN_DECLS	extern "C" {
# define __END_DECLS	};
#endif

#endif	/*_SYS_CDEFS_H*/
