/* <sys/fcntl.h>
 *
 *	Constants for Unix-style I/O routines.
 */
#ifndef _SYS_FCNTL_H
#define _SYS_FCNTL_H
			/* see also <file.h> */

#define O_RDONLY	0
#define O_WRONLY	1
#define O_RDWR		2
#define O_NDELAY	4
#define O_NOWAIT	4
#define O_APPEND	8
#define O_CREAT		0x0200
#define O_TRUNC		0x0400
#define O_EXCL		0x0800

/* these aren't implemented in VAXCRTL, so are useless */
#define O_BLKINUSE	0x1000
#define O_BLKANDSET    (0x2000|O_BLKINUSE)
#define O_SYNC		0x8000
#define O_FSYNC		0x8000
#define O_NONBLOCK	0x020000
#define O_NOCTTY	0x080000
#define O_TERMIO	0x040000

/* access mode mask */
#define O_ACCMODE	(O_RDONLY|O_WRONLY|O_RDWR)

/* values used by access() routine, which should be avoided */
#define F_OK	0	/* test whether file exists */
#define X_OK	1	/* test execute access */
#define W_OK	2	/* test write access */
#define R_OK	4	/* test read access */

/* values useable by lseek(); SEEK_xxx values in <stdio.h> are preferred */
#define L_SET	0	/* absolute offset; ie, from beginning of file */
#define L_INCR	1	/* incremental offset; ie, relative to current pos */
#define L_XTND	2	/* extend offset; ie, relative to end-of-file */

#endif	/*_SYS_FCNTL_H*/
