/* <time.h>
 *
 *	VAXCRTL compatible time definitions
 */
#ifndef _TIME_H
#define _TIME_H
#ifndef __TIME
#define __TIME
# ifdef __cplusplus
extern "C" {
# endif

#if defined(__STDC__) && !defined(_STDDEF_H)
#include <stddef.h>	/* get size_t, NULL */
#endif	/*_SIZE_T*/

#ifndef _TIME_T
#include <types.h>	/* typedef long time_t; */
#endif	/*_TIME_T*/

#define CLK_TCK 100
#define CLOCKS_PER_SEC 100

#ifndef _CLOCK_T
#define _CLOCK_T
typedef long clock_t;
#endif	/*_CLOCK_T*/

#ifndef _TM_T
#define _TM_T
typedef struct tm {
	int	tm_sec;
	int	tm_min;
	int	tm_hour;
	int	tm_mday;
	int	tm_mon;
	int	tm_year;
	int	tm_wday;
	int	tm_yday;
	int	tm_isdst;
} tm_t;
#endif	/*_TM_T*/

#ifndef _TBUFFER_T
#define _TBUFFER_T
typedef struct tbuffer {
	int	proc_user_time;
	int	proc_system_time;
	int	child_user_time;
	int	child_system_time;
} tbuffer_t;
#endif	/*_TBUFFER_T*/

#ifndef _TIMEB_T
#define _TIMEB_T
typedef struct timeb {
	time_t		time;
	unsigned short	millitm;
	short		timezone;
	short		dstflag;
} timeb_t;
#endif	/*_TIMEB_T*/

/* check for alternate representation of doubles */
#if    __GFLOAT__
# define ___gdecl(_func,_arglist) _func _arglist __asm("_vaxc$g" #_func)
#elif  __MIXED_FLOAT__
# define ___gdecl(_func,_arglist) _func _arglist __asm("_vaxc$d" #_func)
#else
# define ___gdecl(_func,_arglist) _func _arglist
#endif

#ifdef __STDC__

char	*asctime(const tm_t *);
clock_t  clock(void);
char	*ctime(const time_t *);
double	 ___gdecl(difftime, (time_t,time_t));
void	 ftime(timeb_t *);
tm_t	*gmtime(const time_t *);
tm_t	*localtime(const time_t *);
time_t	 mktime(tm_t *);
size_t	 strftime(char *,size_t,const char *,const tm_t *);
time_t	 time(time_t *);
#ifndef _TIMES_P
#define _TIMES_P
void	 times(tbuffer_t *);
#endif	/*_TIMES_P*/

#else	/*!__STDC__ => -traditional */

char	*asctime(), *ctime();
clock_t  clock();
double	 ___gdecl(difftime, ());
void	 ftime(), times();
tm_t	*gmtime(), *localtime();
time_t	 mktime(), time();
unsigned strftime();

#endif	/*?__STDC__*/

#undef ___gdecl		/*__GFLOAT__*/

# ifdef __cplusplus
}
# endif
#endif	/*__TIME*/
#endif	/*_TIME_H*/
