/* <unixlib.h>
 *
 *      Various Unix compatibility routines available in VAXCRTL.
 */
#ifndef _UNIXLIB_H
#define _UNIXLIB_H
# ifdef __cplusplus
extern "C" {
# endif
	/*( limited substitute for VAX C V3.x's <unixlib.h> )*/

/* declare the global environ[] array */
#ifdef __GNUC__
extern char **environ   __asm("_$$PsectAttributes_NOSHR$$environ");
#else   /* assume VAXC */
extern char noshare **environ;
#endif

/* check for alternate representation of doubles */
#if    __GFLOAT__
# define ___gdecl(_func,_arglist) _func _arglist __asm("_vaxc$g" #_func)
#elif  __MIXED_FLOAT__
# define ___gdecl(_func,_arglist) _func _arglist __asm("_vaxc$d" #_func)
#else
# define ___gdecl(_func,_arglist) _func _arglist
#endif

#ifdef __STDC__         /* these aren't standard, but use their prototypes */

/* miscellaneous emulation routines */
char    *getenv(const char *);
char    *getcwd(char *,unsigned,...); /* optional arg is VMS vs shell name format */

char    *___gdecl(ecvt, (double,int,int *,int *));
char    *___gdecl(fcvt, (double,int,int *,int *));
char    *___gdecl(gcvt, (double,int,char *));

/* process ID */
#if !defined(_PID_T) && !defined(_PID_T_)
typedef int pid_t;
#endif
#define _PID_T
#define _PID_T_
pid_t    getpid(void), getppid(void);

/* user ID -- actually, member portion of UIC (should be `unsigned short') */
#if !defined(_UID_T) && !defined(_UID_T_)
typedef unsigned int uid_t;
#endif
#define _UID_T
#define _UID_T_
uid_t    getuid(void), geteuid(void);

/* group ID -- group portion of UIC (should be `unsigned short') */
#if !defined(_GID_T) && !defined(_GID_T_)
typedef unsigned int gid_t;
#endif
#define _GID_T
#define _GID_T_
gid_t    getgid(void), getegid(void);

int      setgid(unsigned), setuid(unsigned);    /* no-ops */

/* note: none of the following are declared in any VAX C header file */
int      brk(void *);                   /* also in our <malloc.h> -*/
void    *sbrk(unsigned long);           /*+  which is deprecated.  */
int      chdir(const char *);
int      chmod(const char *,unsigned);
int      chown(const char *,unsigned, unsigned);
char    *ctermid(char *);
char    *cuserid(char *);
int      mkdir(const char *,int,...);
int      nice(int);                     /* also in our <processes.h> */
int      umask(unsigned int);
/* end of "missing" prototypes */

#else   /*!__STDC__ => -traditional */

char    *getenv(), *getcwd();
char    *___gdecl(ecvt, ());
char    *___gdecl(fcvt, ());
char    *___gdecl(gcvt, ());
int      getpid(), getppid(), setgid(), setuid();
unsigned getgid(), getuid(), getegid(), geteuid();
char    *sbrk();
int      brk(), chdir(), chmod(), chown();
char    *ctermid(), *cuserid();
int      mkdir(), nice(), umask();

#endif  /*?__STDC__*/

#undef ___gdecl         /*__GFLOAT__*/

# ifdef __cplusplus
}
# endif
#endif  /*_UNIXLIB_H*/
