/* <namdef.h>
 *
 *	RMS filename handling block.
 */
#ifndef _NAMDEF_H
#define _NAMDEF_H

/* NAM block is used to communicate optional filename-related information */
#define NAM$C_BID	2	/* code for NAM block */
#define NAM$C_MAXRSS	255	/* maximum resultant name string size (network) */
#define NAM$C_MAXRSSLCL 255	/* maximum resultant name string size (local) */

/* name option (NOP) bit mask values */
#define NAM$V_PWD	0
#define NAM$V_FILL_1	1
#define NAM$V_FILL_2	2
#define NAM$V_SYNCHK	3
#define NAM$V_NOCONCEAL 4
#define NAM$V_SLPARSE	5
#define NAM$V_SRCHXABS	6
#define NAM$M_PWD	(1<<NAM$V_PWD)		/* 0x01 */
#define NAM$M_FILL_1	(1<<NAM$V_FILL_1)	/* 0x02 */
#define NAM$M_FILL_2	(1<<NAM$V_FILL_2)	/* 0x04 */
#define NAM$M_SYNCHK	(1<<NAM$V_SYNCHK)	/* 0x08 */
#define NAM$M_NOCONCEAL (1<<NAM$V_NOCONCEAL)	/* 0x10 */
#define NAM$M_SLPARSE	(1<<NAM$V_SLPARSE)	/* 0x20 */
#define NAM$M_SRCHXABS	(1<<NAM$V_SRCHXABS)	/* 0x40 */

/* remote file system (RFS) constants */
#define NAM$C_UFS	0	/* Unknown file system for remote file access or */
				/*  not applicable for local file access or */
#define NAM$C_NO_RFS	0	/* task-to-task operation */
#define NAM$C_RMS11	1	/* RMS-11 */
#define NAM$C_RMS20	2	/* RMS-20 */
#define NAM$C_RMS32	3	/* RMS-32 */
#define NAM$C_FCS11	4	/* FCS-11 */
#define NAM$C_RT11FS	5	/* RT-11 file system */
#define NAM$C_TOPS20FS	7	/* TOPS-20 file system */
#define NAM$C_TOPS10FS	8	/* TOPS-10 file system */
#define NAM$C_RMS32S	10	/* RMS-32 subset (e.g., VAXELAN) */
#define NAM$C_CPMFS	11	/* CP/M file system */
#define NAM$C_MS_DOSFS	12	/* MS/DOS file system */
#define NAM$C_ULTRIX32_FS 13	/* Ultrix-32 file system */
#define NAM$C_ULTRIX11_FS 14	/* Ultrix-11 file system */
#define NAM$C_SNADTF_FS 15	/* SNADTF compatable FS */
#define DAP$K_SNADTF_FS 15	/* SNADTF compatable FS */

/* wildcard context (WCC) bit mask values */
#define NAM$V_IFI	16
#define NAM$V_SRCHNMF	30
#define NAM$V_SVCTX	31
#define NAM$M_IFI	(1<<NAM$V_IFI)		/* 0x00010000 */
#define NAM$M_SRCHNMF	(1<<NAM$V_SRCHNMF)	/* 0x40000000 */
#define NAM$M_SVCTX	(1<<NAM$V_SVCTX)	/* 0x80000000 */

/* file name bits (FNB) bit mask values */
#define NAM$V_EXP_VER	0
#define NAM$V_EXP_TYPE	1
#define NAM$V_EXP_NAME	2
#define NAM$V_WILD_VER	3
#define NAM$V_WILD_TYPE 4
#define NAM$V_WILD_NAME 5
#define NAM$V_EXP_DIR	6
#define NAM$V_EXP_DEV	7
#define NAM$V_WILDCARD	8
#define NAM$V_SEARCH_LIST 11
#define NAM$V_CNCL_DEV	12
#define NAM$V_ROOT_DIR	13
#define NAM$V_LOWVER	14
#define NAM$V_HIGHVER	15
#define NAM$V_PPF	16
#define NAM$V_NODE	17
#define NAM$V_QUOTED	18
#define NAM$V_GRP_MBR	19
#define NAM$V_WILD_DIR	20
#define NAM$V_DIR_LVLS	21
#define NAM$V_WILD_UFD	24
#define NAM$V_WILD_SFD1 25
#define NAM$V_WILD_SFD2 26
#define NAM$V_WILD_SFD3 27
#define NAM$V_WILD_SFD4 28
#define NAM$V_WILD_SFD5 29
#define NAM$V_WILD_SFD6 30
#define NAM$V_WILD_SFD7 31
#define NAM$V_WILD_GRP	24
#define NAM$V_WILD_MBR	25
#define NAM$M_EXP_VER	(1<<NAM$V_EXP_VER)	/* 0x01 */
#define NAM$M_EXP_TYPE	(1<<NAM$V_EXP_TYPE)	/* 0x02 */
#define NAM$M_EXP_NAME	(1<<NAM$V_EXP_NAME)	/* 0x04 */
#define NAM$M_WILD_VER	(1<<NAM$V_WILD_VER)	/* 0x08 */
#define NAM$M_WILD_TYPE (1<<NAM$V_WILD_TYPE)	/* 0x10 */
#define NAM$M_WILD_NAME (1<<NAM$V_WILD_NAME)	/* 0x20 */
#define NAM$M_EXP_DIR	(1<<NAM$V_EXP_DIR)	/* 0x40 */
#define NAM$M_EXP_DEV	(1<<NAM$V_EXP_DEV)	/* 0x80 */
#define NAM$M_WILDCARD	(1<<NAM$V_WILDCARD)	/* 0x0100 */
#define NAM$M_SEARCH_LIST (1<<NAM$V_SEARCH_LIST)  /* 0x0800 */
#define NAM$M_CNCL_DEV	(1<<NAM$V_CNCL_DEV)	/* 0x1000 */
#define NAM$M_ROOT_DIR	(1<<NAM$V_ROOT_DIR)	/* 0x2000 */
#define NAM$M_LOWVER	(1<<NAM$V_LOWVER)	/* 0x4000 */
#define NAM$M_HIGHVER	(1<<NAM$V_HIGHVER)	/* 0x8000 */
#define NAM$M_PPF	(1<<NAM$V_PPF)		/* 0x010000 */
#define NAM$M_NODE	(1<<NAM$V_NODE)		/* 0x020000 */
#define NAM$M_QUOTED	(1<<NAM$V_QUOTED)	/* 0x040000 */
#define NAM$M_GRP_MBR	(1<<NAM$V_GRP_MBR)	/* 0x080000 */
#define NAM$M_WILD_DIR	(1<<NAM$V_WILD_DIR)	/* 0x100000 */
#define NAM$S_DIR_LVLS	3
#define NAM$M_DIR_LVLS	(7<<NAM$V_DIR_LVLS)	/* 0xE00000 */
#define NAM$M_WILD_UFD	(1<<NAM$V_WILD_UFD)	/* 0x01000000 */
#define NAM$M_WILD_SFD1 (1<<NAM$V_WILD_SFD1)	/* 0x02000000 */
#define NAM$M_WILD_SFD2 (1<<NAM$V_WILD_SFD2)	/* 0x04000000 */
#define NAM$M_WILD_SFD3 (1<<NAM$V_WILD_SFD3)	/* 0x08000000 */
#define NAM$M_WILD_SFD4 (1<<NAM$V_WILD_SFD4)	/* 0x10000000 */
#define NAM$M_WILD_SFD5 (1<<NAM$V_WILD_SFD5)	/* 0x20000000 */
#define NAM$M_WILD_SFD6 (1<<NAM$V_WILD_SFD6)	/* 0x40000000 */
#define NAM$M_WILD_SFD7 (1<<NAM$V_WILD_SFD7)	/* 0x80000000 */
#define NAM$M_WILD_GRP	(1<<NAM$V_WILD_GRP)	/* 0x01000000 */
#define NAM$M_WILD_MBR	(1<<NAM$V_WILD_MBR)	/* 0x02000000 */

/* miscellaneous constants */
#define NAM$C_DVI	16	/* length of dvi field */
#define NAM$K_BLN_V2	56	/* Version 2 name block length */
#define NAM$C_BLN_V2	56
#define NAM$K_BLN_DIRWC 96	/* Not documented optional length */
#define NAM$C_BLN_DIRWC 96
#define NAM$K_BLN	96	/* Name block length */
#define NAM$C_BLN	96

struct NAM {
    unsigned char nam$b_bid;		/* block id */
    unsigned char nam$b_bln;		/* block length */
    unsigned char nam$b_rss;		/* resultant string area size */
    unsigned char nam$b_rsl;		/* resultant string length */
    char *nam$l_rsa;			/* resultant string area address */
    unsigned char nam$b_nop;		/* name options */
    unsigned char nam$b_rfs;		/* remote file system type (currently not documented) */
    unsigned char nam$b_ess;		/* espanded string area size */
    unsigned char nam$b_esl;		/* expanded string length */
    char *nam$l_esa;			/* expanded string area address */
    struct NAM *nam$l_rlf;		/* related file nam block addr */
    char nam$t_dvi[16];			/* device id */
    unsigned short nam$w_fid[3];	/* file id */
    unsigned short nam$w_did[3];	/* directory id */
    unsigned long nam$l_wcc;		/* wild card context */
    unsigned long nam$l_fnb;		/* file name status bits */
 /*- end of old short NAM block -*/
    unsigned char nam$b_node;		/* nodespec length */
    unsigned char nam$b_dev;		/* device length */
    unsigned char nam$b_dir;		/* directory length */
    unsigned char nam$b_name;		/* filename length */
    unsigned char nam$b_type;		/* filetype length */
    unsigned char nam$b_ver;		/* version number length */
    unsigned	: 8, : 8;		/* char fill[2]; */
    char *nam$l_node;			/* nodespec address */
    char *nam$l_dev;			/* device address */
    char *nam$l_dir;			/* directory address */
    char *nam$l_name;			/* filename address */
    char *nam$l_type;			/* filetype address */
    char *nam$l_ver;			/* version number address */
    unsigned	: 32, : 32;		/* long fill[2]; */
};

struct namdef {
    unsigned char nam$b_bid;		/* block id */
    unsigned char nam$b_bln;		/* block length */
    unsigned char nam$b_rss;		/* resultant string area size */
    unsigned char nam$b_rsl;		/* resultant string length */
    char *nam$l_rsa;			/* resultant string area address */
    union {
	unsigned char nam$b_nop;	/* name options */
	struct {
	    unsigned nam$v_pwd	    : 1; /* return password if present in nodespec string and any */
					 /* other task-specific data of the form /netacp_data"    */
					 /*  (default is to mask out password from expanded and   */
					 /*  resultant name strings and to create a logical name  */
					 /*  whose equivalence string is the unaltered nodespec)  */
	    unsigned nam$v_rod	    : 1; /* unused. (used to be undocumented ROD) */
	    unsigned nam$v_sod	    : 1; /* unused. (used to be undocumented SOD) */
	    unsigned nam$v_synchk   : 1; /* only do syntax check on $parse operation */
	    unsigned nam$v_noconceal: 1; /* do not conceal device/root directory */
	    unsigned nam$v_slparse  : 1; /* parse search list (not documented) -- used by BACKUP */
	    unsigned nam$v_srchxabs : 1; /* fill in attached XABS on $SEARCH operations over the */
					 /*  network (not documented) -- used by directory	 */
	    unsigned		    : 1;
	} nam$r_nop_bits;
    } nam$r_nop_overlay;
    unsigned char nam$b_rfs;		/* remote file system type (currently not documented) */
					/* note: this field is reserved for use by Digital    */
    unsigned char nam$b_ess;		/* espanded string area size */
    unsigned char nam$b_esl;		/* expanded string length */
    char *nam$l_esa;			/* expanded string area address */
    struct namdef *nam$l_rlf;		/* related file nam block addr */
    char nam$t_dvi[16];			/* device id */
    union {
	unsigned short nam$w_fid[3];	/* file id */
	struct {
	    unsigned short nam$w_fid_num;	/* file number */
	    unsigned short nam$w_fid_seq;	/* sequence number */
	    union {
		unsigned short nam$w_fid_rvn;	/* relative volume number */
		struct {
		    unsigned char nam$b_fid_rvn; /* alternate format RVN */
		    unsigned char nam$b_fid_nmx; /* alternate format file number extension */
		} nam$r_fid_rvn_fields;
	    } nam$r_fid_rvn_overlay;
	} nam$r_fid_fields;
    } nam$r_fid_overlay;
    union {
	unsigned short nam$w_did[3];	/* directory id */
	struct {
	    unsigned short nam$w_did_num;	/* file number */
	    unsigned short nam$w_did_seq;	/* sequence number */
	    union {
		unsigned short nam$w_did_rvn;	/* relative volume number */
		struct {
		    unsigned char nam$b_did_rvn; /* alternate format RVN */
		    unsigned char nam$b_did_nmx; /* alternate format file number extension */
		} nam$r_did_rvn_fields;
	    } nam$r_did_rvn_overlay;
	} nam$r_did_fields;
    } nam$r_did_overlay;
    union {
	unsigned long nam$l_wcc;	/* wild card context */
	struct {
	    unsigned		    :16; /* the first word is reserved for IFI/ACP context */
	    unsigned nam$v_ifi	    : 1; /* the first word contains an IFI */
	    unsigned		    :13; /* grow from top down, start at top bit */
	    unsigned nam$v_srchnmf  : 1; /* no-more-files has been encountered on a search */
	    unsigned nam$v_svctx    : 1; /* save context across search calls */
	} nam$r_wcc_bits;
    } nam$r_wcc_overlay;
    union {
	unsigned long nam$l_fnb;	/* file name status bits */
	struct {
	    unsigned nam$v_exp_ver  : 1; /* version was explicit */
	    unsigned nam$v_exp_type : 1; /* type was explicit */
	    unsigned nam$v_exp_name : 1; /* name was explicit */
	    unsigned nam$v_wild_ver : 1; /* version contained a wild card */
	    unsigned nam$v_wild_type: 1; /* type contained a wild card */
	    unsigned nam$v_wild_name: 1; /* name contained a wild card */
	    unsigned nam$v_exp_dir  : 1; /* directory was explicit */
	    unsigned nam$v_exp_dev  : 1; /* device was explicit */
	    unsigned nam$v_wildcard : 1; /* filename string included a wild card */
					 /* (inclusive or of other wild card bits) */
	    unsigned		    : 2; /* (spares) */
	    unsigned nam$v_search_list : 1; /* search list present */
	    unsigned nam$v_cncl_dev : 1; /* concealed device present */
	    unsigned nam$v_root_dir : 1; /* root directory present */
	    unsigned nam$v_lowver   : 1; /* lower numbered version(s) of file exist(s) */
	    unsigned nam$v_highver  : 1; /* higher " */
	    unsigned nam$v_ppf	    : 1; /* process-permanent file referenced indirectly */
	    unsigned nam$v_node     : 1; /* filename specification included a nodename */
	    unsigned nam$v_quoted   : 1; /* filename spec included a quoted string */
	    unsigned nam$v_grp_mbr  : 1; /* directory spec was of group-member format */
	    unsigned nam$v_wild_dir : 1; /* directory spec included a wild card */
	    unsigned nam$v_dir_lvls : 3; /* number of directory levels (0=ufd only) */
	} nam$r_fnb_bits0;
	struct {
	    unsigned		     :24; /* separate byte for wild card directory flags */
	    unsigned nam$v_wild_ufd  : 1; /* ufd included a wild card */
	    unsigned nam$v_wild_sfd1 : 1; /* sfd1 included a wild card */
	    unsigned nam$v_wild_sfd2 : 1; /* sfd2 included a wild card */
	    unsigned nam$v_wild_sfd3 : 1; /* sfd3 included a wild card */
	    unsigned nam$v_wild_sfd4 : 1; /* sfd4 included a wild card */
	    unsigned nam$v_wild_sfd5 : 1; /* sfd5 included a wild card */
	    unsigned nam$v_wild_sfd6 : 1; /* sfd6 included a wild card */
	    unsigned nam$v_wild_sfd7 : 1; /* sfd7 included a wild card */
	} nam$r_fnb_bits1;
	struct {
	    unsigned		     :24; /* alternate definitions for wild_ufd and wild_sfd1 */
	    unsigned nam$v_wild_grp  : 1; /* group contained a wild card */
	    unsigned nam$v_wild_mbr  : 1; /* member contained a wild card */
	    unsigned		     : 6;
	} nam$r_fnb_bits2;
    } nam$r_fnb_overlay;
 /*- end of old short NAM block -*/
    unsigned char nam$b_node;		/* nodespec length */
    unsigned char nam$b_dev;		/* device length */
    unsigned char nam$b_dir;		/* directory length */
    unsigned char nam$b_name;		/* filename length */
    unsigned char nam$b_type;		/* filetype length */
    unsigned char nam$b_ver;		/* version number length */
    unsigned	: 8, : 8;		/* char fill[2]; currently unused */
    char *nam$l_node;			/* nodespec address */
    char *nam$l_dev;			/* device address */
    char *nam$l_dir;			/* directory address */
    char *nam$l_name;			/* filename address */
    char *nam$l_type;			/* filetype address */
    char *nam$l_ver;			/* version number address */
    unsigned	: 32, : 32;		/* long fill[2]; currently unused */
};

/* declare initialized prototype data structure */
extern struct NAM cc$rms_nam __asm("_$$PsectAttributes_GLOBALSYMBOL$$cc$rms_nam");
/* globalref struct NAM cc$rms_nam; */

#endif	/*_NAMDEF_H*/
