/* <rmsdef.h>
 *
 *	RMS status codes
 */
#ifndef _RMSDEF_H
#define _RMSDEF_H

#define RMS$_FACILITY	1
/* bit 14 of STS indicates that STV contains secondary status */
#define RMS$V_STVSTATUS 14

#define RMS$_SUC	0x10001 /* 65537 */
#define RMS$_NORMAL	0x10001 /* 65537 */

/*	success codes -- bit 16 = bit 15 = 1 */
#define RMS$_STALL	0x18001  /* 98305 */	/* (note: user never receives this code) */
#define RMS$_PENDING	0x18009  /* 98313 */
#define RMS$_OK_DUP	0x18011  /* 98321 */
#define RMS$_OK_IDX	0x18019  /* 98329 */	/* record has been inserted, but index structure is no longer optimal */
#define RMS$_OK_RLK	0x18021  /* 98337 */	/* because locker set RLK in ROP field when record was locked */
#define RMS$_OK_RRL	0x18029  /* 98345 */	/* because reader set RRL in ROP field when accessing record (this code used to be OK_RRV) */
#define RMS$_OK_RRV	0x18029  /* 98345 */	/* [obsolete] */
#define RMS$_KFF	0x18031  /* 98353 */
#define RMS$_OK_ALK	0x18039  /* 98361 */
#define RMS$_OK_DEL	0x18041  /* 98369 */
#define RMS$_OK_RNF	0x18049  /* 98377 */
#define RMS$_OK_LIM	0x18051  /* 98385 */
#define RMS$_OK_NOP	0x18059  /* 98393 */
#define RMS$_OK_WAT	0x18061  /* 98401 */	/* because WAT bit in ROP was set and record was already locked */
#define RMS$_CRE_STM	0x18069  /* 98409 */
#define RMS$_OK_RULK	0x18071  /* 98417 */
#define RMS$_SYNCH	0x18079  /* 98425 */
#define RMS$_OK_ACT	0x18081  /* 98433 */
#define RMS$_OK_NOCURTID 0x18089 /* 98441 */

/*	success codes passed thru from drivers and ACP -- bit 15 = 0 */
#define RMS$_CONTROLC	0x10651  /* 67153 */	/* terminal I/O aborted due to ctrl/C */
#define RMS$_CONTROLO	0x10609  /* 67081 */	/* terminal I/O aborted due to ctrl/O */
#define RMS$_CONTROLY	0x10611  /* 67089 */	/* terminal I/O aborted due to ctrl/Y */
#define RMS$_CREATED	0x10619  /* 67097 */	/* file was created, not opened */
#define RMS$_SUPERSEDE	0x10631  /* 67121 */	/* created file superseded existing version */
#define RMS$_OVRDSKQUOTA 0x10669 /* 67177 */	/* disk usage exceeds disk quota */
#define RMS$_FILEPURGED 0x10679  /* 67193 */	/* create file caused oldest file version to be purged */

/*	warning codes -- bit 16 = bit 15 = 1, bit 14 = 0 */
#define RMS$_BOF	0x18198  /* 98712 */
#define RMS$_RNL	0x181A0  /* 98720 */
#define RMS$_RTB	0x181A8  /* 98728 */
#define RMS$_TMO	0x181B0  /* 98736 */
#define RMS$_TNS	0x181B8  /* 98744 */
#define RMS$_BES	0x181C0  /* 98752 */
#define RMS$_PES	0x181C8  /* 98760 */

/*	error codes - without STV -- bit 16 = bit 15 = 1, bit 14 = 0 */
#define RMS$_ACT	0x1825A  /* 98906 */
#define RMS$_DEL	0x18262  /* 98914 */
#define RMS$_INCOMPSHR	0x1826A  /* 98922 */
#define RMS$_DNR	0x18272  /* 98930 */
#define RMS$_EOF	0x1827A  /* 98938 */
#define RMS$_FEX	0x18282  /* 98946 */
#define RMS$_FLK	0x1828A  /* 98954 */
#define RMS$_FNF	0x18292  /* 98962 */
#define RMS$_PRV	0x1829A  /* 98970 */
#define RMS$_REX	0x182A2  /* 98978 */
#define RMS$_RLK	0x182AA  /* 98986 */
#define RMS$_RNF	0x182B2  /* 98994 */	/* record never was in file, or has been deleted */
#define RMS$_WLK	0x182BA  /* 99002 */
#define RMS$_EXP	0x182C2  /* 99010 */
#define RMS$_NMF	0x182CA  /* 99018 */
/*
   Note that SUPPORT has replaced SUP except when RMS cannot
   map the DAP status code into a FAL status code.
   Note also that SUP should have been defined as a severe
   error code.	However, SUPPORT is a severe error code.
 */
#define RMS$_SUP	0x182D2  /* 99026 */
#define RMS$_RSA	0x182DA  /* 99034 */
#define RMS$_CRC	0x182E2  /* 99042 */
#define RMS$_WCC	0x182EA  /* 99050 */
#define RMS$_IDR	0x182F2  /* 99058 */
#define RMS$_LWC	0x182FA  /* 99066 */
#define RMS$_UNUSED1	0x18302  /* 99074 */
#define RMS$_NOVALPRS	0x1830A  /* 99082 */
#define RMS$_KEY_MISMATCH 0x18312 /* 99090 */
#define RMS$_RUH	0x1831A  /* 99098 */
#define RMS$_JND	0x18322  /* 99106 */
#define RMS$_BADPHASE	0x1832A  /* 99114 */
#define RMS$_TOWDR	0x18332  /* 99122 */
#define RMS$_NEXDR	0x1833A  /* 99130 */
#define RMS$_INVDRMSG	0x18342  /* 99138 */
#define RMS$_RU_ACTIVE	0x1834A  /* 99146 */
#define RMS$_UNKRUFAC	0x18352  /* 99154 */
#define RMS$_LIMBO	0x1835A  /* 99162 */
#define RMS$_IVATRACE	0x18362  /* 99170 */
#define RMS$_OPNOTSUP	0x1836A  /* 99178 */
#define RMS$_EXTNOTFOU	0x18372  /* 99186 */
#define RMS$_EXT_ERR	0x1837A  /* 99194 */
#define RMS$_SEMANTICS	0x18382  /* 99202 */
#ifndef NO_VMS_V6
#define RMS$_LSCAN	0x1838A  /* 99210 */
#define RMS$_ROOTSRCH	0x18392  /* 99218 */
#define RMS$_IDXSEARCH	0x1839A  /* 99226 */
#define RMS$_NETBTS	0x183A2  /* 99234 */
#endif

/*	error codes - with STV error code -- bit 16 = bit 15 = bit 14 = 1 */
#define RMS$_ACC	0x1C002  /* 114690 */
#define RMS$_CRE	0x1C00A  /* 114698 */
#define RMS$_DAC	0x1C012  /* 114706 */
#define RMS$_ENT	0x1C01A  /* 114714 */
#define RMS$_EXT	0x1C022  /* 114722 */
#define RMS$_FND	0x1C02A  /* 114730 */
#define RMS$_MKD	0x1C032  /* 114738 */
#define RMS$_DPE	0x1C03A  /* 114746 */
#define RMS$_SPL	0x1C042  /* 114754 */
#define RMS$_DNF	0x1C04A  /* 114762 */
#define RMS$_RUF	0x1C052  /* 114770 */
#define RMS$_WRTJNL_AIJ 0x1C05A  /* 114778 */
#define RMS$_WRTJNL_BIJ 0x1C062  /* 114786 */
#define RMS$_WRTJNL_ATJ 0x1C06A  /* 114794 */
#define RMS$_WRTJNL_RUJ 0x1C072  /* 114802 */
#define RMS$_RRF	0x1C07A  /* 114810 */
#define RMS$_DDTM_ERR	0x1C082  /* 114818 */

/*	severe error codes - without STV -- bit 16 = bit 15 = 1, bit 14 = 0 */
#define RMS$_DTFCDDREC	0x183EC  /* 99308 */
#define RMS$_AID	0x183F4  /* 99316 */
#define RMS$_ALN	0x183FC  /* 99324 */
#define RMS$_ALQ	0x18404  /* 99332 */
#define RMS$_ANI	0x1840C  /* 99340 */
#define RMS$_AOP	0x18414  /* 99348 */
#define RMS$_BKS	0x1841C  /* 99356 */
#define RMS$_BKZ	0x18424  /* 99364 */
#define RMS$_BLN	0x1842C  /* 99372 */
#define RMS$_BUG	0x18434  /* 99380 */
#define RMS$_BUG_DDI	0x1843C  /* 99388 */
#define RMS$_BUG_DAP	0x18444  /* 99396 */
#define RMS$_BUG_RU_ACTIVE 0x1844C  /* 99404 */
#define RMS$_BUG_RURECERR 0x18454  /* 99412 */
#define RMS$_BUG_FLUSH_JNL_FAILED 0x1845C  /* 99420 */
#define RMS$_BUG_RU_ABORT_FAIL	0x18464  /* 99428 */
#define RMS$_BUG_RU_COMMIT_FAIL 0x1846C  /* 99436 */
#define RMS$_BUG_XX6	0x18474  /* 99444 */
#define RMS$_BUG_XX7	0x1847C  /* 99452 */
#define RMS$_BUG_XX8	0x18484  /* 99460 */
#define RMS$_BUSY	0x1848C  /* 99468 */
#define RMS$_CCR	0x18494  /* 99476 */
#define RMS$_CHG	0x1849C  /* 99484 */
#define RMS$_CHK	0x184A4  /* 99492 */
#define RMS$_COD	0x184AC  /* 99500 */
#define RMS$_CUR	0x184B4  /* 99508 */
#define RMS$_DAN	0x184BC  /* 99516 */
#define RMS$_DEV	0x184C4  /* 99524 */
#define RMS$_DIR	0x184CC  /* 99532 */
#define RMS$_DME	0x184D4  /* 99540 */
#define RMS$_DNA	0x184DC  /* 99548 */
#define RMS$_DTP	0x184E4  /* 99556 */
#define RMS$_DUP	0x184EC  /* 99564 */
#define RMS$_DVI	0x184F4  /* 99572 */
#define RMS$_ESA	0x184FC  /* 99580 */
#define RMS$_ESS	0x18504  /* 99588 */
#define RMS$_FAB	0x1850C  /* 99596 */
#define RMS$_FAC	0x18514  /* 99604 */
#define RMS$_FLG	0x1851C  /* 99612 */
#define RMS$_FNA	0x18524  /* 99620 */
#define RMS$_FNM	0x1852C  /* 99628 */
#define RMS$_FSZ	0x18534  /* 99636 */
#define RMS$_FOP	0x1853C  /* 99644 */
#define RMS$_FUL	0x18544  /* 99652 */
#define RMS$_IAL	0x1854C  /* 99660 */
#define RMS$_IAN	0x18554  /* 99668 */
#define RMS$_IDX	0x1855C  /* 99676 */
#define RMS$_IFI	0x18564  /* 99684 */
#define RMS$_IMX	0x1856C  /* 99692 */
#define RMS$_IOP	0x18574  /* 99700 */
#define RMS$_IRC	0x1857C  /* 99708 */
#define RMS$_ISI	0x18584  /* 99716 */
#define RMS$_KBF	0x1858C  /* 99724 */
#define RMS$_KEY	0x18594  /* 99732 */
#define RMS$_KRF	0x1859C  /* 99740 */
#define RMS$_KSZ	0x185A4  /* 99748 */
#define RMS$_LAN	0x185AC  /* 99756 */
#define RMS$_RUNDOWN	0x185B4  /* 99764 */
#define RMS$_LNE	0x185BC  /* 99772 */
#define RMS$_DTFCVT	0x185C4  /* 99780 */
#define RMS$_MRN	0x185CC  /* 99788 */
#define RMS$_MRS	0x185D4  /* 99796 */
#define RMS$_NAM	0x185DC  /* 99804 */
#define RMS$_NEF	0x185E4  /* 99812 */
#define RMS$_DTFQUASYN	0x185EC  /* 99820 */
#define RMS$_NOD	0x185F4  /* 99828 */
#define RMS$_NPK	0x185FC  /* 99836 */
#define RMS$_ORD	0x18604  /* 99844 */	/*! not used as of V4 */
#define RMS$_ORG	0x1860C  /* 99852 */
#define RMS$_PBF	0x18614  /* 99860 */
#define RMS$_PLG	0x1861C  /* 99868 */
#define RMS$_POS	0x18624  /* 99876 */
#define RMS$_DTFQUAVAL	0x1862C  /* 99884 */
#define RMS$_QUO	0x18634  /* 99892 */
#define RMS$_RAB	0x1863C  /* 99900 */
#define RMS$_RAC	0x18644  /* 99908 */
#define RMS$_RAT	0x1864C  /* 99916 */
#define RMS$_RBF	0x18654  /* 99924 */
#define RMS$_RFA	0x1865C  /* 99932 */
#define RMS$_RFM	0x18664  /* 99940 */
#define RMS$_RHB	0x1866C  /* 99948 */
#define RMS$_RLF	0x18674  /* 99956 */
#define RMS$_ROP	0x1867C  /* 99964 */
#define RMS$_RRV	0x18684  /* 99972 */
#define RMS$_RVU	0x1868C  /* 99980 */
#define RMS$_RSS	0x18694  /* 99988 */
#define RMS$_RST	0x1869C  /* 99996 */
#define RMS$_RSZ	0x186A4  /* 100004 */
#define RMS$_SEQ	0x186AC  /* 100012 */
#define RMS$_SHR	0x186B4  /* 100020 */
#define RMS$_SIZ	0x186BC  /* 100028 */
#define RMS$_SQO	0x186C4  /* 100036 */
#define RMS$_DTFSESEST	0x186CC  /* 100044 */
#define RMS$_SYN	0x186D4  /* 100052 */
#define RMS$_TRE	0x186DC  /* 100060 */
#define RMS$_TYP	0x186E4  /* 100068 */
#define RMS$_UBF	0x186EC  /* 100076 */
#define RMS$_USZ	0x186F4  /* 100084 */
#define RMS$_VER	0x186FC  /* 100092 */
#define RMS$_XNF	0x18704  /* 100100 */
#define RMS$_XAB	0x1870C  /* 100108 */
#define RMS$_ESL	0x18714  /* 100116 */
#define RMS$_DTFSESTER	0x1871C  /* 100124 */
#define RMS$_ENV	0x18724  /* 100132 */
#define RMS$_PLV	0x1872C  /* 100140 */
#define RMS$_MBC	0x18734  /* 100148 */
#define RMS$_RSL	0x1873C  /* 100156 */
#define RMS$_WLD	0x18744  /* 100164 */
/*
   note that NETFAIL has replaced NET except when RMS cannot
   map the DAP status code into a FAL status code.
 */
#define RMS$_NET	0x1874C  /* 100172 */
#define RMS$_IBF	0x18754  /* 100180 */
#define RMS$_REF	0x1875C  /* 100188 */
#define RMS$_IFL	0x18764  /* 100196 */
#define RMS$_DFL	0x1876C  /* 100204 */
#define RMS$_KNM	0x18774  /* 100212 */
#define RMS$_IBK	0x1877C  /* 100220 */
#define RMS$_KSI	0x18784  /* 100228 */
#define RMS$_LEX	0x1878C  /* 100236 */
#define RMS$_SEG	0x18794  /* 100244 */
#define RMS$_SNE	0x1879C  /* 100252 */	/*! not used as of V4 */
#define RMS$_SPE	0x187A4  /* 100260 */	/*! not used as of V4 */
#define RMS$_UPI	0x187AC  /* 100268 */
#define RMS$_ACS	0x187B4  /* 100276 */
#define RMS$_STR	0x187BC  /* 100284 */
#define RMS$_FTM	0x187C4  /* 100292 */
#define RMS$_GBC	0x187CC  /* 100300 */
#define RMS$_DEADLOCK	0x187D4  /* 100308 */
#define RMS$_EXENQLM	0x187DC  /* 100316 */
#define RMS$_JOP	0x187E4  /* 100324 */
#define RMS$_RUM	0x187EC  /* 100332 */
#define RMS$_JNS	0x187F4  /* 100340 */
#define RMS$_NRU	0x187FC  /* 100348 */
#define RMS$_IFF	0x18804  /* 100356 */
#define RMS$_DTFTRATBL	0x1880C  /* 100364 */
#define RMS$_DTFUNSTYP	0x18814  /* 100372 */
#define RMS$_DTFVERMIS	0x1881C  /* 100380 */
#ifndef NO_VMS_V6
#define RMS$_DTFACC	0x18822  /* 100386 */
#else	/* vms 5.x */
#define RMS$_DTFACC	0x18824  /* 100388 */
#endif
#define RMS$_BOGUSCOL	0x1882C  /* 100396 */
#define RMS$_ERRREADCOL 0x18834  /* 100404 */
#define RMS$_ERRWRITECOL 0x1883C /* 100412 */
#define RMS$_SNS	0x18844  /* 100420 */
#define RMS$_NOEXTEND	0x1884C  /* 100428 */
#ifndef NO_VMS_V6
#define RMS$_DTFCRE	0x18852  /* 100434 */
#else	/* vms 5.x */
#define RMS$_DTFCRE	0x18854  /* 100436 */
#endif
#define RMS$_DELJNS	0x1885C  /* 100444 */
#define RMS$_NOTSAMEJNL 0x18864  /* 100452 */
#define RMS$_SNPPF	0x1886C  /* 100460 */

/*	severe errors - with STV error code -- bit 16 = bit 15 = bit 14 = 1 */
#define RMS$_ATR	0x1C0CC  /* 114892 */
#define RMS$_ATW	0x1C0D4  /* 114900 */
#define RMS$_CCF	0x1C0DC  /* 114908 */
#define RMS$_CDA	0x1C0E4  /* 114916 */
#define RMS$_CHN	0x1C0EC  /* 114924 */
#define RMS$_RER	0x1C0F4  /* 114932 */
#define RMS$_RMV	0x1C0FC  /* 114940 */
#define RMS$_RPL	0x1C104  /* 114948 */
#define RMS$_SYS	0x1C10C  /* 114956 */
#define RMS$_WER	0x1C114  /* 114964 */
#define RMS$_WPL	0x1C11C  /* 114972 */
#define RMS$_IFA	0x1C124  /* 114980 */
#define RMS$_WBE	0x1C12C  /* 114988 */
#define RMS$_ENQ	0x1C134  /* 114996 */
#define RMS$_NETFAIL	0x1C13C  /* 115004 */
#define RMS$_SUPPORT	0x1C144  /* 115012 */
#define RMS$_CRMP	0x1C14C  /* 115020 */
#define RMS$_DTFCFGFIL	0x1C154  /* 115028 */
#define RMS$_REENT	0x1C15C  /* 115036 */
#define RMS$_ACC_RUJ	0x1C164  /* 115044 */
#define RMS$_TMR	0x1C16C  /* 115052 */
#define RMS$_ACC_AIJ	0x1C174  /* 115060 */
#define RMS$_ACC_BIJ	0x1C17C  /* 115068 */
#define RMS$_ACC_ATJ	0x1C184  /* 115076 */
#define RMS$_DTFDEFFIL	0x1C18C  /* 115084 */
#define RMS$_DTFREGFIL	0x1C194  /* 115092 */
#define RMS$_JNLNOTAUTH 0x1C19C  /* 115100 */

#endif	/*_RMSDEF_H*/
