/* <vms/stsdef.h>
 *
 *	System service status code definitions.
 */
#ifndef _VMS_STSDEF_H
#define _VMS_STSDEF_H

#define STS$V_SEVERITY	0
#define STS$M_SEVERITY	0x00000007
#define STS$S_SEVERITY	3
#define STS$V_COND_ID	3
#define STS$M_COND_ID	0x0FFFFFF8
#define STS$S_COND_ID	25
#define STS$V_CONTROL	28
#define STS$M_CONTROL	0xF0000000
#define STS$S_CONTROL	4
#define STS$V_SUCCESS	0
#define STS$M_SUCCESS	0x01
#define STS$S_SUCCESS	1
#define STS$V_MSG_NO	3
#define STS$M_MSG_NO	0x0000FFF8
#define STS$S_MSG_NO	13
#define STS$V_CODE	3
#define STS$M_CODE	0x00007FF8
#define STS$S_CODE	12
#define STS$V_FAC_SP	15
#define STS$M_FAC_SP	0x00008000
#define STS$S_FAC_SP	1
#define STS$V_CUST_DEF	27
#define STS$M_CUST_DEF	0x08000000
#define STS$S_CUST_DEF	1
#define STS$V_INHIB_MSG 28
#define STS$M_INHIB_MSG 0x10000000
#define STS$S_INHIB_MSG 1
#define STS$V_FAC_NO	16
#define STS$M_FAC_NO	0x0FFF0000
#define STS$S_FAC_NO	12
/* define severity codes */
#define STS$K_WARNING	0	/* warning */
#define STS$K_SUCCESS	1	/* successful completion */
#define STS$K_ERROR	2	/* error */
#define STS$K_INFO	3	/* information */
#define STS$K_SEVERE	4	/* severe (aka fatal) error */

union stsdef {
    struct {
	unsigned sts$v_severity : 3;	/* severity code */
	unsigned sts$v_cond_id	: 25;	/* condition id */
	unsigned sts$v_control	: 4;	/* control bits */
    } sts$r_stsdef_bits0;
    struct {
	unsigned sts$v_success	: 1;	/* success */
	unsigned		: 2;	/* skip severity field */
	unsigned sts$v_msg_no	: 13;	/* message number */
    } sts$r_stsdef_bits1;
    struct {
	unsigned		: 3;	/* skip severity field */
	unsigned sts$v_code	: 12;	/* code */
	unsigned sts$v_fac_sp	: 1;	/* 1 if facility specific */
	unsigned		: 11;
	unsigned sts$v_cust_def : 1;	/* 1 if sub-system is customer (or CSS) defined */
	unsigned sts$v_inhib_msg: 1;	/* 1 if message should not be printed */
	unsigned		: 3;	/* reserved control bits */
    } sts$r_stsdef_bits2;
    struct {
	unsigned		: 16;	/* skip message number field */
	unsigned sts$v_fac_no	: 12;	/* facility is 12 bits */
	unsigned		: 4;	/* control bits */
    } sts$r_stsdef_bits3;
};

#endif	/*_VMS_STSDEF_H*/
